/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.rcp;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.rcp.IDEWorkbenchMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class AbstractIDEApplication
implements IPlatformRunnable,
IExecutableExtension {
    private static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String OVERRIDE_SHOW_WORKSPACE_SELECTION_DIALOG_DEFAULT = "OVERRIDE_SHOW_WORKSPACE_SELECTION_DIALOG_DEFAULT";
    private static final Integer EXIT_RELAUNCH = new Integer(24);
    private static final int MIN_JVM_VERSION_MAJOR = 1;
    private static final int MIN_JVM_VERSION_MINOR = 4;
    private static final int MIN_JVM_VERSION_SERVICE = 1;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object run(Object args) throws Exception {
        block14: {
            display = this.createDisplay();
            shell = new Shell(display, 16384);
            if (!this.checkJavaRuntimeVersion(shell)) {
                Platform.endSplash();
                var7_4 = AbstractIDEApplication.EXIT_OK;
                if (display == null) return var7_4;
            }
            ** GOTO lbl-1000
            display.dispose();
            return var7_4;
lbl-1000:
            // 1 sources

            {
                if (this.checkInstanceLocation(shell)) break block14;
                Platform.endSplash();
                var5_7 = AbstractIDEApplication.EXIT_OK;
                return var5_7;
                while (true) {
                    if (display == null) return var5_7;
                    display.dispose();
                    return var5_7;
                }
                finally {
                    if (shell == null) ** continue;
                    shell.dispose();
                }
            }
        }
        returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)this.createWorkbenchAdvisor());
        if (returnCode != 1) {
            var7_5 = AbstractIDEApplication.EXIT_OK;
            if (display == null) return var7_5;
            display.dispose();
            return var7_5;
        }
        ** try [egrp 5[TRYBLOCK] [5 : 135->160)] { 
lbl34:
        // 1 sources

        return AbstractIDEApplication.EXIT_RELAUNCH.equals(Integer.getInteger("eclipse.exitcode")) != false ? AbstractIDEApplication.EXIT_RELAUNCH : AbstractIDEApplication.EXIT_RESTART;
lbl35:
        // 1 sources

        finally {
            if (display != null) {
                display.dispose();
            }
        }
    }

    protected abstract WorkbenchAdvisor createWorkbenchAdvisor();

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean checkJavaRuntimeVersion(Shell shell) {
        block4: {
            if (!AbstractIDEApplication.isCompatibleVersion(System.getProperty("java.version"))) break block4;
            return true;
        }
        try {
            String reqVersion = String.valueOf(Integer.toString(1)) + '.' + 4 + '.' + 1;
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.AbstractIDEApplication_IncompatibleJVM, (String)StringUtils.format((String)IDEWorkbenchMessages.AbstractIDEApplication_JVMVersionIsIncompatible, (String)reqVersion));
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceMandatoryTitle, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceMandatoryMessage);
            return false;
        }
        if (instanceLoc.isSet()) {
            block12: {
                if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                    return false;
                }
                if (!instanceLoc.lock()) break block12;
                AbstractIDEApplication.writeWorkspaceVersion();
                return true;
            }
            try {
                MessageDialog.openError((Shell)shell, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceCannotLockTitle, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceCannotLockMessage);
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.AbstractIDEApplication_CouldNotObtainWorkspaceLock, (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.InternalError, (String)e.getMessage());
            }
            return false;
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "org.eclipse.ui.ide");
        boolean handledSHOW_WORKSPACE_SELECTION_DIALOG = store.getBoolean(OVERRIDE_SHOW_WORKSPACE_SELECTION_DIALOG_DEFAULT);
        if (!handledSHOW_WORKSPACE_SELECTION_DIALOG) {
            store.setValue("SHOW_WORKSPACE_SELECTION_DIALOG", false);
            store.setValue(OVERRIDE_SHOW_WORKSPACE_SELECTION_DIALOG_DEFAULT, true);
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean force = false;
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData, force)) != null) {
            force = true;
            try {
                if (instanceLoc.setURL(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    AbstractIDEApplication.writeWorkspaceVersion();
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                MessageDialog.openError((Shell)shell, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                return false;
            }
            MessageDialog.openError((Shell)shell, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceInUseTitle, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceInUseMessage);
        }
        return false;
    }

    private static boolean isCompatibleVersion(String vmVersion) {
        StringTokenizer tokenizer;
        block11: {
            block10: {
                block9: {
                    if (vmVersion == null) {
                        return false;
                    }
                    tokenizer = new StringTokenizer(vmVersion, " ._");
                    if (tokenizer.hasMoreTokens()) break block9;
                    return true;
                }
                int major = Integer.parseInt(tokenizer.nextToken());
                if (major != 1) {
                    return major > 1;
                }
                if (tokenizer.hasMoreTokens()) break block10;
                return true;
            }
            int minor = Integer.parseInt(tokenizer.nextToken());
            if (minor != 4) {
                return minor > 4;
            }
            if (tokenizer.hasMoreTokens()) break block11;
            return true;
        }
        try {
            int service = Integer.parseInt(tokenizer.nextToken());
            return service >= 1;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        URL url = null;
        do {
            new ChooseWorkspaceDialog(shell, launchData, false, true).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            if (instancePath.length() <= 0) {
                MessageDialog.openError((Shell)shell, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceEmptyTitle, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceEmptyMessage);
                continue;
            }
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openError((Shell)shell, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceInvalidTitle, (String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_workspaceInvalidMessage);
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        if (url == null) {
            return false;
        }
        String version = AbstractIDEApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        String title = org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_versionTitle;
        String message = NLS.bind((String)org.eclipse.ui.internal.ide.IDEWorkbenchMessages.IDEApplication_versionMessage, (Object)url.getFile());
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = AbstractIDEApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)"Could not read version file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        block17: {
            OutputStream output;
            block16: {
                Location instanceLoc = Platform.getInstanceLocation();
                if (instanceLoc == null || instanceLoc.isReadOnly()) {
                    return;
                }
                File versionFile = AbstractIDEApplication.getVersionFile(instanceLoc.getURL(), true);
                if (versionFile == null) {
                    return;
                }
                output = null;
                try {
                    try {
                        String versionLine = "org.eclipse.core.runtime=1";
                        output = new FileOutputStream(versionFile);
                        output.write(versionLine.getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        IDEWorkbenchPlugin.log((String)"Could not write version file", (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (output != null) {
                        output.close();
                    }
                    break block17;
                }
                catch (IOException iOException) {}
                break block17;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }
}

