/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.runtime;

import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.scriptdoc.runtime.Opcode;
import com.aptana.ide.editor.scriptdoc.runtime.OpcodeType;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDocVM {
    private List<Opcode> _opcodes = new ArrayList<Opcode>();
    private Stack<Object> _stack = new Stack();

    public void addDuplicate() {
        this._opcodes.add(this.createDuplicate());
    }

    public void addGet(int fileIndex, int fileOffset) {
        this._opcodes.add(this.createGet(fileIndex, fileOffset));
    }

    public void addGetGlobal() {
        this._opcodes.add(this.createGetGlobal());
    }

    public void addInstantiate(int fileIndex, Range range) {
        this._opcodes.add(this.createInstantiate(fileIndex, range));
    }

    public void addInvoke(int fileIndex, Range range) {
        this._opcodes.add(this.createInvoke(fileIndex, range));
    }

    public void addNoOperation() {
        this._opcodes.add(this.createNoOperation());
    }

    public void addOpcode(Opcode opcode) {
        this._opcodes.add(opcode);
    }

    public void addOpcodes(List<Opcode> opcodes) {
        this._opcodes.addAll(opcodes);
    }

    public void addPop() {
        this._opcodes.add(this.createPop());
    }

    public void addPush(Object value) {
        this._opcodes.add(this.createPush(value));
    }

    public void addPushArray(int index, IRange range) {
        this._opcodes.add(this.createPushArray(index, range));
    }

    public void addPushBoolean(int index, IRange range) {
        this._opcodes.add(this.createPushBoolean(index, range));
    }

    public void addPushNull(int index, IRange range) {
        this._opcodes.add(this.createPushNull(index, range));
    }

    public void addPushNumber(int index, IRange range) {
        this._opcodes.add(this.createPushNumber(index, range));
    }

    public void addPushObject(int index, IRange range) {
        this._opcodes.add(this.createPushObject(index, range));
    }

    public void addPushRegExp(int index, IRange range) {
        this._opcodes.add(this.createPushRegExp(index, range));
    }

    public void addPushString(int index, IRange range) {
        this._opcodes.add(this.createPushString(index, range));
    }

    public void addPut(int fileIndex) {
        this._opcodes.add(this.createPut(fileIndex));
    }

    public void addSwap() {
        this._opcodes.add(this.createSwap());
    }

    public void clearOpcodes() {
        this._opcodes.clear();
    }

    public void clearStack() {
        this._stack.clear();
    }

    public Opcode createDuplicate() {
        return new Opcode(OpcodeType.DUPLICATE);
    }

    public Opcode createGet(int fileIndex, int fileOffset) {
        return new Opcode(OpcodeType.GET, fileIndex, fileOffset);
    }

    public Opcode createGetGlobal() {
        return new Opcode(OpcodeType.GET_GLOBAL);
    }

    public Opcode createInstantiate(int fileIndex, Range range) {
        return new Opcode(OpcodeType.INSTANTIATE, fileIndex, (IRange)range);
    }

    public Opcode createInvoke(int fileIndex, Range range) {
        return new Opcode(OpcodeType.INVOKE, fileIndex, (IRange)range);
    }

    public Opcode createNoOperation() {
        return new Opcode(OpcodeType.NO_OPERATION);
    }

    public Opcode createPop() {
        return new Opcode(OpcodeType.POP);
    }

    public Opcode createPush(Object value) {
        return new Opcode(OpcodeType.PUSH, value);
    }

    public Opcode createPushArray(int fileIndex, IRange range) {
        return new Opcode(OpcodeType.PUSH_ARRAY, fileIndex, range);
    }

    public Opcode createPushBoolean(int fileIndex, IRange range) {
        return new Opcode(OpcodeType.PUSH_BOOLEAN, fileIndex, range);
    }

    public Opcode createPushNull(int fileIndex, IRange range) {
        return new Opcode(OpcodeType.PUSH_NULL, fileIndex, range);
    }

    public Opcode createPushNumber(int fileIndex, IRange range) {
        return new Opcode(OpcodeType.PUSH_NUMBER, fileIndex, range);
    }

    public Opcode createPushObject(int fileIndex, IRange range) {
        return new Opcode(OpcodeType.PUSH_OBJECT, fileIndex, range);
    }

    public Opcode createPushRegExp(int fileIndex, IRange range) {
        return new Opcode(OpcodeType.PUSH_REGEXP, fileIndex, range);
    }

    public Opcode createPushString(int fileIndex, IRange range) {
        return new Opcode(OpcodeType.PUSH_STRING, fileIndex, range);
    }

    public Opcode createPut(int fileIndex) {
        return new Opcode(OpcodeType.PUT, fileIndex);
    }

    public Opcode createSwap() {
        return new Opcode(OpcodeType.SWAP);
    }

    public void execute(Environment environment) {
        Stack<Object> stack = this._stack;
        IObject[] args = new IObject[]{};
        for (Opcode opcode : this._opcodes) {
            switch (opcode.type) {
                case DUPLICATE: {
                    stack.push(stack.peek());
                    break;
                }
                case GET: {
                    String propertyName = (String)stack.pop();
                    IObject object = (IObject)stack.pop();
                    stack.push(object.getPropertyValue(propertyName, opcode.fileIndex, opcode.fileOffset));
                    break;
                }
                case GET_GLOBAL: {
                    stack.push(environment.getGlobal());
                    break;
                }
                case INSTANTIATE: {
                    IFunction function = (IFunction)stack.pop();
                    stack.push(function.construct(environment, args, opcode.fileIndex, opcode.range));
                    break;
                }
                case INVOKE: {
                    IFunction function = (IFunction)stack.pop();
                    stack.push(function.invoke(environment, args, opcode.fileIndex, opcode.range));
                    break;
                }
                case NO_OPERATION: {
                    break;
                }
                case POP: {
                    stack.pop();
                    break;
                }
                case PUT: {
                    IObject value = (IObject)stack.pop();
                    String propertyName = (String)stack.pop();
                    IObject object = (IObject)stack.pop();
                    object.putPropertyValue(propertyName, value, opcode.fileIndex);
                    break;
                }
                case PUSH: {
                    stack.push(opcode.value);
                    break;
                }
                case PUSH_ARRAY: {
                    stack.push(environment.createArray(opcode.fileIndex, opcode.range));
                    break;
                }
                case PUSH_BOOLEAN: {
                    stack.push(environment.createBoolean(opcode.fileIndex, opcode.range));
                    break;
                }
                case PUSH_NULL: {
                    stack.push(environment.createNull());
                    break;
                }
                case PUSH_NUMBER: {
                    stack.push(environment.createNumber(opcode.fileIndex, opcode.range));
                    break;
                }
                case PUSH_OBJECT: {
                    stack.push(environment.createObject(opcode.fileIndex, opcode.range));
                    break;
                }
                case PUSH_REGEXP: {
                    stack.push(environment.createRegExp(opcode.fileIndex, opcode.range));
                    break;
                }
                case PUSH_STRING: {
                    stack.push(environment.createString(opcode.fileIndex, opcode.range));
                    break;
                }
                case SWAP: {
                    int lastIndex = stack.size() - 1;
                    stack.set(lastIndex, stack.set(lastIndex - 1, stack.peek()));
                    break;
                }
            }
        }
    }

    public Opcode[] getOpcodes() {
        return this._opcodes.toArray(new Opcode[this._opcodes.size()]);
    }

    public Object[] getStackValues() {
        return this._stack.toArray(new Object[this._stack.size()]);
    }
}

