/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing.reader;

import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ForeignScriptDocInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignScriptDocManager {
    private static final String FOREIGN_SCRIPTDOC_ID = "foreign_scriptdoc";
    private static final Object TAG_STYLESHEET = "stylesheet";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_NAMESPACE = "namespace";
    private static final String ATTR_RESOURCE = "resource";
    private static ForeignScriptDocManager instance;
    private Map<String, ForeignScriptDocInfo> _infoMap;

    private ForeignScriptDocManager() {
    }

    public static ForeignScriptDocManager getInstance() {
        if (instance == null) {
            instance = new ForeignScriptDocManager();
        }
        return instance;
    }

    public ForeignScriptDocInfo getInfo(String namespace) {
        if (this._infoMap == null) {
            this._infoMap = new HashMap<String, ForeignScriptDocInfo>();
            ForeignScriptDocInfo[] foreignScriptDocInfoArray = this.loadExtensions();
            int n = 0;
            int n2 = foreignScriptDocInfoArray.length;
            while (n < n2) {
                ForeignScriptDocInfo info = foreignScriptDocInfoArray[n];
                this._infoMap.put(info.namespace, info);
                ++n;
            }
        }
        return this._infoMap.get(namespace);
    }

    private ForeignScriptDocInfo[] loadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<ForeignScriptDocInfo> frameworks = new ArrayList<ForeignScriptDocInfo>();
        if (registry != null) {
            IExtension[] extensions;
            IExtensionPoint extensionPoint = registry.getExtensionPoint(JSPlugin.ID, FOREIGN_SCRIPTDOC_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = 0;
            int n2 = iExtensionArray.length;
            while (n < n2) {
                IExtension extension = iExtensionArray[n];
                this.processExtension(extension, frameworks);
                ++n;
            }
        }
        return frameworks.toArray(new ForeignScriptDocInfo[frameworks.size()]);
    }

    private void processExtension(IExtension extension, List<ForeignScriptDocInfo> info) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_STYLESHEET)) {
                String name = element.getAttribute(ATTR_NAME);
                String namespace = element.getAttribute(ATTR_NAMESPACE);
                String stylesheetPath = element.getAttribute(ATTR_RESOURCE);
                IExtension declaring = element.getDeclaringExtension();
                String declaringPluginID = declaring.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)declaringPluginID);
                URL stylesheet = bundle.getEntry(stylesheetPath);
                info.add(new ForeignScriptDocInfo(name, namespace, stylesheet));
            }
            ++i;
        }
    }
}

