/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing;

import com.aptana.ide.editor.js.environment.LexemeConsumerHelper;
import com.aptana.ide.editor.js.runtime.Reference;
import com.aptana.ide.editor.scriptdoc.parsing.DocumentationBase;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.editors.managers.EnvironmentManager;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.metadata.IDocumentationStore;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.IParseState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScriptDocStore
implements IDocumentationStore {
    private Map<Integer, IDocumentation> _scriptObjects;
    private IParseState _parseState;

    public ScriptDocStore(IParseState parseState) {
        this._parseState = parseState;
        this._scriptObjects = new HashMap<Integer, IDocumentation>();
    }

    public void clear() {
        this._scriptObjects.clear();
    }

    public void addScriptDocObject(int offset, Lexeme lx, IDocumentation doc) {
        String uri = FileContextManager.getURIFromFileIndex((int)this._parseState.getFileIndex());
        if (this._scriptObjects.containsKey(offset)) {
            this._scriptObjects.remove(offset);
        }
        if (doc.getIDs().length > 0) {
            String[] ids;
            String id;
            Map idMap = EnvironmentManager.getDocumentationIdMap();
            if (idMap.containsKey(id = (ids = doc.getIDs())[0])) {
                IDocumentation oldDoc = (IDocumentation)idMap.get(id);
                this.mergeScriptDocs(id, oldDoc, doc);
                this._scriptObjects.put(offset, oldDoc);
                if (!"".equals(uri) && oldDoc instanceof DocumentationBase) {
                    CodeLocation[] codeLoc = doc.getID(id);
                    int i = 0;
                    while (i < codeLoc.length) {
                        CodeLocation location = codeLoc[i];
                        oldDoc.setID(id, location);
                        ++i;
                    }
                }
            } else {
                idMap.put(id, doc);
                Map refMap = EnvironmentManager.getDocumentationRefMap();
                this._scriptObjects.put(offset, doc);
                Reference ref = LexemeConsumerHelper.addDocHolderToEnvironment(id, doc, this._parseState);
                if (ref != null) {
                    refMap.put(id, ref);
                }
            }
        } else {
            this._scriptObjects.put(offset, doc);
        }
    }

    public IDocumentation getDocumentationFromOffset(int offset) {
        return this._scriptObjects.get(offset);
    }

    private void mergeScriptDocs(String id, IDocumentation originalDoc, IDocumentation addedDoc) {
        PropertyDocumentation doc2;
        String[] examples;
        String[] ids = addedDoc.getIDs();
        boolean hasMatch = false;
        int i = 0;
        while (i < ids.length) {
            if (id.equals(ids[i])) {
                hasMatch = true;
                break;
            }
            ++i;
        }
        if (!hasMatch) {
            return;
        }
        if (!addedDoc.getAuthor().equals("")) {
            originalDoc.setAuthor(addedDoc.getAuthor());
        }
        if (!addedDoc.getDescription().equals("")) {
            originalDoc.setDescription(addedDoc.getDescription());
        }
        if ((examples = addedDoc.getExamples()).length > 0) {
            int i2 = 0;
            while (i2 < examples.length) {
                originalDoc.addExample(examples[i2]);
                ++i2;
            }
        }
        if (!addedDoc.getName().equals("")) {
            originalDoc.setName(addedDoc.getName());
        }
        if (!addedDoc.getRemarks().equals("")) {
            originalDoc.setRemarks(addedDoc.getRemarks());
        }
        if (!addedDoc.getUserAgent().equals("")) {
            originalDoc.setUserAgent(addedDoc.getUserAgent());
        }
        if (!addedDoc.getVersion().equals("")) {
            originalDoc.setVersion(addedDoc.getVersion());
        }
        if (originalDoc instanceof PropertyDocumentation && addedDoc instanceof PropertyDocumentation) {
            PropertyDocumentation doc = (PropertyDocumentation)originalDoc;
            doc2 = (PropertyDocumentation)addedDoc;
            if (!doc2.getDeprecatedDescription().equals("")) {
                doc.setDeprecatedDescription(doc2.getDeprecatedDescription());
            }
            doc.setIsDeprecated(doc2.getIsDeprecated());
            doc.setIsIgnored(doc2.getIsIgnored());
            doc.setIsInstance(doc2.getIsInstance());
            doc.setIsInternal(doc2.getIsInternal());
            doc.setIsInvocationOnly(doc2.getIsInvocationOnly());
            doc.setIsNative(doc2.getIsNative());
            doc.setIsPrivate(doc2.getIsPrivate());
            doc.setIsProtected(doc2.getIsProtected());
            if (!doc2.getSince().equals("")) {
                doc.setSince(doc2.getSince());
            }
            this.mergeTypedDescriptions(doc.getAliases(), doc2.getAliases());
            this.mergeTypedDescriptions(doc.getMemberOf(), doc2.getMemberOf());
            this.mergeTypedDescriptions(doc.getReturn(), doc2.getReturn());
        }
        if (originalDoc instanceof FunctionDocumentation && addedDoc instanceof FunctionDocumentation) {
            TypedDescription description;
            int i3;
            FunctionDocumentation doc = (FunctionDocumentation)originalDoc;
            doc2 = (FunctionDocumentation)addedDoc;
            if (!doc2.getDeprecatedDescription().equals("")) {
                doc.setClassDescription(doc2.getDeprecatedDescription());
            }
            doc.setIsConstructor(((FunctionDocumentation)doc2).getIsConstructor());
            doc.setIsMethod(((FunctionDocumentation)doc2).getIsMethod());
            if (((FunctionDocumentation)doc2).getParams().length != 0) {
                doc.clearParams();
                TypedDescription[] params = ((FunctionDocumentation)doc2).getParams();
                i3 = 0;
                while (i3 < params.length) {
                    description = params[i3];
                    doc.addParam(description);
                    ++i3;
                }
            }
            if (((FunctionDocumentation)doc2).getExceptions().length != 0) {
                TypedDescription[] exceptions = ((FunctionDocumentation)doc2).getExceptions();
                doc.clearExceptions();
                i3 = 0;
                while (i3 < exceptions.length) {
                    description = exceptions[i3];
                    doc.addParam(description);
                    ++i3;
                }
            }
            this.mergeTypedDescriptions(doc.getExtends(), ((FunctionDocumentation)doc2).getExtends());
        }
    }

    private void mergeTypedDescriptions(TypedDescription originalDesc, TypedDescription addedDesc) {
        int i;
        if (!addedDesc.getName().equals("")) {
            originalDesc.setName(addedDesc.getName());
        }
        if (!addedDesc.getDescription().equals("")) {
            originalDesc.setDescription(addedDesc.getDescription());
        }
        if (addedDesc.getTypes().length != 0) {
            String[] types = addedDesc.getTypes();
            originalDesc.clearTypes();
            i = 0;
            while (i < types.length) {
                originalDesc.addType(types[i]);
                ++i;
            }
        }
        if (originalDesc.getDefaultValues().length == 0) {
            TypedDescription[] vals = addedDesc.getDefaultValues();
            originalDesc.clearDefaultValues();
            i = 0;
            while (i < vals.length) {
                originalDesc.addDefaultValue(vals[i]);
                ++i;
            }
        }
    }

    public IDocumentation[] getDocumentationObjects() {
        return this._scriptObjects.values().toArray(new IDocumentation[0]);
    }

    public int[] getDocumentationOffsets() {
        Set<Integer> docs = this._scriptObjects.keySet();
        int[] array = new int[docs.size()];
        int i = 0;
        for (Integer element : docs) {
            array[i] = element;
            ++i;
        }
        Arrays.sort(array);
        return array;
    }
}

