/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing;

import com.aptana.ide.editor.scriptdoc.parsing.AliasEntry;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.ProjectDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ScriptDoc {
    private ProjectDocumentation _project = new ProjectDocumentation();
    private FunctionDocumentation[] _functions = new FunctionDocumentation[0];
    private PropertyDocumentation[] _properties = new PropertyDocumentation[0];
    private AliasEntry[] _aliases = new AliasEntry[0];

    public AliasEntry[] getAliases() {
        if (this._aliases == null) {
            this._aliases = new AliasEntry[0];
        }
        return this._aliases;
    }

    public FunctionDocumentation[] getFunctions() {
        if (this._functions == null) {
            this._functions = new FunctionDocumentation[0];
        }
        return this._functions;
    }

    public ProjectDocumentation getProject() {
        if (this._project == null) {
            this._project = new ProjectDocumentation();
        }
        return this._project;
    }

    public PropertyDocumentation[] getProperties() {
        if (this._properties == null) {
            this._properties = new PropertyDocumentation[0];
        }
        return this._properties;
    }

    public void read(DataInput input) throws IOException {
        this._project = new ProjectDocumentation();
        this._project.read(input);
        int size = input.readInt();
        this._functions = new FunctionDocumentation[size];
        int i = 0;
        while (i < size) {
            FunctionDocumentation function = new FunctionDocumentation();
            function.read(input);
            this._functions[i] = function;
            ++i;
        }
        size = input.readInt();
        this._properties = new PropertyDocumentation[size];
        i = 0;
        while (i < size) {
            PropertyDocumentation property = new PropertyDocumentation();
            property.read(input);
            this._properties[i] = property;
            ++i;
        }
        try {
            size = input.readInt();
        }
        catch (IOException iOException) {
            size = 0;
        }
        this._aliases = new AliasEntry[size];
        i = 0;
        while (i < size) {
            this._aliases[i] = AliasEntry.read(input);
            ++i;
        }
    }

    public void setAliases(AliasEntry[] aliases) {
        this._aliases = aliases;
    }

    public void setFunctions(FunctionDocumentation[] functions) {
        this._functions = functions;
    }

    public void setProject(ProjectDocumentation project) {
        this._project = project == null ? new ProjectDocumentation() : project;
    }

    public void setProperties(PropertyDocumentation[] properties) {
        this._properties = properties;
    }

    public void write(DataOutput output) throws IOException {
        this._project.write(output);
        output.writeInt(this._functions.length);
        int i = 0;
        while (i < this._functions.length) {
            FunctionDocumentation function = this._functions[i];
            function.write(output);
            ++i;
        }
        output.writeInt(this._properties.length);
        i = 0;
        while (i < this._properties.length) {
            PropertyDocumentation property = this._properties[i];
            property.write(output);
            ++i;
        }
        output.writeInt(this._aliases.length);
        i = 0;
        while (i < this._aliases.length) {
            AliasEntry alias = this._aliases[i];
            alias.write(output);
            ++i;
        }
    }
}

