/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.formatting;

import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.context.JSFunctionInfo;
import com.aptana.ide.editor.js.context.JSLexemeUtils;
import com.aptana.ide.editor.jscomment.formatting.JSCommentAutoIndentStrategy;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class ScriptDocAutoIndentStrategy
extends JSCommentAutoIndentStrategy {
    public ScriptDocAutoIndentStrategy(EditorFileContext context, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(context, configuration, sourceViewer);
    }

    protected void indentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            if (this.indentCloseToken(d, c, offset, lineOffset, firstNonWS)) {
                return;
            }
            IPreferenceStore store = JSPlugin.getDefault().getPreferenceStore();
            boolean useStar = true;
            if (store != null) {
                useStar = store.getBoolean("UnifiedEditor.CommentIndentUseStar");
            }
            this.linePrefix = useStar ? "* " : " ";
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '/') {
                buf.append(" " + this.linePrefix);
                if (this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    String endTag = String.valueOf(lineDelimiter) + indentation + " */";
                    if (d.getLength() > firstNonWS + 2 && d.getChar(firstNonWS + 1) == '*' && d.getChar(firstNonWS + 2) == '*') {
                        d.replace(offset, 0, endTag);
                        String string = this.createJSDocTags(offset, d, c, indentation, lineDelimiter);
                        if (string != null) {
                            buf.append(string);
                        }
                    } else {
                        buf.append(endTag);
                    }
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createJSDocTags(int offset, IDocument document, DocumentCommand command, String indentation, String lineDelimiter) {
        LexemeList lexemeList = this.context.getLexemeList();
        if (lexemeList == null) {
            return null;
        }
        int start = lexemeList.getLexemeIndex(offset);
        if (start < -1) {
            start = Math.abs(start + 1);
        }
        if (++start == -1) return null;
        boolean allowVar = true;
        int maxLookahead = Math.min(lexemeList.size(), start + 25);
        int lexc = start;
        while (lexc < maxLookahead) {
            Lexeme lexeme = lexemeList.get(lexc);
            if (lexeme.typeIndex == 42 || lexeme.typeIndex == 43 || lexeme.typeIndex == 90 || lexeme.typeIndex == 91) {
                return null;
            }
            if (lexeme.typeIndex == 30) {
                if (!allowVar) return null;
                allowVar = false;
            } else if (lexeme.typeIndex == 22) {
                JSLexemeUtils utils = new JSLexemeUtils(lexemeList);
                JSFunctionInfo fi = utils.getFunctionInfo(lexc);
                if (fi == null) {
                    return null;
                }
                String params = fi.params.substring(1, fi.params.length() - 1);
                String[] args = params.trim().split(",");
                if (args.length == 1 && args[0].length() == 0) {
                    return null;
                }
                String result = "";
                int i = 0;
                while (i < args.length) {
                    if (i == 0) {
                        result = String.valueOf(result) + lineDelimiter;
                    }
                    result = String.valueOf(result) + indentation + " * @param {Object} " + args[i];
                    if (i < args.length - 1) {
                        result = String.valueOf(result) + lineDelimiter;
                    }
                    ++i;
                }
                return result;
            }
            ++lexc;
        }
        return null;
    }
}

