/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.contentassist;

import com.aptana.ide.editors.unified.contentassist.IUnifiedCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ScriptDocCompletionProposal
implements ICompletionProposal,
IUnifiedCompletionProposal {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private int fObjectType;
    public boolean defaultSelection = false;
    public boolean suggestedSelection = false;
    private Image[] userAgentImages;

    public ScriptDocCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int objectType) {
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fObjectType = objectType;
    }

    public int getObjectType() {
        return this.fObjectType;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getReplaceString() {
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public boolean isDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(boolean defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    public String getFileLocation() {
        return "";
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        this.fReplacementLength = replacementLength;
    }

    public Image[] getUserAgentImages() {
        return this.userAgentImages;
    }

    public boolean isSuggestedSelection() {
        return this.suggestedSelection;
    }

    public void setSuggestedSelection(boolean suggestedSelection) {
        this.suggestedSelection = suggestedSelection;
    }
}

