/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.parsing.JSParser;
import com.aptana.ide.editor.js.validator.ICleanup;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.ParserInitializationException;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSValidationUtils {
    private static final String JS_VALIDATE_COMMENT = "validate";
    private static final String JS_NOVALIDATE_COMMENT = "novalidate";
    private static JSParser parser;
    private static IParseState parseState;
    static ArrayList<ICleanup> cleanup;

    static {
        IConfigurationElement[] configurationElementsFor;
        cleanup = new ArrayList();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("com.aptana.ide.editor.js.languageCleanup");
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement e = iConfigurationElementArray[n];
            try {
                ICleanup createExecutableExtension = (ICleanup)e.createExecutableExtension("class");
                cleanup.add(createExecutableExtension);
            }
            catch (CoreException e1) {
                IdeLog.log((Plugin)JSPlugin.getDefault(), (int)4, (String)"unable to instantiate cleanup object", (Throwable)e1);
            }
            ++n;
        }
    }

    public static IFileError[] filterErrorsByNovalidate(IFileError[] errors, String source) throws ParserInitializationException, LexerException {
        if (parser == null) {
            parser = new JSParser();
        }
        if (parseState == null) {
            parseState = parser.createParseState(null);
        }
        parseState.setEditState(source, source, 0, 0);
        parser.parse(parseState);
        LexemeList lexemes = parseState.getLexemeList();
        return JSValidationUtils.filterErrorsByNovalidate(errors, lexemes, source);
    }

    protected static IFileError[] filterErrors(String source, UnifiedErrorReporter reporter, ArrayList<Range> ranges) {
        IFileError[] errors = reporter.getErrors();
        if (JSPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.js.ENABLE_NO_VALIDATE_COMMENT")) {
            IParser ps = LanguageRegistry.getParser((String)"text/javascript");
            IParseState createParseState = ps.createParseState(null);
            createParseState.setEditState(source, source, 0, 0);
            ArrayList<IFileError> ls = new ArrayList<IFileError>();
            try {
                ps.parse(createParseState);
            }
            catch (RuntimeException e1) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"parse exception while lexing cleared JS source", (Throwable)e1);
            }
            catch (LexerException e1) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"lexing exception while lexing cleared JS source", (Throwable)e1);
            }
            catch (ParseException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"parse exception while lexing cleared JS source", (Throwable)e);
            }
            LexemeList lexemeList = createParseState.getLexemeList();
            IFileError[] iFileErrorArray = errors;
            int n = 0;
            int n2 = iFileErrorArray.length;
            while (n < n2) {
                block8: {
                    IFileError e = iFileErrorArray[n];
                    for (Range r : ranges) {
                        Lexeme ceilingLexeme = lexemeList.getCeilingLexeme(r.getEndingOffset());
                        int le = ceilingLexeme.getEndingOffset() + 1;
                        if (e.getOffset() >= le + 1 || e.getOffset() <= r.getStartingOffset()) {
                            continue;
                        }
                        break block8;
                    }
                    ls.add(e);
                }
                ++n;
            }
            errors = new IFileError[ls.size()];
            ls.toArray(errors);
        }
        return errors;
    }

    public static String filterPIInstructions(String source, ArrayList<Range> toFill) throws LexerException, ParserInitializationException {
        StringBuilder bld = new StringBuilder(source);
        for (ICleanup c : cleanup) {
            List<Range> notJsCode = c.getNotJsCode(source);
            for (Range r : notJsCode) {
                char ch;
                toFill.add(r);
                StringBuilder spaces = new StringBuilder();
                int startingOffset = r.getStartingOffset();
                int endingOffset = r.getEndingOffset();
                boolean found = false;
                int a = startingOffset;
                while (a >= 0) {
                    ch = source.charAt(a);
                    if (ch == '\r' || ch == '\n') {
                        startingOffset = a;
                        found = true;
                        break;
                    }
                    --a;
                }
                if (!found) {
                    startingOffset = 0;
                }
                found = false;
                a = endingOffset;
                while (a < source.length()) {
                    ch = source.charAt(a);
                    if (ch == '\r' || ch == '\n') {
                        endingOffset = a;
                        found = true;
                        break;
                    }
                    ++a;
                }
                if (!found) {
                    endingOffset = source.length() - 1;
                }
                a = startingOffset;
                while (a < endingOffset) {
                    spaces.append(' ');
                    ++a;
                }
                bld.replace(startingOffset, endingOffset, spaces.toString());
            }
        }
        return bld.toString();
    }

    public static IFileError[] filterErrorsByNovalidate(IFileError[] errors, LexemeList lexemes, String source) {
        if (lexemes.size() < 2) {
            return errors;
        }
        LinkedList<IFileError> filteredErrors = new LinkedList<IFileError>();
        int currentErrorIndex = 0;
        boolean validating = true;
        int validateStartIndex = 0;
        int i = 0;
        while (i < lexemes.size() - 1) {
            Lexeme currentLexeme = lexemes.get(i);
            Lexeme nextLexeme = lexemes.get(i + 1);
            if (currentLexeme.typeIndex == 2 && nextLexeme.typeIndex == 3 && nextLexeme.getText() != null) {
                if (nextLexeme.getText().startsWith(JS_NOVALIDATE_COMMENT) && validating) {
                    validating = false;
                    currentErrorIndex = JSValidationUtils.copyErrorsFromArea(errors, filteredErrors, currentErrorIndex, validateStartIndex, currentLexeme.getStartingOffset());
                } else if (nextLexeme.getText().startsWith(JS_VALIDATE_COMMENT) && !validating) {
                    validating = true;
                    validateStartIndex = currentLexeme.getEndingOffset();
                    currentErrorIndex = JSValidationUtils.skipEmptyLineErrors(currentErrorIndex, errors, nextLexeme, source);
                }
            }
            ++i;
        }
        if (validating) {
            JSValidationUtils.copyErrorsFromArea(errors, filteredErrors, currentErrorIndex, validateStartIndex, lexemes.getAffectedRegion().getEndingOffset());
        }
        IFileError[] toReturn = new IFileError[filteredErrors.size()];
        filteredErrors.toArray(toReturn);
        return toReturn;
    }

    private static int skipEmptyLineErrors(int errorIndex, IFileError[] errors, Lexeme lexeme, String source) {
        int endLineOffset = JSValidationUtils.getEndLineIndex(lexeme.getEndingOffset(), source);
        int i = lexeme.getEndingOffset();
        while (i < endLineOffset) {
            char ch = source.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return errorIndex;
            }
            ++i;
        }
        i = errorIndex;
        while (i < errors.length) {
            IFileError currentError = errors[i];
            if (currentError.getOffset() >= endLineOffset) {
                return i;
            }
            ++i;
        }
        return errors.length;
    }

    private static int getEndLineIndex(int startOffset, String source) {
        StringReader reader = new StringReader(source);
        try {
            int currentChar;
            reader.skip(startOffset);
            int currentOffset = 0;
            int lineNumber = 1;
            while ((currentChar = reader.read()) != -1) {
                switch (currentChar) {
                    case 13: {
                        reader.mark(1);
                        int nextChar = reader.read();
                        ++currentOffset;
                        if (nextChar != 10) {
                            reader.reset();
                            --currentOffset;
                        }
                    }
                    case 10: {
                        if (currentOffset + 1 < source.length()) {
                            return currentOffset + startOffset + 1;
                        }
                        ++lineNumber;
                        break;
                    }
                }
                ++currentOffset;
            }
        }
        catch (IOException ex) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Exception searching for the line end", (Throwable)ex);
        }
        return source.length();
    }

    private static int copyErrorsFromArea(IFileError[] from, List<IFileError> to, int errorsStartIndex, int areaStartIndex, int areaEndIndex) {
        if (errorsStartIndex < from.length) {
            int errorIndex = errorsStartIndex;
            while (errorIndex < from.length) {
                IFileError currentError = from[errorIndex];
                if (currentError.getOffset() >= areaStartIndex) {
                    if (currentError.getOffset() > areaEndIndex) break;
                    to.add(currentError);
                }
                ++errorIndex;
            }
            errorsStartIndex = errorIndex;
        }
        return errorsStartIndex;
    }

    private JSValidationUtils() {
    }
}

