/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.runtime;

import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.Messages;
import com.aptana.ide.editor.js.runtime.Property;

public class Reference {
    public static final Reference Empty = new Reference();
    private IObject _objectBase;
    private String _propertyName;

    public IObject getObjectBase() {
        return this._objectBase;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    private Reference() {
    }

    public Reference(IObject objectBase, String propertyName) {
        if (objectBase == null) {
            throw new NullPointerException(Messages.Reference_ObjectBaseMustBeDefined);
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new NullPointerException(Messages.Reference_PropertyNameMustBeDefined);
        }
        this._objectBase = objectBase;
        this._propertyName = propertyName;
    }

    public Property getProperty() {
        return this._objectBase.getProperty(this._propertyName);
    }

    public IObject getValue(int fileIndex, int offset) {
        return this._objectBase.getPropertyValue(this._propertyName, fileIndex, offset);
    }

    public void setValue(IObject value, int fileIndex) {
        this._objectBase.putPropertyValue(this._propertyName, value, fileIndex);
    }

    public void unsetValue(IObject value, int fileIndex) {
        this._objectBase.unputPropertyName(this._propertyName, fileIndex, value.getStartingOffset());
    }
}

