/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.runtime;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.FunctionBase;
import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IInvokeTypeProvider;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.IScope;
import com.aptana.ide.editor.js.runtime.JSObject;
import com.aptana.ide.editor.js.runtime.JSScope;
import com.aptana.ide.editor.js.runtime.Messages;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.metadata.IDocumentation;
import org.eclipse.core.runtime.Plugin;

public class JSFunction
extends FunctionBase {
    private String[] _parameters;
    private IScope _bodyScope = new JSScope();
    private JSObject memberObject;

    public IScope getBodyScope() {
        return this._bodyScope;
    }

    public void setBodyScope(IScope scope) {
        this._bodyScope = scope;
    }

    public String getClassName() {
        return "Function";
    }

    public void setParameterNames(String[] parameters) {
        this._parameters = parameters;
    }

    public JSFunction() {
        this(null);
    }

    public JSFunction(IRange sourceRegion) {
        super(sourceRegion);
        this._bodyScope.setEnclosingFunction(this);
    }

    public String[] getParameterNames() {
        return this._parameters;
    }

    public IObject construct(Environment environment, IObject[] arguments, int fileIndex, IRange sourceRegion) {
        int offset = sourceRegion.getStartingOffset();
        IObject instance = environment.createObject(fileIndex, sourceRegion);
        IObject prototype = this.getPropertyValue("prototype", fileIndex, offset);
        instance.setPrototype(prototype);
        IObject thisInstance = this._bodyScope.getPropertyValue("this", fileIndex, offset);
        String[] thisNames = thisInstance.getLocalPropertyNames();
        int i = 0;
        while (i < thisNames.length) {
            String name = thisNames[i];
            instance.putPropertyValue(name, thisInstance.getPropertyValue(name, fileIndex, offset), fileIndex);
            ++i;
        }
        return instance;
    }

    public IObject invoke(Environment environment, IObject[] arguments, int fileIndex, IRange sourceRegion) {
        IInvokeTypeProvider typeProvider;
        IObject result = ObjectBase.UNDEFINED;
        int offset = sourceRegion.getStartingOffset();
        if (this.hasDocumentation()) {
            String typeName;
            FunctionDocumentation functionDocs = (FunctionDocumentation)this.getDocumentation();
            String[] types = functionDocs.getReturn().getTypes();
            JSScope scope = environment.getGlobal();
            if (types.length > 0 && scope.hasVariable(typeName = types[0])) {
                IObject instance = scope.getVariableValue(typeName, fileIndex, offset);
                if (instance instanceof IFunction) {
                    IFunction constructor = (IFunction)((Object)instance);
                    result = constructor.construct(environment, new IObject[0], fileIndex, sourceRegion);
                } else {
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)(String.valueOf(Messages.JSFunction_TryingToConstructWithNonFunction) + typeName));
                }
            }
        }
        if (result == ObjectBase.UNDEFINED && (typeProvider = this.getInvokeTypeProvider()) != null) {
            result = typeProvider.getInvokeReturnType(environment, arguments, fileIndex, sourceRegion);
        }
        return result;
    }

    public void setParameters(String[] parameters) {
        this._parameters = parameters;
    }

    public String getMemberOf() {
        PropertyDocumentation pdoc;
        String[] rettypes;
        String result = null;
        IDocumentation doc = this.getDocumentation();
        if (doc != null && doc instanceof PropertyDocumentation && (rettypes = (pdoc = (PropertyDocumentation)doc).getMemberOf().getTypes()).length > 0) {
            result = rettypes[0];
        }
        return result;
    }

    public JSObject getGuessedMemberObject() {
        return this.memberObject;
    }

    public void setGuessedMemberObject(JSObject classObject) {
        this.memberObject = classObject;
    }
}

