/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.preferences;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.preferences.GeneralPreferencePage;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;

public class CodeAssistPreferencePage
extends com.aptana.ide.editors.preferences.CodeAssistPreferencePage {
    private Map<File, Image> images = new HashMap<File, Image>();
    private CheckboxTableViewer envTable;

    public void createFieldEditors() {
        IExtensionPoint extensionPoint;
        super.createFieldEditors();
        Composite appearanceComposite = this.getFieldEditorParent();
        Composite table = GeneralPreferencePage.createGroup((Composite)appearanceComposite, (String)"JavaScript Environments");
        table.getParent().setLayoutData((Object)new GridData(4, 4, true, true));
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        table.setLayout((Layout)layout);
        Label envLabel = new Label(table, 16448);
        envLabel.setText("Environments that will be present in Code Assist.");
        envLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.envTable = CheckboxTableViewer.newCheckList((Composite)table, (int)67588);
        this.envTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        String[] environments = JSLanguageEnvironment.getEnabledEnvironments();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(JSPlugin.ID, "scriptdoc")) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    IExtension declaring = element.getDeclaringExtension();
                    String declaringPluginID = declaring.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)declaringPluginID);
                    String agent = element.getAttribute("user-agent");
                    String icon = element.getAttribute("icon");
                    if (agent != null) {
                        File file;
                        String iconFile;
                        TableItem item = new TableItem(this.envTable.getTable(), 0);
                        item.setText(agent);
                        if (icon != null && (iconFile = CodeAssistPreferencePage.getResolvedFilename(bundle, icon)) != null && (file = new File(iconFile)).exists()) {
                            Image result = null;
                            result = this.images.containsKey(file.getAbsolutePath()) ? this.images.get(file.getAbsolutePath()) : new Image((Device)Display.getDefault(), file.getAbsolutePath());
                            this.images.put(file.getAbsoluteFile(), result);
                            item.setImage(result);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        TableItem[] items = this.envTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            String label = items[i].getText();
            int j = 0;
            while (j < environments.length) {
                if (label.equals(environments[j])) {
                    items[i].setChecked(true);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void dispose() {
        Iterator<Image> iter = this.images.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        super.dispose();
    }

    private static URL getResolvedURL(Bundle b, String fullPath) {
        URL url = FileLocator.find((Bundle)b, (IPath)new Path(fullPath), null);
        if (url != null) {
            try {
                URL localUrl = FileLocator.toFileURL((URL)url);
                if (localUrl != null) {
                    return localUrl;
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)e.getMessage());
            }
        }
        return null;
    }

    private static String getResolvedFilename(Bundle b, String fullPath) {
        URL url = CodeAssistPreferencePage.getResolvedURL(b, fullPath);
        if (url != null) {
            return url.getFile();
        }
        return null;
    }

    public boolean performOk() {
        TableItem[] items = this.envTable.getTable().getItems();
        ArrayList<String> environments = new ArrayList<String>();
        ArrayList<String> disabledEnvironments = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                environments.add(items[i].getText().trim());
            } else {
                disabledEnvironments.add(items[i].getText().trim());
            }
            ++i;
        }
        JSLanguageEnvironment.setEnabledEnvironments(environments.toArray(new String[0]));
        JSLanguageEnvironment.setDisabledEnvironments(disabledEnvironments.toArray(new String[0]));
        JSLanguageEnvironment.resetEnvironment();
        return super.performOk();
    }

    protected void performDefaults() {
        String[] envs = JSLanguageEnvironment.getDefaultLoadedEnvironments();
        TableItem[] items = this.envTable.getTable().getItems();
        int k = 0;
        while (k < items.length) {
            items[k].setChecked(false);
            int j = 0;
            while (j < envs.length) {
                String agent = envs[j];
                if (agent.equals(items[k].getText())) {
                    items[k].setChecked(true);
                    break;
                }
                ++j;
            }
            ++k;
        }
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSPlugin.getDefault().getPreferenceStore();
    }

    protected Plugin doGetPlugin() {
        return JSPlugin.getDefault();
    }

    public void init(IWorkbench workbench) {
    }
}

