/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.parsing.nodes;

import com.aptana.ide.editor.js.parsing.nodes.JSParseNode;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;

public class JSStringNode
extends JSParseNode {
    private int _quoteType;
    private boolean _unclosed;

    public JSStringNode(Lexeme startLexeme) {
        super(68, startLexeme);
        String text = startLexeme.getText();
        char firstChar = text.charAt(0);
        this._quoteType = firstChar == '\"' ? 1 : 2;
        boolean bl = this._unclosed = startLexeme.getCategoryIndex() == 0;
        if (this._unclosed) {
            this.setAttribute("text", text.substring(1, text.length()));
        } else {
            this.setAttribute("text", text.substring(1, text.length() - 1));
        }
    }

    public int getQuoteType() {
        return this._quoteType;
    }

    public void getSource(SourceWriter writer) {
        if (this._quoteType == 1) {
            writer.print("\"" + this.getAttribute("text"));
            if (!this._unclosed) {
                writer.print("\"");
            }
        } else {
            writer.print("'" + this.getAttribute("text"));
            if (!this._unclosed) {
                writer.print("'");
            }
        }
    }

    public void setQuoteType(int quoteType) {
        this._quoteType = quoteType;
    }
}

