/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.parsing;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.parsing.JSLanguageRegistry;
import com.aptana.ide.editor.js.parsing.JSParseState;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.folding.GenericCommentNode;
import com.aptana.ide.editors.unified.parsing.UnifiedParser;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.text.ParseException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public abstract class JSParserBase
extends UnifiedParser {
    private static final String NESTED_LANGUAGE_ID = "nested_languages";
    private static final String DOCUMENTATION_DELIMITER_GROUP = "documentation-delimiter";
    private static final String LINE_DELIMITER_GROUP = "line-delimiter";
    private static final String DEFAULT_GROUP = "default";
    protected IParseNode _currentParentNode;
    protected JSLanguageRegistry _languageRegistry;
    protected String _piLanguage;
    private boolean _fastScan = UnifiedEditorsPlugin.getDefault().useFastScan();

    public JSParserBase() throws ParserInitializationException {
        this("text/javascript");
    }

    public JSParserBase(String language) throws ParserInitializationException {
        super(language);
    }

    protected void addChildParsers() throws ParserInitializationException {
        super.addChildParsers();
        if (this._languageRegistry == null) {
            this._languageRegistry = new JSLanguageRegistry();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry != null) {
                IExtension[] extensions;
                IExtensionPoint extensionPoint = registry.getExtensionPoint(JSPlugin.ID, NESTED_LANGUAGE_ID);
                IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                int n = 0;
                int n2 = iExtensionArray.length;
                while (n < n2) {
                    IExtension extension = iExtensionArray[n];
                    IParser[] parsers = this.isScanner() ? this._languageRegistry.loadScannersFromExtension(extension) : this._languageRegistry.loadParsersFromExtension(extension);
                    IParser[] iParserArray = parsers;
                    int n3 = 0;
                    int n4 = iParserArray.length;
                    while (n3 < n4) {
                        IParser parser = iParserArray[n3];
                        this.addChildParser(parser);
                        ++n3;
                    }
                    ++n;
                }
            }
        }
    }

    protected void advance() throws LexerException {
        ILexer lexer = this.getLexer();
        Lexeme currentLexeme = EOS;
        if (this._currentParentNode != null && this.currentLexeme != null && this.currentLexeme != EOS) {
            this._currentParentNode.includeLexemeInRange(this.currentLexeme);
        }
        if (!lexer.isEOS()) {
            boolean inWhitespace = true;
            boolean lastWasEOL = false;
            while (inWhitespace) {
                if (!lexer.isEOS()) {
                    currentLexeme = this.getNextLexemeInLanguage();
                    if (currentLexeme != null && currentLexeme != EOS) {
                        if (currentLexeme.typeIndex != 5) {
                            this.addLexeme(currentLexeme);
                        }
                        if (currentLexeme.getCategoryIndex() == 1) {
                            if (currentLexeme.typeIndex == 4 || currentLexeme.typeIndex == 3) {
                                GenericCommentNode node = new GenericCommentNode(currentLexeme.getStartingOffset(), currentLexeme.getEndingOffset(), "HTMLCOMMENT", "text/javascript");
                                this.getParseState().addCommentRegion((IParseNode)node);
                            }
                            lastWasEOL = currentLexeme.typeIndex == 5;
                            continue;
                        }
                        inWhitespace = false;
                        if (!lastWasEOL) continue;
                        currentLexeme.setAfterEOL();
                        continue;
                    }
                    currentLexeme = EOS;
                    inWhitespace = false;
                    continue;
                }
                currentLexeme = EOS;
                inWhitespace = false;
            }
        }
        this.currentLexeme = currentLexeme;
    }

    private Lexeme checkForLanguageTransition(Lexeme lexeme) throws LexerException {
        Lexeme result = lexeme;
        if (lexeme != null && lexeme != EOS) {
            String terminator = null;
            String mimeType = null;
            switch (lexeme.typeIndex) {
                case 82: {
                    this.onPIOpen();
                    this.advance();
                    break;
                }
                case 92: {
                    this.advance();
                    break;
                }
                case 7: {
                    terminator = DOCUMENTATION_DELIMITER_GROUP;
                    mimeType = "text/scriptdoc";
                    break;
                }
                case 6: {
                    terminator = DOCUMENTATION_DELIMITER_GROUP;
                    mimeType = "text/jscomment";
                    break;
                }
                case 2: {
                    terminator = LINE_DELIMITER_GROUP;
                    mimeType = "text/jscomment";
                    break;
                }
            }
            if (terminator != null && mimeType != null) {
                int offset;
                ILexer lexer = this.getLexer();
                lexer.setCurrentOffset(lexeme.offset);
                Range range = lexer.find(terminator);
                int n = offset = lexeme.typeIndex == 2 ? range.getStartingOffset() : range.getEndingOffset();
                if (range.isEmpty()) {
                    offset = lexer.getSourceLength();
                }
                try {
                    this.changeLanguage(mimeType, offset, this._currentParentNode);
                }
                catch (LexerException lexerException) {
                }
                catch (ParseException parseException) {}
                this.advance();
                result = this.currentLexeme;
            }
        }
        return result;
    }

    public IParseState createParseState(IParseState parent) {
        JSParseState result;
        IParseState root = parent;
        if (parent == null) {
            result = new JSParseState();
            root = result.getRoot();
        } else {
            result = new JSParseState(root);
        }
        IParser jsCommentParser = this.getParserForMimeType("text/jscomment");
        IParser scriptDocParser = this.getParserForMimeType("text/scriptdoc");
        if (jsCommentParser != null) {
            result.addChildState(jsCommentParser.createParseState(root));
        }
        if (scriptDocParser != null) {
            result.addChildState(scriptDocParser.createParseState(root));
        }
        return result;
    }

    protected Lexeme getNextLexemeInLanguage() throws LexerException {
        if (!this._fastScan) {
            Lexeme result = super.getNextLexemeInLanguage();
            result = this.checkForLanguageTransition(result);
            return result;
        }
        ILexer lexer = this.getLexer();
        Lexeme result = null;
        while (result == null && !lexer.isEOS()) {
            result = lexer.getNextLexeme();
            if (result != null && result != EOS) {
                String terminator = null;
                String mimeType = null;
                String text = result.getText();
                int textLength = text.length();
                int offset = 0;
                if (textLength >= 2) {
                    block1 : switch (text.charAt(0)) {
                        case '/': {
                            block6 : switch (text.charAt(1)) {
                                case '*': {
                                    if (textLength == 3 && text.charAt(2) == '*') {
                                        terminator = DOCUMENTATION_DELIMITER_GROUP;
                                        mimeType = "text/scriptdoc";
                                    } else {
                                        terminator = DOCUMENTATION_DELIMITER_GROUP;
                                        mimeType = "text/jscomment";
                                    }
                                    char[] source = lexer.getSourceUnsafe();
                                    int eof = lexer.getEOFOffset();
                                    offset = result.getEndingOffset();
                                    while (offset < eof) {
                                        if (source[offset] == '*' && offset + 1 < eof && source[offset + 1] == '/') {
                                            offset += 2;
                                            break block6;
                                        }
                                        ++offset;
                                    }
                                    break block1;
                                }
                                case '/': {
                                    terminator = LINE_DELIMITER_GROUP;
                                    mimeType = "text/jscomment";
                                    char[] source = lexer.getSourceUnsafe();
                                    int eof = lexer.getEOFOffset();
                                    offset = result.getEndingOffset();
                                    while (offset < eof) {
                                        char current = source[offset];
                                        if (current == '\r' || current == '\n') break block1;
                                        ++offset;
                                    }
                                    break block6;
                                }
                            }
                            break;
                        }
                        case '<': {
                            if (text.charAt(1) != '?') break;
                            this.onPIOpen();
                            this.advance();
                            break;
                        }
                        case '?': {
                            if (text.charAt(1) != '>') break;
                            this.advance();
                        }
                    }
                }
                if (terminator != null && mimeType != null) {
                    lexer.setCurrentOffset(result.offset);
                    try {
                        this.changeLanguage(mimeType, offset, this._currentParentNode);
                    }
                    catch (LexerException lexerException) {
                    }
                    catch (ParseException parseException) {}
                    this.advance();
                    result = this.currentLexeme;
                } else if (!result.getLanguage().equals(this.getLanguage())) {
                    LexemeList lexemes = this.getLexemeList();
                    lexemes.getAffectedRegion().includeInRange(result);
                    this.removeLexeme(result);
                    lexer.setCurrentOffset(result.offset);
                    result = lexer.getNextLexeme();
                }
            }
            if (result != null || lexer.isEOS()) continue;
            if ("error".equals(lexer.getGroup())) break;
            lexer.setGroup("error");
            result = lexer.getNextLexeme();
            if (result == null && "error".equals(lexer.getGroup())) break;
        }
        return result;
    }

    public void initializeLexer() throws LexerException {
        ILexer lexer = this.getLexer();
        String language = this.getLanguage();
        lexer.setIgnoreSet(language, new int[]{1});
        lexer.setLanguageAndGroup(language, DEFAULT_GROUP);
    }

    public boolean isScanner() {
        return false;
    }

    protected void onPIOpen() {
        try {
            if (this._piLanguage != null) {
                this.changeLanguage(this._piLanguage, Integer.MAX_VALUE, this._currentParentNode);
            }
        }
        catch (LexerException e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Lexing exception", (Throwable)e);
        }
        catch (ParseException e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Parsing exception", (Throwable)e);
        }
    }
}

