/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.parsing;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.parsing.Messages;
import com.aptana.ide.editor.js.parsing.nodes.JSParseNodeFactory;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.OrderedObject;
import com.aptana.ide.editor.js.runtime.OrderedObjectCollection;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.js.runtime.Reference;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDocParseState;
import com.aptana.ide.metadata.IDocumentationStore;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import com.aptana.ide.parsing.ParseStateChild;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

public class JSParseState
extends ParseStateChild {
    public JSParseState() {
        super("text/javascript");
    }

    public JSParseState(IParseState parent) {
        super("text/javascript", parent);
    }

    public IDocumentationStore getDocumentationStore() {
        IParseState[] children = this.getChildren();
        IDocumentationStore result = null;
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IParseState state = children[i];
                if (state instanceof ScriptDocParseState) {
                    result = ((ScriptDocParseState)state).getDocumentationStore();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected IParseNodeFactory createParseNodeFactory() {
        return new JSParseNodeFactory((IParseState)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadFromEnvironment() {
        IRuntimeEnvironment environment;
        IRuntimeEnvironment iRuntimeEnvironment = environment = JSLanguageEnvironment.getInstance().getRuntimeEnvironment();
        synchronized (iRuntimeEnvironment) {
            Map updatedProperties = this.getUpdatedProperties();
            for (Property p : updatedProperties.keySet()) {
                Reference reference = (Reference)updatedProperties.get(p);
                String propertyName = reference.getPropertyName();
                IObject parentObject = reference.getObjectBase();
                this.unsetPropertyValue(p, propertyName, parentObject, this.getFileIndex());
            }
            updatedProperties.clear();
        }
    }

    private void unsetPropertyValue(Property p, String propertyName, IObject parentObject, int fileIndex) {
        if (p == null) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.JSParseState_NullPropertyPassedIn);
            return;
        }
        if (propertyName == null) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.JSParseState_NullPropertyNamePassedIn);
        }
        OrderedObjectCollection c = p.getAssignments();
        int i = 0;
        while (i < c.size()) {
            OrderedObject obj = c.get(i);
            if (obj == null) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSParseState_ObjectNullForProperty, (String)propertyName));
            } else if (obj.fileIndex == fileIndex) {
                IObject objObject = obj.object;
                if (objObject != null) {
                    c.remove(obj.fileIndex, objObject.getStartingOffset());
                } else {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSParseState_ObjObjectNullForProperty, (String)propertyName));
                }
                --i;
            }
            ++i;
        }
        if (parentObject == null) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSParseState_ParentObjectNullForProperty, (String)propertyName));
            return;
        }
        if (!p.hasAssignments() && !p.isPermanent()) {
            parentObject.deletePropertyName(propertyName);
        }
    }
}

