/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.outline;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.outline.Messages;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import java.util.Collections;

public class Reference {
    private String _scope;
    private String _name;
    private String _type;

    public Reference(IParseNode node, String name, String type) {
        if (node == null) {
            throw new IllegalArgumentException(Messages.Reference_Node_Not_Defined);
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.Reference_Name_Not_Defined);
        }
        if (type == null) {
            throw new IllegalArgumentException(Messages.Reference_Type_Not_Defined);
        }
        this._scope = Reference.createScopeString(node);
        this._name = name;
        this._type = type;
    }

    public Reference(String scope, String name, String type) {
        if (scope == null) {
            throw new IllegalArgumentException(Messages.Reference_Scope_Not_Defined);
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.Reference_Name_Not_Defined);
        }
        if (type == null) {
            throw new IllegalArgumentException(Messages.Reference_Type_Not_Defined);
        }
        this._scope = scope;
        this._name = name;
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public String getScope() {
        return this._scope;
    }

    public static String createScopeString(IParseNode node) {
        ArrayList<String> parts = new ArrayList<String>();
        IParseNode currentNode = node;
        switch (currentNode.getTypeIndex()) {
            case 64: 
            case 71: {
                IParseNode parent = currentNode.getParent();
                if (parent.getTypeIndex() == 14) {
                    if (parent.getChild(1) == currentNode) {
                        parts.add(parent.getSource());
                    }
                } else {
                    parts.add(currentNode.getText());
                }
                currentNode = parent;
                break;
            }
            case 14: {
                parts.add(currentNode.getChild(0).getSource());
                currentNode = currentNode.getParent();
                break;
            }
            case 47: {
                IParseNode greatgrandparent;
                IParseNode grandparent;
                IParseNode parent = currentNode.getParent();
                if (parent != null && parent.getTypeIndex() == 70 && (grandparent = parent.getParent()) != null && grandparent.getTypeIndex() == 59 && (greatgrandparent = grandparent.getParent()) != null && greatgrandparent.getTypeIndex() == 53) {
                    parts.add(String.valueOf(greatgrandparent.getChild(0).getSource()) + ".");
                }
                currentNode = parent;
                break;
            }
        }
        while (currentNode != null) {
            if (currentNode.getTypeIndex() == 47) {
                if (currentNode.hasAttribute("name")) {
                    parts.add(currentNode.getAttribute("name"));
                } else {
                    IParseNode parentNode = currentNode.getParent();
                    IParseNode grandParentNode = null;
                    if (parentNode != null) {
                        grandParentNode = parentNode.getParent();
                    }
                    if (parentNode != null && grandParentNode != null && parentNode.getTypeIndex() == 74 && grandParentNode.getTypeIndex() == 49) {
                        currentNode = grandParentNode;
                    } else {
                        String path = "";
                        IParseNode p = currentNode;
                        while (p != null) {
                            path = "[" + p.getChildIndex() + "]" + p.getName() + path;
                            p = p.getParent();
                        }
                        parts.add(path);
                    }
                }
            } else if (currentNode.getTypeIndex() == 70) {
                IParseNode property = currentNode.getChild(0);
                String name = property.getText();
                parts.add(name);
            } else if (currentNode.getTypeIndex() == 41) {
                IParseNode identifier = currentNode.getChild(0);
                IParseNode assignedValue = currentNode.getChild(1);
                String name = identifier.getText();
                if (assignedValue.getTypeIndex() == 59) {
                    parts.add(name);
                }
            }
            currentNode = currentNode.getParent();
        }
        Collections.reverse(parts);
        return "/" + StringUtils.join((String)"/", (String[])parts.toArray(new String[parts.size()]));
    }

    public String getPartsString() {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        sb.append(this._scope).append("','");
        sb.append(this._type).append("','");
        sb.append(this._name);
        sb.append("')");
        return sb.toString();
    }

    public String toString() {
        String result = this._scope.equals(this._type) ? String.valueOf(this._scope) + this._name : String.valueOf(this._scope) + this._type + this._name;
        return result;
    }
}

