/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.outline;

import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.outline.JSOutlineItem;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class JSLabelProvider
extends LabelProvider
implements IPropertyChangeListener,
IColorProvider {
    private static final Image PROPERTY_ICON = JSPlugin.getImage("icons/js_property.gif");
    private static final Image ARRAY_ICON = JSPlugin.getImage("icons/array-literal.png");
    private static final Image BOOLEAN_ICON = JSPlugin.getImage("icons/boolean.png");
    private static final Image FUNCTION_ICON = JSPlugin.getImage("icons/js_function.gif");
    private static final Image NULL_ICON = JSPlugin.getImage("icons/null.png");
    private static final Image NUMBER_ICON = JSPlugin.getImage("icons/number.png");
    private static final Image OBJECT_LITERAL_ICON = JSPlugin.getImage("icons/object-literal.png");
    private static final Image REGEX_ICON = JSPlugin.getImage("icons/regex.png");
    private static final Image STRING_ICON = JSPlugin.getImage("icons/string.png");

    public JSLabelProvider() {
        IPreferenceStore prefStore = JSPlugin.getDefault().getPreferenceStore();
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.updatePrivateMemberPrefix();
    }

    public Image getImage(Object element) {
        Image result;
        if (element instanceof JSOutlineItem) {
            JSOutlineItem item = (JSOutlineItem)((Object)element);
            switch (item.getType()) {
                case 0: {
                    result = PROPERTY_ICON;
                    break;
                }
                case 1: {
                    result = ARRAY_ICON;
                    break;
                }
                case 2: {
                    result = BOOLEAN_ICON;
                    break;
                }
                case 3: {
                    result = FUNCTION_ICON;
                    break;
                }
                case 4: {
                    result = NULL_ICON;
                    break;
                }
                case 5: {
                    result = NUMBER_ICON;
                    break;
                }
                case 6: {
                    result = OBJECT_LITERAL_ICON;
                    break;
                }
                case 7: {
                    result = REGEX_ICON;
                    break;
                }
                case 8: {
                    result = STRING_ICON;
                    break;
                }
                default: {
                    result = super.getImage(element);
                    break;
                }
            }
        } else {
            result = super.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String result;
        if (element instanceof JSOutlineItem) {
            JSOutlineItem item = (JSOutlineItem)((Object)element);
            result = item.getLabel();
        } else {
            result = super.getText(element);
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.aptana.ide.editor.js.PREFERENCE_PRIVATE_FIELD_INDICATOR")) {
            this.updatePrivateMemberPrefix();
            UnifiedOutlineProvider.getInstance().refresh();
        }
    }

    private void updatePrivateMemberPrefix() {
        IPreferenceStore prefStore = JSPlugin.getDefault().getPreferenceStore();
        String prefix = prefStore.getString("com.aptana.ide.editor.js.PREFERENCE_PRIVATE_FIELD_INDICATOR");
        UnifiedOutlineProvider.getInstance().setPrivateMemberPrefix("text/javascript", prefix);
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }
}

