/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.outline;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.outline.JSOutlineItem;
import com.aptana.ide.editor.js.outline.Messages;
import com.aptana.ide.editor.js.outline.Reference;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSContentProvider
implements ITreeContentProvider {
    private static final String CONTAINER_TYPE = "/";
    private static final String PROPERTY_TYPE = ".";
    private static final Set<String> CLASS_EXTENDERS = new HashSet<String>();
    private Map<String, JSOutlineItem> _itemsByScope = new HashMap<String, JSOutlineItem>();

    static {
        CLASS_EXTENDERS.add("dojo.lang.extend");
        CLASS_EXTENDERS.add("Ext.extend");
        CLASS_EXTENDERS.add("jQuery.extend");
        CLASS_EXTENDERS.add("MochiKit.Base.update");
        CLASS_EXTENDERS.add("Object.extend");
        CLASS_EXTENDERS.add("qx.Class.define");
        CLASS_EXTENDERS.add("qx.Interface.define");
        CLASS_EXTENDERS.add("qx.Theme.define");
        CLASS_EXTENDERS.add("qx.Mixin.define");
    }

    private void addValue(List<JSOutlineItem> elements, Reference reference, IParseNode value) {
        this.addValue(elements, reference, value, null);
    }

    private void addValue(List<JSOutlineItem> elements, Reference reference, IParseNode value, IParseNode parent) {
        boolean processed = false;
        switch (value.getTypeIndex()) {
            case 47: {
                this.processFunction(elements, value, reference);
                processed = true;
                break;
            }
            case 49: {
                IParseNode child = value.getChild(0);
                if (child.getTypeIndex() == 47) {
                    this.processFunction(elements, child, reference);
                    processed = true;
                    break;
                }
                value = child;
                break;
            }
        }
        if (!processed) {
            String path;
            int type = this.getOutlineType(value);
            int count = 0;
            if (value.getTypeIndex() == 59) {
                count = value.getChildCount();
            }
            if (parent == null) {
                parent = value.getParent();
            }
            if (!this._itemsByScope.containsKey(path = reference.toString())) {
                JSOutlineItem item = new JSOutlineItem(reference.getName(), type, (IRange)parent, value, count);
                this._itemsByScope.put(path, item);
                elements.add(item);
            }
        }
    }

    private void addVirtualChild(List<JSOutlineItem> elements, Reference reference, IParseNode node, IParseNode target) {
        JSOutlineItem item;
        String key = reference.getScope();
        if (this._itemsByScope.containsKey(key)) {
            item = this._itemsByScope.get(key);
        } else {
            int type = node.getTypeIndex() == 47 ? 3 : 0;
            item = new JSOutlineItem(node.getText(), type, (IRange)node, node);
            this._itemsByScope.put(key, item);
            elements.add(item);
        }
        item.addVirtualChild(target);
    }

    public void dispose() {
    }

    private int getChildCount(IParseNode node) {
        int result = 0;
        int i = 0;
        while (i < node.getChildCount()) {
            IParseNode child = node.getChild(i);
            switch (child.getTypeIndex()) {
                case 1: {
                    boolean ofInterest;
                    IParseNode lhs = child.getChild(0);
                    IParseNode rhs = child.getChild(1);
                    int lhsTypeIndex = lhs.getTypeIndex();
                    int rhsTypeIndex = rhs.getTypeIndex();
                    boolean identifierOrProperty = lhsTypeIndex == 64 || lhsTypeIndex == 14;
                    boolean bl = ofInterest = rhsTypeIndex == 47 || rhsTypeIndex == 59 || rhsTypeIndex == 49;
                    if (!identifierOrProperty || !ofInterest) break;
                    ++result;
                    break;
                }
                case 47: 
                case 62: {
                    ++result;
                    break;
                }
                case 38: 
                case 48: 
                case 61: 
                case 72: {
                    result += this.getChildCount(child);
                    break;
                }
                case 83: {
                    IParseNode grandchild;
                    if (child.getChildCount() <= 0 || (grandchild = child.getChild(0)).getTypeIndex() != 59) break;
                    ++result;
                    break;
                }
                case 49: {
                    IParseNode grandchild;
                    if (child.getChildCount() <= 0 || (grandchild = child.getChild(0)).getTypeIndex() != 47) break;
                    ++result;
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = null;
        if (parentElement instanceof JSOutlineItem) {
            JSOutlineItem item = (JSOutlineItem)((Object)parentElement);
            Object[] elements = this.getElements(item.getReferenceNodes());
            IEditorInput input = item.getEditorInput();
            if (input != null) {
                int a = 0;
                while (a < elements.length) {
                    JSOutlineItem element;
                    Object object = elements[a];
                    if (object instanceof JSOutlineItem && (element = (JSOutlineItem)((Object)object)).getEditorInput() == null) {
                        element.setResolveInformation(input);
                        element.setParent(item);
                    }
                    ++a;
                }
            }
            result = elements;
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<JSOutlineItem> elements = new ArrayList<JSOutlineItem>();
        if (inputElement instanceof IParseNode[]) {
            IParseNode[] nodes = (IParseNode[])inputElement;
            int i = 0;
            while (i < nodes.length) {
                this.processNode(elements, nodes[i]);
                ++i;
            }
        } else if (inputElement instanceof IParseNode) {
            this._itemsByScope.clear();
            this.processNode(elements, (IParseNode)inputElement);
        }
        return elements.toArray(new Object[elements.size()]);
    }

    private int getOutlineType(IParseNode node) {
        int result;
        switch (node.getTypeIndex()) {
            case 54: {
                result = 1;
                break;
            }
            case 63: 
            case 69: {
                result = 2;
                break;
            }
            case 47: {
                result = 3;
                break;
            }
            case 65: {
                result = 4;
                break;
            }
            case 66: {
                result = 5;
                break;
            }
            case 59: {
                result = 6;
                break;
            }
            case 67: {
                result = 7;
                break;
            }
            case 68: {
                result = 8;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        IParseNode result = null;
        if (element instanceof JSOutlineItem) {
            JSOutlineItem item = (JSOutlineItem)((Object)element);
            result = item.getReferenceNode().getParent();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof JSOutlineItem) {
            JSOutlineItem item = (JSOutlineItem)((Object)element);
            result = item.getChildCount() > 0;
        }
        return result;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private void processAssignment(List<JSOutlineItem> elements, IParseNode lhs, IParseNode rhs) {
        int rhsTypeIndex = rhs.getTypeIndex();
        switch (lhs.getTypeIndex()) {
            case 68: {
                if (rhsTypeIndex != 47 && rhsTypeIndex != 59) break;
                String text = lhs.getSource();
                Reference reference = new Reference(lhs.getParent(), text.substring(1, text.length() - 1), CONTAINER_TYPE);
                this.addValue(elements, reference, rhs);
                break;
            }
            case 64: {
                if (rhsTypeIndex == 47 || rhsTypeIndex == 59) {
                    Reference reference = new Reference(lhs.getParent(), lhs.getText(), CONTAINER_TYPE);
                    this.addValue(elements, reference, rhs);
                    break;
                }
                if (rhsTypeIndex != 49 || rhs.getChildCount() != 2) break;
                IParseNode child = rhs.getChild(0);
                Reference reference = new Reference(lhs.getParent(), lhs.getText(), CONTAINER_TYPE);
                this.addValue(elements, reference, child);
                break;
            }
            case 14: {
                IParseNode target = null;
                while (lhs.getTypeIndex() == 14) {
                    target = lhs.getChild(1);
                    lhs = lhs.getChild(0);
                }
                if (lhs.getTypeIndex() != 64 && lhs.getTypeIndex() != 71) break;
                String scopeString = Reference.createScopeString(lhs.getParent());
                if (this._itemsByScope.containsKey(scopeString)) {
                    Reference reference = new Reference(scopeString, target.getText(), CONTAINER_TYPE);
                    this.addVirtualChild(elements, reference, lhs, target);
                    break;
                }
                IParseNode node = lhs;
                Reference reference = new Reference(node, lhs.getText(), CONTAINER_TYPE);
                this.addValue(elements, reference, target);
                JSOutlineItem item = this._itemsByScope.get(scopeString);
                item.addVirtualChild(target);
                break;
            }
        }
    }

    private void processFunction(List<JSOutlineItem> elements, IParseNode node, Reference reference) {
        String fullpath;
        IParseNode parameters = node.getChild(0);
        IParseNode body = node.getChild(1);
        String name = node.hasAttribute("name") ? node.getAttribute("name") : (reference != null ? reference.getName() : "<literal>");
        String label = String.valueOf(name) + "(" + parameters.getSource() + ")";
        int count = this.getChildCount(body);
        if (reference == null) {
            reference = new Reference(node, name, CONTAINER_TYPE);
        }
        if (!this._itemsByScope.containsKey(fullpath = reference.toString())) {
            JSOutlineItem item = new JSOutlineItem(label, 3, (IRange)node, body, count);
            this._itemsByScope.put(fullpath, item);
            elements.add(item);
        }
    }

    private void processIdentifier(List<JSOutlineItem> elements, IParseNode node) {
        IParseNode grandparent;
        IParseNode rhs;
        IParseNode parent = node.getParent();
        if (parent.hasChildren() && (rhs = parent.getChild(1)) == node && (grandparent = parent.getParent()) != null) {
            IParseNode target = grandparent.getChild(1);
            switch (grandparent.getTypeIndex()) {
                case 53: {
                    target = grandparent.getChild(grandparent.getChildCount() - 1);
                    Reference reference = new Reference(parent, rhs.getText(), PROPERTY_TYPE);
                    String parentFullPath = reference.toString();
                    int i = 0;
                    while (i < target.getChildCount()) {
                        IParseNode keyValuePair = target.getChild(i);
                        String keyString = keyValuePair.getChild(0).getSource();
                        Reference keyValueReference = new Reference(parentFullPath, keyString, PROPERTY_TYPE);
                        this.addVirtualChild(elements, keyValueReference, node, keyValuePair);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    Reference reference = new Reference(parent, rhs.getText(), PROPERTY_TYPE);
                    this.addValue(elements, reference, target);
                    break;
                }
                case 14: {
                    IParseNode property = grandparent.getChild(1);
                    Reference reference = new Reference(grandparent, property.getText(), PROPERTY_TYPE);
                    this.addVirtualChild(elements, reference, node, target);
                    break;
                }
            }
        }
    }

    private void processInvoke(List<JSOutlineItem> elements, IParseNode node) {
        block14: {
            IParseNode lhs;
            block12: {
                IParseNode args;
                block13: {
                    lhs = node.getChild(0);
                    String source = lhs.getSource();
                    if (!CLASS_EXTENDERS.contains(source)) break block12;
                    args = node.getChild(1);
                    if (args.getTypeIndex() != 53 || args.getChildCount() != 2) break block13;
                    IParseNode arg1 = args.getChild(0);
                    IParseNode arg2 = args.getChild(1);
                    if (arg2.getTypeIndex() == 59) {
                        switch (arg1.getTypeIndex()) {
                            case 14: 
                            case 64: 
                            case 68: {
                                this.processAssignment(elements, arg1, arg2);
                                break;
                            }
                        }
                    }
                    break block14;
                }
                if (args.getTypeIndex() != 53 || args.getChildCount() != 3) break block14;
                IParseNode arg1 = args.getChild(0);
                IParseNode arg3 = args.getChild(2);
                if (arg3.getTypeIndex() != 59) break block14;
                switch (arg1.getTypeIndex()) {
                    case 14: 
                    case 64: 
                    case 68: {
                        this.processAssignment(elements, arg1, arg3);
                        break;
                    }
                }
                break block14;
            }
            if (lhs.getTypeIndex() == 74) {
                IParseNode[] nodes = lhs.getChildren();
                int i = 0;
                while (i < nodes.length) {
                    IParseNode node2 = nodes[i];
                    if (node2.getTypeIndex() == 47 && !node.hasAttribute("name")) {
                        IParseNode[] grandChildren = node2.getChildren();
                        int j = 0;
                        while (j < grandChildren.length) {
                            IParseNode node3 = grandChildren[j];
                            this.processNode(elements, node3);
                            ++j;
                        }
                    } else {
                        this.processNode(elements, node2);
                    }
                    ++i;
                }
            }
        }
    }

    private void processNameValuePair(List<JSOutlineItem> elements, IParseNode node) {
        IParseNode property = node.getChild(0);
        IParseNode value = node.getChild(1);
        String name = property.getText();
        int type = this.getOutlineType(value);
        if (property.getTypeIndex() == 68) {
            name = name.substring(1, name.length());
        }
        switch (value.getTypeIndex()) {
            case 47: {
                this.processFunction(elements, value, new Reference(value, name, ""));
                break;
            }
            case 59: {
                elements.add(new JSOutlineItem(name, type, (IRange)node, value, value.getChildCount()));
                break;
            }
            default: {
                elements.add(new JSOutlineItem(name, type, (IRange)node, value));
            }
        }
    }

    private void processNode(List<JSOutlineItem> elements, IParseNode node) {
        try {
            switch (node.getTypeIndex()) {
                case 1: {
                    this.processAssignment(elements, node.getChild(0), node.getChild(1));
                    break;
                }
                case 47: {
                    this.processFunction(elements, node, null);
                    break;
                }
                case 74: {
                    if (node.getChildCount() > 0) {
                        this.processNode(elements, node.getChild(0));
                    }
                    break;
                }
                case 64: {
                    this.processIdentifier(elements, node);
                    break;
                }
                case 49: {
                    this.processInvoke(elements, node);
                    break;
                }
                case 70: {
                    this.processNameValuePair(elements, node);
                    break;
                }
                case 59: {
                    int i = 0;
                    while (i < node.getChildCount()) {
                        this.processNode(elements, node.getChild(i));
                        ++i;
                    }
                    break;
                }
                case 83: {
                    IParseNode child;
                    if (node.getChildCount() > 0 && (child = node.getChild(0)).getTypeIndex() == 59) {
                        int i = 0;
                        while (i < child.getChildCount()) {
                            this.processNode(elements, child.getChild(i));
                            ++i;
                        }
                    }
                    break;
                }
                case 61: {
                    int typeIndex;
                    IParseNode child;
                    int i = 0;
                    while (i < node.getChildCount()) {
                        child = node.getChild(i);
                        if (child.getTypeIndex() == 47 && child.hasAttribute("name")) {
                            this.processNode(elements, child);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < node.getChildCount()) {
                        child = node.getChild(i);
                        if (child.getTypeIndex() == 62) {
                            this.processNode(elements, child);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < node.getChildCount()) {
                        child = node.getChild(i);
                        typeIndex = child.getTypeIndex();
                        if (typeIndex == 1 || typeIndex == 64 || typeIndex == 70 || typeIndex == 49 || typeIndex == 83) {
                            this.processNode(elements, child);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < node.getChildCount()) {
                        child = node.getChild(i);
                        typeIndex = child.getTypeIndex();
                        if (typeIndex == 48) {
                            this.processNode(elements, child);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < node.getChildCount()) {
                        child = node.getChild(i);
                        typeIndex = child.getTypeIndex();
                        if (typeIndex == 72 || typeIndex == 38) {
                            this.processNode(elements, child);
                        }
                        ++i;
                    }
                    break;
                }
                case 38: 
                case 48: 
                case 72: {
                    int i = 0;
                    while (i < node.getChildCount()) {
                        IParseNode child = node.getChild(i);
                        this.processNode(elements, child);
                        ++i;
                    }
                }
                case 71: {
                    this.processIdentifier(elements, node);
                    break;
                }
                case 62: {
                    this.processVar(elements, node);
                    break;
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.JSContentProvider_Error_Processing_Parse_Node, (Throwable)e);
        }
    }

    private void processVar(List<JSOutlineItem> elements, IParseNode node) {
        int i = 0;
        while (i < node.getChildCount()) {
            IParseNode declaration = node.getChild(i);
            IParseNode identifier = declaration.getChild(0);
            IParseNode assignedValue = declaration.getChild(1);
            if (assignedValue.getTypeIndex() != 43) {
                while (assignedValue.getTypeIndex() == 1) {
                    assignedValue = assignedValue.getChild(1);
                }
            }
            Reference reference = new Reference(node, identifier.getText(), CONTAINER_TYPE);
            this.addValue(elements, reference, assignedValue, node);
            ++i;
        }
    }
}

