/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.formatting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.formatting.IFormattingCallback;
import com.aptana.ide.editor.js.formatting.JSCodeFormatterOptions;
import com.aptana.ide.editor.js.parsing.JSParseState;
import com.aptana.ide.editor.js.parsing.nodes.JSBinaryOperatorAssignNode;
import com.aptana.ide.editor.js.parsing.nodes.JSBinaryOperatorNode;
import com.aptana.ide.editor.js.parsing.nodes.JSFunctionNode;
import com.aptana.ide.editor.js.parsing.nodes.JSLabelNode;
import com.aptana.ide.editor.js.parsing.nodes.JSNaryAndExpressionNode;
import com.aptana.ide.editor.js.parsing.nodes.JSNaryNode;
import com.aptana.ide.editor.js.parsing.nodes.JSParseNode;
import com.aptana.ide.editor.js.parsing.nodes.JSPrimitiveNode;
import com.aptana.ide.editor.js.parsing.nodes.JSStringNode;
import com.aptana.ide.editor.js.parsing.nodes.JSTextNode;
import com.aptana.ide.editor.js.parsing.nodes.JSUnaryOperatorNode;
import com.aptana.ide.editor.js.parsing.nodes.JSVarNode;
import com.aptana.ide.editors.unified.BaseFormatter;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.folding.GenericCommentNode;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;

public class JSCodeFormatter
extends BaseFormatter {
    private String source = null;
    private HashMap<IParseNode, IFormattingCallback> markedNodes = new HashMap();
    private int indentLevel = 0;
    private JSCodeFormatterOptions codeoptions;
    private boolean nextBlockNoNewLine;
    private boolean nextReturnNoNewLine;
    private boolean nextIfNoNewLine;
    private boolean nextBlockFunctionBody;
    private boolean nextBlockInCase;
    private LexemeList lexemes;
    private SourceWriter writer;
    private Lexeme currentLexeme;
    private List commentNodes = new ArrayList();
    private boolean shouldPrint = true;
    Pattern newLinePattern = Pattern.compile(".*(\r|\n|\r\n)*.*");
    private Lexeme noFormatStart;
    private Lexeme noFormatEnd;
    private Lexeme lastLineEndingAdjusted = null;

    private List buildCommentNodes(String source, IParseNode[] nodes, LexemeList lexemes) {
        ArrayList<CommentNode> cNodes = new ArrayList<CommentNode>();
        int i = 0;
        while (i < nodes.length) {
            GenericCommentNode curr = (GenericCommentNode)nodes[i];
            CommentNode cn = new CommentNode();
            cn.node = curr;
            String substring = source.substring(curr.getStartingOffset(), curr.getEndingOffset());
            if (substring.indexOf(13) != -1 || substring.indexOf(10) != -1) {
                cn.isMultiline = true;
            } else {
                cn.isMultiline = false;
                if ("//FORMAT".equalsIgnoreCase(substring.trim())) {
                    cn.isFormat = true;
                } else if ("//NOFORMAT".equalsIgnoreCase(substring.trim())) {
                    cn.isNoFormat = true;
                }
            }
            cNodes.add(cn);
            ++i;
        }
        int level = 0;
        int i2 = 0;
        while (i2 < lexemes.size()) {
            Lexeme curr = lexemes.get(i2);
            if (curr.typeIndex == 34) {
                ++level;
                Lexeme next = UnifiedEditor.findBalancingLexeme((LexemeList)lexemes, (int)i2, (String)"text/javascript", (int)curr.typeIndex, (int)42, (int)1);
                int j = 0;
                while (j < cNodes.size()) {
                    CommentNode cn = (CommentNode)cNodes.get(j);
                    GenericCommentNode comment = cn.node;
                    if (comment.getStartingOffset() > curr.getStartingOffset() && next != null && comment.getStartingOffset() < next.getStartingOffset()) {
                        cn.indentLevel = level;
                    }
                    ++j;
                }
            } else if (curr.typeIndex == 42) {
                --level;
            }
            ++i2;
        }
        return cNodes;
    }

    public void addMarkedNode(IParseNode node, IFormattingCallback cb) {
        this.markedNodes.put(node, cb);
    }

    public void configureWriter(int level, String indentString, int indentSize) {
        this.writer = new SourceWriter(level, indentString, indentSize);
    }

    public String format(String source, boolean isSelection, Map options, IProject project, String separator) {
        return this.format(source, options, project, separator);
    }

    public String format(String source, Map options, IProject project, String separator) {
        JSCodeFormatterOptions cOptions = new JSCodeFormatterOptions(options, project);
        if (!cOptions.doFormatting) {
            return source;
        }
        IParser parser = LanguageRegistry.getParser((String)"text/javascript");
        JSParseState parseState = (JSParseState)parser.createParseState(null);
        parseState.setEditState(source, source, 0, 0);
        try {
            LexemeList lexemes = parseState.getLexemeList();
            IParseNode parseNode = parser.parse((IParseState)parseState);
            IParseNode[] comments = parseState.getCommentRegions();
            return this.format(source, source, parseNode, lexemes, comments, cOptions, separator);
        }
        catch (LexerException lexerException) {
        }
        catch (ParseException parseException) {}
        return source;
    }

    public String format(String wholeSource, String contentToFormat, IParseNode parseNode, LexemeList lexemes, IParseNode[] comments, JSCodeFormatterOptions options, String separator) {
        this.source = wholeSource;
        this.codeoptions = options == null ? new JSCodeFormatterOptions() : options;
        if (!this.codeoptions.doFormatting) {
            return contentToFormat;
        }
        this.shouldPrint = true;
        this.lexemes = lexemes;
        this.commentNodes = this.buildCommentNodes(wholeSource, comments, lexemes);
        String formatted = this.formatGivenNode(contentToFormat, parseNode, separator);
        IParser parser = LanguageRegistry.getParser((String)"text/javascript");
        if (!this.isFormattingCorrect(lexemes, parser, contentToFormat, formatted, new int[]{3}, null)) {
            formatted = contentToFormat;
        }
        this.lastLineEndingAdjusted = null;
        this.commentNodes.clear();
        this.currentLexeme = null;
        this.noFormatEnd = null;
        this.noFormatStart = null;
        this.shouldPrint = true;
        this.markedNodes.clear();
        this.writer = null;
        return formatted;
    }

    public String formatGivenNode(String source, IParseNode parse, String lineDelimeter) {
        this.nextBlockNoNewLine = false;
        if (this.checkError(parse)) {
            return this.doLexerBasedFormat(source);
        }
        if (this.lexemes == null) {
            return source;
        }
        int a = 0;
        while (a < this.lexemes.size()) {
            Lexeme lexeme = this.lexemes.get(a);
            if (lexeme.getToken().getCategoryIndex() == 0) {
                return source;
            }
            ++a;
        }
        if (this.writer == null) {
            String indent = this.codeoptions.formatterTabChar;
            if (indent.length() == 0) {
                indent = " ";
            }
            if (indent.charAt(0) == ' ') {
                StringBuffer bf = new StringBuffer();
                int a2 = 0;
                while (a2 < this.codeoptions.tabSize) {
                    bf.append(' ');
                    ++a2;
                }
                indent = bf.toString();
            }
            this.configureWriter(this.indentLevel, indent, this.codeoptions.tabSize);
        }
        if (lineDelimeter != null) {
            this.writer.setLineDelimeter(lineDelimeter);
        }
        this.format(parse, this.writer);
        int i = 0;
        while (i < this.commentNodes.size()) {
            CommentNode cn = (CommentNode)this.commentNodes.get(i);
            if (!cn.printed) {
                if (!this.shouldPrint) {
                    this.writer.println();
                }
                this.shouldPrint = true;
                this.printComment(cn);
                cn.printed = true;
                if (!cn.isMultiline) {
                    this.printRemainingCommentLineEnding();
                }
            }
            ++i;
        }
        this.markedNodes.clear();
        String formatted = this.writer.toString();
        if (this.codeoptions.preserveLineBreaks) {
            String start = this.getStartLineBreaks(this.writer, source, formatted);
            String end = this.getEndLineBreaks(this.writer, source, formatted);
            formatted = String.valueOf(start) + formatted + end;
        }
        return formatted;
    }

    private String doLexerBasedFormat(String source) {
        return source;
    }

    private boolean checkError(IParseNode parse) {
        if (parse.getTypeIndex() == -1) {
            return true;
        }
        int a = 0;
        while (a < parse.getChildCount()) {
            if (this.checkError(parse.getChild(a))) {
                return true;
            }
            ++a;
        }
        return false;
    }

    private void format(IParseNode node, SourceWriter writer) {
        if (!(node instanceof JSParseNode)) {
            return;
        }
        JSParseNode jsnode = (JSParseNode)node;
        this.writeFormattedSource(jsnode, writer, true);
    }

    private void writeFormattedSource(JSParseNode jsnode, SourceWriter writer, boolean appendTrailing) {
        if (jsnode instanceof JSBinaryOperatorNode) {
            JSBinaryOperatorNode bnode = (JSBinaryOperatorNode)jsnode;
            this.writeBinaryNode(bnode, writer);
            return;
        }
        if (jsnode instanceof JSFunctionNode) {
            JSFunctionNode lnode = (JSFunctionNode)jsnode;
            this.writeFunctionNode(lnode, writer);
            return;
        }
        if (jsnode instanceof JSLabelNode) {
            JSLabelNode lnode = (JSLabelNode)jsnode;
            this.writeLabelNode(lnode, writer);
            return;
        }
        if (jsnode instanceof JSNaryNode) {
            JSNaryNode nnode = (JSNaryNode)jsnode;
            this.writeNaryNode(nnode, writer);
            return;
        }
        if (jsnode instanceof JSPrimitiveNode) {
            JSPrimitiveNode pnode = (JSPrimitiveNode)jsnode;
            this.writePrimitiveNode(pnode, writer);
            return;
        }
        if (jsnode instanceof JSStringNode) {
            JSStringNode snode = (JSStringNode)jsnode;
            this.writeStringNode(snode, writer);
            return;
        }
        if (jsnode instanceof JSTextNode) {
            JSTextNode tnode = (JSTextNode)jsnode;
            this.writeTextNode(tnode, writer);
            return;
        }
        if (jsnode instanceof JSUnaryOperatorNode) {
            JSUnaryOperatorNode unode = (JSUnaryOperatorNode)jsnode;
            this.writeUnaryOperatorNode(unode, writer);
            return;
        }
        if (jsnode instanceof JSVarNode) {
            JSVarNode vnode = (JSVarNode)jsnode;
            this.writeVarNode(vnode, writer);
            return;
        }
        if (jsnode.getTypeIndex() == -1) {
            this.printLexeme(jsnode.getStartingLexeme());
        } else {
            this.writeCommon(jsnode, writer, appendTrailing);
        }
    }

    private Lexeme[] getLexemesBetweenNode(IParseNode first, IParseNode second) {
        return this.getLexemesBetweenLexemes(first.getEndingLexeme(), second.getStartingLexeme());
    }

    private Lexeme[] getLexemesBetweenLexemes(Lexeme first, Lexeme second) {
        ArrayList<Lexeme> between = new ArrayList<Lexeme>();
        int firstIndex = this.lexemes.getLexemeIndex(first);
        int secondIndex = this.lexemes.getLexemeIndex(second);
        if (secondIndex - 1 > firstIndex) {
            int i = firstIndex + 1;
            while (i < secondIndex) {
                Lexeme curr = this.lexemes.get(i);
                if (curr.getLanguage().equals("text/javascript")) {
                    between.add(curr);
                }
                ++i;
            }
        }
        return between.toArray(new Lexeme[0]);
    }

    private Lexeme getNextLexeme() {
        return this.getNextLexeme(this.currentLexeme);
    }

    private Lexeme getNextLexeme(Lexeme lexeme) {
        int index;
        Lexeme next = null;
        boolean found = false;
        if (lexeme != null) {
            index = this.lexemes.getLexemeIndex(lexeme);
        } else {
            index = 0;
            if (this.lexemes.size() > 0 && (next = this.lexemes.get(0)) != null && next.getLanguage().equals("text/javascript") && next.getCategoryIndex() != 1) {
                found = true;
            }
        }
        while (!found) {
            if (index > -1 && index + 1 < this.lexemes.size()) {
                next = this.lexemes.get(index + 1);
                if (next != null && next.getLanguage().equals("text/javascript") && next.getCategoryIndex() != 1) {
                    found = true;
                    continue;
                }
                ++index;
                continue;
            }
            found = true;
        }
        return next;
    }

    private Lexeme getPreviousLexeme() {
        Lexeme next = null;
        if (this.currentLexeme != null) {
            int index = this.lexemes.getLexemeIndex(this.currentLexeme);
            boolean found = false;
            while (!found) {
                if (index - 1 <= 0) break;
                next = this.lexemes.get(index - 1);
                if (next != null && next.getLanguage().equals("text/javascript") && next.getCategoryIndex() != 1) {
                    found = true;
                    continue;
                }
                --index;
            }
            if (!found) {
                next = null;
            }
        }
        return next;
    }

    private Lexeme getNextLexemeIfOfType(int type) {
        Lexeme next = this.getNextLexeme();
        if (next != null && next.typeIndex == type) {
            return next;
        }
        return null;
    }

    private void printNextLexemeIfOfType(int type) {
        Lexeme next = this.getNextLexemeIfOfType(type);
        if (next != null) {
            this.printLexeme(next);
        }
    }

    private void printComment(CommentNode node) {
        if (node != null) {
            if (node.isMultiline) {
                this.printMultilineComment(node.node);
            } else {
                this.printSinglelineComment(node.node);
            }
        }
    }

    private void printSinglelineComment(GenericCommentNode node) {
        try {
            String substring = this.source.substring(node.getStartingOffset(), node.getEndingOffset());
            this.print(substring);
        }
        catch (Exception exception) {}
    }

    private void printMultilineComment(GenericCommentNode node) {
        String substring = this.source.substring(node.getStartingOffset(), node.getEndingOffset());
        String[] split = this.splitOnLines(substring);
        if (split.length > 1) {
            this.adjustCommentIndent();
            this.print(split[0]);
            this.printLineEnding((IParseNode)node, 1, false);
            int i = 1;
            while (i < split.length) {
                this.printIndent();
                this.print(' ');
                this.print(split[i].trim());
                this.printLineEnding((IParseNode)node, 1, false);
                ++i;
            }
        } else {
            this.writer.print(substring);
        }
    }

    private void adjustCommentIndent() {
        if (!this.shouldPrint) {
            return;
        }
        String buffer = this.writer.toString();
        if (buffer.length() > 0) {
            String trailing = "";
            int index = buffer.length() - 1;
            char spacing = buffer.charAt(index);
            if (spacing == ' ' || spacing == '\t') {
                while (index > -1 && buffer.charAt(index) == spacing) {
                    trailing = String.valueOf(trailing) + spacing;
                    --index;
                }
                String ending = this.writer.getIndentText();
                if (ending.length() > trailing.length()) {
                    int diff = ending.length() - trailing.length();
                    int i = 0;
                    while (i < diff) {
                        this.writer.print(spacing);
                        ++i;
                    }
                }
            } else {
                this.writer.printIndent();
            }
        }
    }

    private void handleNoFormatting(CommentNode cn) {
        int endingOffset = this.source.length();
        this.noFormatStart = this.lexemes.getLexemeFromOffset(cn.node.getStartingOffset());
        this.noFormatEnd = this.lexemes.get(this.lexemes.size() - 1);
        int j = 0;
        while (j < this.commentNodes.size()) {
            CommentNode format = (CommentNode)this.commentNodes.get(j);
            if (format.isFormat && format.node.getStartingOffset() > cn.node.getStartingOffset()) {
                endingOffset = format.node.getEndingOffset();
                this.noFormatEnd = this.lexemes.getFloorLexeme(format.node.getEndingOffset());
                break;
            }
            ++j;
        }
        String unformatted = this.source.substring(cn.node.getStartingOffset(), endingOffset);
        int j2 = 0;
        while (j2 < this.commentNodes.size()) {
            CommentNode format = (CommentNode)this.commentNodes.get(j2);
            if (format.node.getStartingOffset() >= cn.node.getStartingOffset() && format.node.getEndingOffset() <= endingOffset) {
                format.printed = true;
            }
            ++j2;
        }
        int end = this.lexemes.getLexemeIndex(this.noFormatEnd);
        this.noFormatEnd = end + 1 < this.lexemes.size() ? this.getNextLexeme(this.noFormatEnd) : null;
        this.print(unformatted);
        this.shouldPrint = false;
    }

    private void printAdjustedIndent() {
        this.adjustCommentIndent();
    }

    private void print(char c) {
        if (this.shouldPrint) {
            this.writer.print(c);
        }
    }

    private void print(String string) {
        if (this.shouldPrint) {
            this.writer.print(string);
        }
    }

    private void printIndent() {
        if (this.shouldPrint) {
            this.writer.printIndent();
        }
    }

    private void printPreviousLineEnding(Lexeme lexeme, IParseNode node, int lineCount, boolean advance) {
        int index;
        if (lexeme != null && (index = this.lexemes.getLexemeIndex(lexeme)) > 0) {
            Lexeme format = this.lexemes.get(index - 1);
            this.printLineEnding(format, node, lineCount, advance);
        }
    }

    private void printLexeme(Lexeme lexeme) {
        Lexeme nextCheck = this.getNextLexeme();
        if (this.noFormatEnd != null) {
            this.noFormatStart = lexeme;
        }
        if (this.currentLexeme == null || nextCheck != null && nextCheck.equals((Object)lexeme)) {
            GenericCommentNode comment;
            CommentNode cn;
            this.currentLexeme = lexeme;
            if (this.noFormatStart != this.noFormatEnd) {
                return;
            }
            if (!this.shouldPrint && this.currentLexeme != null) {
                this.shouldPrint = true;
                this.printPreviousLineEnding(this.noFormatEnd, null, 0, false);
                this.printAdjustedIndent();
            } else {
                this.shouldPrint = true;
            }
            this.noFormatStart = null;
            this.noFormatEnd = null;
            Lexeme previous = this.getPreviousLexeme();
            Lexeme next = this.getNextLexeme();
            int i = 0;
            while (i < this.commentNodes.size()) {
                int previousLevel;
                cn = (CommentNode)this.commentNodes.get(i);
                comment = cn.node;
                if (cn.isMultiline && !cn.printed) {
                    if (!(cn.printed || comment.getStartingOffset() >= this.currentLexeme.offset || previous != null && comment.getStartingOffset() <= previous.offset)) {
                        previousLevel = this.writer.getIndentLevel();
                        this.writer.setCurrentIndentLevel(cn.indentLevel);
                        this.printComment(cn);
                        this.writer.setCurrentIndentLevel(previousLevel);
                        this.writer.printIndent();
                        cn.printed = true;
                    }
                } else if (!cn.printed && comment.getStartingOffset() < this.currentLexeme.offset) {
                    previousLevel = this.writer.getIndentLevel();
                    if (cn.isNoFormat) {
                        this.handleNoFormatting(cn);
                        if (this.noFormatEnd == lexeme) {
                            this.shouldPrint = true;
                            this.printPreviousLineEnding(this.noFormatEnd, null, 0, false);
                            this.currentLexeme = lexeme;
                            this.noFormatEnd = null;
                            this.noFormatStart = null;
                        }
                    } else {
                        this.writer.setCurrentIndentLevel(cn.indentLevel);
                        this.adjustCommentIndent();
                        this.printComment(cn);
                        this.writer.setCurrentIndentLevel(previousLevel);
                        Lexeme ending = this.lexemes.getLexemeFromOffset(comment.getEndingOffset() - 1);
                        this.printLineEnding(ending, null, 1, false);
                        this.printIndent();
                    }
                    cn.printed = true;
                }
                ++i;
            }
            this.print(lexeme.getText());
            i = 0;
            while (i < this.commentNodes.size()) {
                cn = (CommentNode)this.commentNodes.get(i);
                if (!cn.isMultiline) {
                    String between;
                    comment = cn.node;
                    if (!(cn.printed || comment.getStartingOffset() <= this.currentLexeme.offset || next != null && comment.getStartingOffset() >= next.offset || (between = this.source.substring(lexeme.getEndingOffset(), comment.getStartingOffset())).indexOf(10) != -1 || between.indexOf(13) != -1)) {
                        int previousLevel;
                        block27: {
                            String substring;
                            previousLevel = this.writer.getIndentLevel();
                            this.writer.setCurrentIndentLevel(0);
                            try {
                                substring = this.source.substring(this.currentLexeme.getStartingOffset(), comment.getStartingOffset());
                                if (substring.indexOf(10) == -1 && substring.indexOf(13) == -1 && (substring.indexOf(32) != -1 || substring.indexOf(9) != -1)) {
                                    this.print(' ');
                                }
                            }
                            catch (Exception exception) {}
                            if (cn.isNoFormat) {
                                this.handleNoFormatting(cn);
                            } else {
                                this.printComment(cn);
                                try {
                                    if (next == null) {
                                        this.printLineEnding(false);
                                        break block27;
                                    }
                                    if (!comment.getName().equals("JSCOMMENT")) break block27;
                                    try {
                                        substring = this.source.substring(comment.getStartingOffset(), comment.getEndingOffset());
                                        if (substring.startsWith("//")) {
                                            this.printLineEnding(true);
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                                catch (Exception exception) {}
                            }
                        }
                        this.writer.setCurrentIndentLevel(previousLevel);
                        cn.printed = true;
                    }
                }
                ++i;
            }
        }
    }

    private void printLexemes(Lexeme[] lexemes) {
        if (lexemes != null && lexemes.length > 0) {
            int i = 0;
            while (i < lexemes.length) {
                Lexeme next = this.getNextLexeme();
                if (lexemes[i].equals((Object)next)) {
                    this.printLexeme(lexemes[i]);
                }
                ++i;
            }
        }
    }

    private void printRemainingCommentLineEnding() {
        if (!this.shouldPrint) {
            return;
        }
        this.writer.println();
    }

    private void printLineEnding(boolean advance) {
        this.printLineEnding(null, 1, advance);
    }

    private void printLineEnding(IParseNode node) {
        this.printLineEnding(this.currentLexeme, node, 1, true);
    }

    private void printLineEnding(IParseNode node, int defaultLineCount, boolean advance) {
        this.printLineEnding(this.currentLexeme, node, defaultLineCount, advance);
    }

    private void printLineEnding(Lexeme lexeme, IParseNode node, int defaultLineCount, boolean advance) {
        if (!this.shouldPrint) {
            return;
        }
        try {
            Lexeme previous = lexeme;
            if (previous == null) {
                this.writer.println();
                return;
            }
            int previousIndex = this.lexemes.getLexemeIndex(previous);
            if (previousIndex < 0) {
                this.writer.println();
                return;
            }
            int nextIndex = previousIndex + 1;
            if (nextIndex >= this.lexemes.size()) {
                this.writer.println();
                return;
            }
            Lexeme next = this.lexemes.get(nextIndex);
            int newLines = this.getNumberOfNewlines(previous, next);
            int newLinesMax = defaultLineCount;
            if (this.codeoptions.preserveLineBreaks) {
                if (previous != this.lastLineEndingAdjusted || !advance) {
                    if (advance) {
                        this.lastLineEndingAdjusted = previous;
                    }
                    newLinesMax = Math.max(newLines, defaultLineCount);
                } else {
                    newLinesMax = 0;
                }
            }
            int i = 0;
            while (i < newLinesMax) {
                if (i > 0) {
                    this.writer.printIndent();
                }
                this.writer.println();
                ++i;
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Error grabbing new lines", (Throwable)ex);
            this.writer.println();
        }
    }

    int getNumberOfNewlines(Lexeme previous, Lexeme next) {
        if (previous == null || next == null) {
            return 1;
        }
        String sourceBit = this.source.substring(previous.getEndingOffset(), next.getStartingOffset());
        return StringUtils.getNumberOfNewlines((String)sourceBit);
    }

    private void writeBinaryNode(JSBinaryOperatorNode bnode, SourceWriter writer) {
        if (bnode instanceof JSBinaryOperatorAssignNode) {
            JSBinaryOperatorAssignNode anode = (JSBinaryOperatorAssignNode)bnode;
            this.writeBinaryAssignNode(anode, writer);
            return;
        }
        switch (bnode.getTypeIndex()) {
            case 13: {
                JSParseNode object = (JSParseNode)bnode.getChild(0);
                JSParseNode index = (JSParseNode)bnode.getChild(1);
                this.writeFormattedSource(object, writer, true);
                this.printNextLexemeIfOfType(66);
                this.writeFormattedSource(index, writer, true);
                this.printNextLexemeIfOfType(74);
                break;
            }
            case 14: {
                JSParseNode left = (JSParseNode)bnode.getChild(0);
                JSParseNode identifier = (JSParseNode)bnode.getChild(1);
                this.writeFormattedSource(left, writer, true);
                this.printNextLexemeIfOfType(35);
                this.writeFormattedSource(identifier, writer, true);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.writeSourceCommon(bnode, writer);
                break;
            }
        }
    }

    private void writeBinaryAssignNode(JSBinaryOperatorAssignNode anode, SourceWriter writer) {
        JSParseNode left = (JSParseNode)anode.getChild(0);
        JSParseNode right = (JSParseNode)anode.getChild(1);
        this.writeFormattedSource(left, writer, true);
        this.print(' ');
        this.printLexemes(this.getLexemesBetweenLexemes(left.getEndingLexeme(), right.getStartingLexeme()));
        this.print(' ');
        this.writeFormattedSource(right, writer, true);
    }

    private void writeSourceCommon(JSBinaryOperatorNode bnode, SourceWriter writer) {
        JSParseNode left = (JSParseNode)bnode.getChild(0);
        JSParseNode right = (JSParseNode)bnode.getChild(1);
        this.writeFormattedSource(left, writer, true);
        Lexeme endingLexeme = right.getEndingLexeme();
        Lexeme startingLexeme = left.getStartingLexeme();
        boolean isNewLine = false;
        int ti = right.getTypeIndex();
        if (ti == 47 || ti == 59) {
            isNewLine = true;
        } else {
            int a = startingLexeme.getEndingOffset();
            while (a < endingLexeme.getStartingOffset() && a < this.source.length()) {
                char c = this.source.charAt(a);
                if (c == '\r' || c == '\n') {
                    isNewLine = true;
                    break;
                }
                ++a;
            }
        }
        if (!isNewLine) {
            this.print(' ');
            this.printLexemes(new Lexeme[]{left.getEndingLexeme()});
            this.printLexemes(this.getLexemesBetweenNode((IParseNode)left, (IParseNode)right));
            this.print(' ');
        } else {
            this.print(' ');
            this.printLexemes(new Lexeme[]{left.getEndingLexeme()});
            this.printLexemes(this.getLexemesBetweenNode((IParseNode)left, (IParseNode)right));
            this.printLineEnding((IParseNode)bnode);
            this.printAdjustedIndent();
        }
        this.writeFormattedSource(right, writer, true);
    }

    private void writeCommon(JSParseNode node, SourceWriter writer, boolean appendTrailing) {
        switch (node.getTypeIndex()) {
            case 1: {
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                this.print(' ');
                this.printLexemes(this.getLexemesBetweenNode(node.getChild(0), node.getChild(1)));
                this.print(' ');
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                break;
            }
            case 38: {
                if (this.codeoptions.insertNewLineBeforeCatch && writer.getCurrentIndentLevel() != 0) {
                    this.printLineEnding((IParseNode)node);
                    this.printIndent();
                }
                this.printLexeme(node.getStartingLexeme());
                this.print(' ');
                JSParseNode child = (JSParseNode)node.getChild(0);
                this.printNextLexemeIfOfType(50);
                this.writeFormattedSource(child, writer, true);
                Lexeme next = this.getNextLexemeIfOfType(58);
                if (next != null) {
                    this.printLexeme(next);
                    this.print(' ');
                }
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                break;
            }
            case 39: {
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                Lexeme next = this.getNextLexemeIfOfType(71);
                if (next != null) {
                    this.print(' ');
                    this.printLexeme(next);
                    this.print(' ');
                }
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                next = this.getNextLexeme();
                if (next != null && next.typeIndex == 78) {
                    this.print(' ');
                    this.printLexeme(next);
                    this.print(' ');
                }
                this.writeFormattedSource((JSParseNode)node.getChild(2), writer, true);
                break;
            }
            case 40: {
                this.printLexeme(node.getStartingLexeme());
                this.print(' ');
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                this.printNextLexemeIfOfType(50);
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                this.printNextLexemeIfOfType(58);
                break;
            }
            case 41: {
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                if (node.getChildCount() <= 1 || node.getChild(1).getTypeIndex() == 43) break;
                Lexeme next = this.getNextLexemeIfOfType(40);
                if (next != null) {
                    this.print(' ');
                    this.printLexeme(next);
                    this.print(' ');
                }
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                break;
            }
            case 42: {
                this.writeDoNode(node, writer);
                break;
            }
            case 43: {
                this.printNextLexemeIfOfType(43);
                break;
            }
            case 44: {
                if (this.codeoptions.insertNewLineBeforeFinally && writer.getCurrentIndentLevel() != 0) {
                    this.printLineEnding((IParseNode)node);
                    this.printIndent();
                }
                this.printLexeme(node.getStartingLexeme());
                this.print(' ');
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                break;
            }
            case 45: {
                this.writeForInNode(node, writer);
                break;
            }
            case 46: {
                this.writeForNode(node, writer);
                break;
            }
            case 47: {
                this.writeFunction(node, writer);
                break;
            }
            case 48: {
                this.writeIf(node, writer);
                break;
            }
            case 49: {
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                this.printNextLexemeIfOfType(50);
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                this.printLexeme(node.getEndingLexeme());
                break;
            }
            case 50: {
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                this.printLexemes(this.getLexemesBetweenNode(node.getChild(0), node.getChild(1)));
                this.print(' ');
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                break;
            }
            case 70: {
                this.writeFormattedSource((JSParseNode)node.getChild(0), writer, true);
                this.printLexemes(this.getLexemesBetweenNode(node.getChild(0), node.getChild(1)));
                this.print(' ');
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                break;
            }
            case 71: {
                this.printNextLexemeIfOfType(26);
                break;
            }
            case 72: {
                JSParseNode body = (JSParseNode)node.getChild(0);
                JSParseNode catchNode = (JSParseNode)node.getChild(1);
                JSParseNode finallyNode = (JSParseNode)node.getChild(2);
                this.printLexeme(node.getStartingLexeme());
                this.print(' ');
                this.writeFormattedSource(body, writer, true);
                if (!catchNode.isEmpty()) {
                    if (writer.getCurrentIndentLevel() != 0) {
                        this.print(' ');
                    }
                    this.writeFormattedSource(catchNode, writer, true);
                }
                if (finallyNode.isEmpty()) break;
                if (!this.codeoptions.insertNewLineBeforeFinally && writer.getCurrentIndentLevel() != 0) {
                    this.print(' ');
                }
                this.writeFormattedSource(finallyNode, writer, true);
                break;
            }
            case 87: {
                this.writeWhileNode(node, writer);
                break;
            }
            case 88: {
                this.printLexeme(node.getStartingLexeme());
                this.print(' ');
                JSParseNode child = (JSParseNode)node.getChild(0);
                this.printNextLexemeIfOfType(50);
                this.writeFormattedSource(child, writer, true);
                Lexeme next = this.getNextLexemeIfOfType(58);
                if (next != null) {
                    this.printLexeme(next);
                    this.print(' ');
                }
                this.writeFormattedSource((JSParseNode)node.getChild(1), writer, true);
                break;
            }
            case -1: {
                writer.print("ERROR");
                break;
            }
        }
    }

    private void writeForNode(JSParseNode node, SourceWriter JSCodeFormatterOptions2) {
        JSParseNode initializer = (JSParseNode)node.getChild(0);
        JSParseNode condition = (JSParseNode)node.getChild(1);
        JSParseNode advance = (JSParseNode)node.getChild(2);
        JSParseNode body = (JSParseNode)node.getChild(3);
        this.printLexeme(node.getStartingLexeme());
        Lexeme next = this.getNextLexemeIfOfType(50);
        if (next != null) {
            this.print(' ');
            this.printLexeme(next);
        }
        if (!initializer.isEmpty()) {
            this.writeFormattedSource(initializer, this.writer, true);
        }
        if ((next = this.getNextLexeme()) != null && next.typeIndex == 43) {
            this.printLexeme(next);
        }
        if (!condition.isEmpty()) {
            this.print(' ');
            this.writeFormattedSource(condition, this.writer, true);
        }
        if ((next = this.getNextLexeme()) != null && next.typeIndex == 43) {
            this.printLexeme(next);
        }
        if (!advance.isEmpty()) {
            this.print(' ');
            this.writeFormattedSource(advance, this.writer, true);
        }
        if ((next = this.getNextLexeme()) != null && next.typeIndex == 58) {
            this.printLexeme(next);
            this.print(' ');
        }
        if (body.getTypeIndex() != 61) {
            this.printLineEnding((IParseNode)node);
            this.writer.increaseIndent();
            this.printIndent();
        }
        this.writeFormattedSource(body, this.writer, true);
        if (body.getTypeIndex() != 61) {
            this.writer.decreaseIndent();
        }
    }

    private void writeForInNode(JSParseNode node, SourceWriter writer) {
        JSParseNode initializer = (JSParseNode)node.getChild(0);
        JSParseNode object = (JSParseNode)node.getChild(1);
        JSParseNode body = (JSParseNode)node.getChild(2);
        this.printLexeme(node.getStartingLexeme());
        Lexeme next = this.getNextLexemeIfOfType(50);
        if (next != null) {
            this.print(' ');
            this.printLexeme(next);
        }
        this.writeFormattedSource(initializer, writer, true);
        next = this.getNextLexeme();
        if (next != null && next.typeIndex == 18) {
            this.print(' ');
            this.printLexeme(next);
            this.print(' ');
        }
        this.writeFormattedSource(object, writer, true);
        next = this.getNextLexeme();
        if (next != null && next.typeIndex == 58) {
            this.printLexeme(next);
            this.print(' ');
        }
        if (body.getTypeIndex() != 61) {
            this.printLineEnding((IParseNode)node);
            writer.increaseIndent();
            this.printIndent();
        }
        this.writeFormattedSource(body, writer, true);
        if (body.getTypeIndex() != 61) {
            writer.decreaseIndent();
        }
    }

    private void writeDoNode(JSParseNode node, SourceWriter writer) {
        JSParseNode doBody = (JSParseNode)node.getChild(0);
        this.printLexeme(node.getStartingLexeme());
        this.print(' ');
        if (doBody.getTypeIndex() != 61) {
            this.printLineEnding((IParseNode)node);
            writer.increaseIndent();
            this.printIndent();
        }
        this.writeFormattedSource(doBody, writer, true);
        if (doBody.getTypeIndex() != 61) {
            writer.decreaseIndent();
            this.printNextLexemeIfOfType(43);
        }
        JSParseNode cond = (JSParseNode)node.getChild(1);
        if (this.codeoptions.insertNewLineBeforeWhile) {
            this.printLineEnding((IParseNode)node);
            this.printIndent();
        } else {
            this.print(' ');
        }
        Lexeme next = this.getNextLexemeIfOfType(32);
        if (next != null) {
            this.printLexeme(next);
            this.print(' ');
        }
        if ((next = this.getNextLexeme()) != null && next.typeIndex == 50) {
            this.printLexeme(next);
        }
        this.writeFormattedSource(cond, writer, true);
        next = this.getNextLexeme();
        if (next != null && next.typeIndex == 58) {
            this.printLexeme(next);
        }
    }

    private void writeWhileNode(JSParseNode node, SourceWriter writer) {
        JSParseNode body;
        this.printLexeme(node.getStartingLexeme());
        this.print(' ');
        JSParseNode child = (JSParseNode)node.getChild(0);
        this.printNextLexemeIfOfType(50);
        this.writeFormattedSource(child, writer, true);
        Lexeme next = this.getNextLexemeIfOfType(58);
        if (next != null) {
            this.printLexeme(next);
            this.print(' ');
        }
        if ((body = (JSParseNode)node.getChild(1)).getTypeIndex() != 61) {
            this.printLineEnding((IParseNode)node);
            writer.increaseIndent();
            this.printIndent();
        }
        this.writeFormattedSource(body, writer, true);
        if (body.getTypeIndex() != 61) {
            writer.decreaseIndent();
        }
    }

    private void printConditionalSpace() {
        String last = this.writer.toString();
        int len = last.length();
        if (len > 0 && !Character.isWhitespace(last.charAt(len - 1))) {
            this.print(' ');
        }
    }

    private void writeIf(JSParseNode node, SourceWriter writer) {
        JSParseNode condition = (JSParseNode)node.getChild(0);
        JSParseNode trueCase = (JSParseNode)node.getChild(1);
        JSParseNode falseCase = (JSParseNode)node.getChild(2);
        if (this.codeoptions.insertNewLineBeforeIf && !this.nextIfNoNewLine) {
            this.printLineEnding((IParseNode)node);
        }
        this.printLexeme(node.getStartingLexeme());
        this.print(' ');
        this.printNextLexemeIfOfType(50);
        this.writeFormattedSource(condition, writer, true);
        Lexeme next = this.getNextLexemeIfOfType(58);
        if (next != null) {
            this.printLexeme(next);
            this.printConditionalSpace();
        }
        boolean incIndent = false;
        boolean nR = this.nextReturnNoNewLine;
        boolean bl = this.nextReturnNoNewLine = trueCase.getTypeIndex() == 83;
        if (!this.codeoptions.keepThenSameLine && trueCase.getTypeIndex() != 61) {
            if (this.nextReturnNoNewLine && this.codeoptions.insertNewLineBeforeReturn) {
                this.nextReturnNoNewLine = false;
                incIndent = true;
            }
            if (!this.codeoptions.keepSimpleIfOnOneLine || !falseCase.isEmpty()) {
                this.printLineEnding((IParseNode)node);
                incIndent = true;
            }
        }
        if (incIndent) {
            writer.increaseIndent();
            this.printIndent();
        }
        if (trueCase.getTypeIndex() == 61 && this.codeoptions.keepGuardianClauseOnOneLine) {
            this.nextBlockNoNewLine = true;
        }
        this.writeFormattedSource(trueCase, writer, true);
        this.nextReturnNoNewLine = nR;
        if (incIndent) {
            writer.decreaseIndent();
        }
        if (!falseCase.isEmpty()) {
            boolean isNotCompacting;
            if (trueCase.getTypeIndex() != 61 && (next = this.getNextLexeme()) != null && next.typeIndex == 43) {
                this.printLexeme(next);
            }
            if (this.codeoptions.insertNewLineBeforeElse) {
                this.printLineEnding((IParseNode)node);
                this.printIndent();
                next = this.getNextLexeme();
                if (next != null && next.typeIndex == 16) {
                    this.printLexeme(next);
                    this.print(' ');
                }
            } else {
                boolean tc;
                next = this.getNextLexeme();
                boolean bl2 = tc = trueCase.getTypeIndex() != 61;
                if (tc) {
                    writer.println();
                    writer.printIndent();
                }
                if (next != null && next.typeIndex == 16) {
                    if (!tc) {
                        this.print(' ');
                    }
                    this.printLexeme(next);
                    this.print(' ');
                }
            }
            incIndent = false;
            boolean bl3 = isNotCompacting = !this.codeoptions.compactElseIf || falseCase.getTypeIndex() != 48;
            if ((!this.codeoptions.keepElseStatementOnSameLine || this.codeoptions.insertNewLineBeforeIf && falseCase.getTypeIndex() == 48) && falseCase.getTypeIndex() != 61 && isNotCompacting) {
                this.printLineEnding((IParseNode)node);
                incIndent = true;
            }
            if (falseCase.getTypeIndex() == 83 && this.codeoptions.insertNewLineBeforeReturn) {
                incIndent = true;
            }
            if (incIndent) {
                writer.increaseIndent();
                this.printIndent();
            }
            if (falseCase.getTypeIndex() == 61 && this.codeoptions.keepGuardianClauseOnOneLine) {
                this.nextBlockNoNewLine = true;
            }
            this.nextIfNoNewLine = !isNotCompacting;
            this.writeFormattedSource(falseCase, writer, true);
            this.nextIfNoNewLine = false;
            if (incIndent) {
                writer.decreaseIndent();
            }
        }
    }

    private void writeFunction(JSParseNode node, SourceWriter writer) {
        JSParseNode parameters = (JSParseNode)node.getChild(0);
        JSParseNode body = (JSParseNode)node.getChild(1);
        this.printLexeme(node.getStartingLexeme());
        Lexeme next = this.getNextLexemeIfOfType(8);
        if (next != null) {
            this.print(' ');
            this.printLexeme(next);
        }
        if ((next = this.getNextLexeme()) != null && next.typeIndex == 50) {
            this.printLexeme(next);
        }
        if (!parameters.isEmpty()) {
            this.writeFormattedSource(parameters, writer, true);
        }
        if ((next = this.getNextLexeme()) != null && next.typeIndex == 58) {
            this.printLexeme(next);
            if (this.codeoptions.addSpaceAfterFunctionDeclaration && this.codeoptions.formatterBracePositionForMethodDecl == 0) {
                writer.print(' ');
            }
        }
        this.nextBlockFunctionBody = true;
        this.writeFormattedSource(body, writer, true);
        int inc = 0;
        if (node.getParent().getParent() == null) {
            inc = 1;
        }
        if ((next = this.getNextLexeme()) != null && (next.typeIndex == 51 || next.typeIndex == 43 || next.typeIndex == 58 || next.typeIndex == 50)) {
            return;
        }
        this.printLineEnding((IParseNode)node, this.codeoptions.blankLinesBeforeMethod + inc, true);
    }

    private void writeFunctionNode(JSFunctionNode lnode, SourceWriter writer) {
        this.writeCommon(lnode, writer, false);
    }

    private void writeLabelNode(JSLabelNode lnode, SourceWriter writer) {
        switch (lnode.getTypeIndex()) {
            case 51: {
                this.printLexeme(lnode.getStartingLexeme());
                break;
            }
            case 52: {
                this.printLexeme(lnode.getStartingLexeme());
                break;
            }
        }
        JSParseNode child = (JSParseNode)lnode.getChild(0);
        if (!child.isEmpty()) {
            this.print(" ");
            this.writeFormattedSource(child, writer, true);
        }
    }

    private void writeSourceCommon(JSNaryNode node, SourceWriter writer) {
        if (node.getChildCount() > 0) {
            JSParseNode element = (JSParseNode)node.getChild(0);
            this.writeFormattedSource(element, writer, true);
            int i = 1;
            while (i < node.getChildCount()) {
                element = (JSParseNode)node.getChild(i);
                Lexeme next = this.getNextLexemeIfOfType(51);
                if (next != null) {
                    this.printLexeme(next);
                    this.print(' ');
                }
                if (writer.getCurrentIndentLevel() == 0) {
                    this.printIndent();
                }
                this.writeFormattedSource(element, writer, true);
                ++i;
            }
        }
    }

    private void writeNaryExpressionNode(JSNaryAndExpressionNode nnode, SourceWriter writer) {
        JSParseNode expression = (JSParseNode)nnode.getChild(0);
        switch (nnode.getTypeIndex()) {
            case 57: {
                this.printLexeme(nnode.getStartingLexeme());
                this.print(' ');
                this.nextBlockInCase = true;
                JSParseNode child = (JSParseNode)nnode.getChild(0);
                this.writeFormattedSource(child, writer, true);
                this.printNextLexemeIfOfType(78);
                boolean printLine = true;
                if (nnode.getChildCount() > 1 && nnode.getChild(1).getTypeIndex() == 61) {
                    printLine = false;
                }
                if (this.codeoptions.indentStatementsCompareToCases && printLine) {
                    writer.increaseIndent();
                }
                if (printLine && writer.getCurrentIndentLevel() > 0) {
                    this.printLineEnding((IParseNode)nnode);
                }
                int i = 1;
                while (i < nnode.getChildCount()) {
                    JSParseNode statement = (JSParseNode)nnode.getChild(i);
                    if (statement.getTypeIndex() == 51) {
                        if (!this.codeoptions.indentBreaksCompareToCases && this.codeoptions.indentStatementsCompareToCases) {
                            writer.decreaseIndent();
                        } else if (this.codeoptions.indentBreaksCompareToCases && !this.codeoptions.indentStatementsCompareToCases) {
                            writer.increaseIndent();
                        }
                    }
                    if (printLine) {
                        this.printIndent();
                    }
                    this.writeFormattedSource(statement, writer, true);
                    if (statement.getTypeIndex() == 51) {
                        if (!this.codeoptions.indentBreaksCompareToCases && this.codeoptions.indentStatementsCompareToCases) {
                            writer.increaseIndent();
                        } else if (this.codeoptions.indentBreaksCompareToCases && !this.codeoptions.indentStatementsCompareToCases) {
                            writer.decreaseIndent();
                        }
                    }
                    if (statement.getIncludesSemicolon()) {
                        Lexeme next = this.getNextLexemeIfOfType(43);
                        if (next != null) {
                            this.printLexeme(next);
                            this.printLineEnding((IParseNode)nnode);
                        }
                    } else {
                        this.printLineEnding((IParseNode)nnode);
                    }
                    ++i;
                }
                if (this.codeoptions.indentStatementsCompareToCases && printLine) {
                    writer.decreaseIndent();
                }
                this.nextBlockInCase = false;
                break;
            }
            case 58: {
                this.printLexeme(nnode.getStartingLexeme());
                this.print(' ');
                this.printNextLexemeIfOfType(50);
                this.writeFormattedSource(expression, writer, true);
                this.printNextLexemeIfOfType(58);
                int bracePosition = this.codeoptions.formatterBracePositionForBlockInSwitch;
                Lexeme next = this.getNextLexemeIfOfType(34);
                if (bracePosition == 0) {
                    if (next != null) {
                        this.print(' ');
                        this.printIndentIfNewLine();
                        this.printLexeme(next);
                    }
                    this.printLineEnding((IParseNode)nnode);
                } else if (bracePosition == 1) {
                    this.printLineEnding((IParseNode)nnode);
                    this.printIndent();
                    if (next != null) {
                        this.printLexeme(next);
                    }
                    this.printLineEnding((IParseNode)nnode);
                } else if (bracePosition == 2) {
                    this.printLineEnding((IParseNode)nnode);
                    writer.increaseIndent();
                    this.printIndent();
                    if (next != null) {
                        this.printLexeme(next);
                    }
                    this.printLineEnding((IParseNode)nnode);
                }
                if (this.codeoptions.indentStatementsCompareToSwitch) {
                    writer.increaseIndent();
                }
                int i = 1;
                while (i < nnode.getChildCount()) {
                    JSParseNode statement = (JSParseNode)nnode.getChild(i);
                    int currentIndentLevel = writer.getCurrentIndentLevel();
                    if (currentIndentLevel == 0) {
                        this.printIndent();
                    }
                    this.writeFormattedSource(statement, writer, true);
                    ++i;
                }
                if (this.codeoptions.indentStatementsCompareToSwitch) {
                    writer.decreaseIndent();
                }
                this.printIndent();
                this.printNextLexemeIfOfType(42);
                if (bracePosition != 2) break;
                writer.decreaseIndent();
                break;
            }
        }
    }

    private void writeNaryNode(JSNaryNode nnode, SourceWriter writer) {
        if (nnode instanceof JSNaryAndExpressionNode) {
            JSNaryAndExpressionNode nenode = (JSNaryAndExpressionNode)nnode;
            this.writeNaryExpressionNode(nenode, writer);
            return;
        }
        int bracePosition = this.codeoptions.formatterBracePositionForBlock;
        if (this.nextBlockFunctionBody) {
            bracePosition = this.codeoptions.formatterBracePositionForMethodDecl;
        }
        if (this.nextBlockInCase) {
            bracePosition = this.codeoptions.formatterBracePositionForBlockInCase;
        }
        switch (nnode.getTypeIndex()) {
            case 53: {
                this.writeSourceCommon(nnode, writer);
                break;
            }
            case 54: {
                this.printNextLexemeIfOfType(66);
                this.writeSourceCommon(nnode, writer);
                this.printNextLexemeIfOfType(74);
                break;
            }
            case 55: {
                this.writeSourceCommon(nnode, writer);
                break;
            }
            case 56: {
                this.writeDefaultNode(nnode, writer);
                break;
            }
            case 59: {
                this.writeObjectLiteral(nnode, writer);
                break;
            }
            case 60: {
                this.writeSourceCommon(nnode, writer);
                break;
            }
            case 61: {
                this.writeStatements(nnode, writer, bracePosition);
                break;
            }
            case 62: {
                this.printLexeme(nnode.getStartingLexeme());
                this.print(" ");
                this.writeSourceCommon(nnode, writer);
                break;
            }
        }
    }

    private void printIndentIfNewLine() {
        String string = this.writer.toString();
        for (int len = string.length() - 1; len > 0; --len) {
            char c = string.charAt(len);
            if (Character.isWhitespace(c)) {
                if (c != '\n' && c != '\r') continue;
                try {
                    StringBuffer buffer = this.writer.getBuffer();
                    buffer.replace(len + 2, buffer.length(), "");
                    this.printAdjustedIndent();
                }
                catch (Exception exception) {}
                return;
            }
            return;
        }
    }

    private void writeStatements(JSNaryNode nnode, SourceWriter writer, int bracePosition) {
        boolean ne = this.nextBlockNoNewLine;
        boolean notDec = false;
        if (nnode.getChildCount() > 0) {
            int typeIndex = nnode.getChild(0).getTypeIndex();
            if (this.codeoptions.keepGuardianClauseOnOneLine) {
                boolean bl = this.nextReturnNoNewLine = nnode.getChildCount() == 1 && (typeIndex == 83 || typeIndex == 83) ? this.nextBlockNoNewLine : false;
            }
        }
        if (!nnode.isTopLevel()) {
            if (bracePosition == 0) {
                this.printIndentIfNewLine();
                this.printNextLexemeIfOfType(34);
            } else if (bracePosition == 1) {
                if (writer.getLength() != 0) {
                    this.printLineEnding((IParseNode)nnode);
                    this.printIndent();
                    this.printNextLexemeIfOfType(34);
                } else {
                    this.printNextLexemeIfOfType(34);
                }
            } else if (bracePosition == 2) {
                if (writer.getLength() != 0) {
                    this.printLineEnding((IParseNode)nnode);
                    writer.increaseIndent();
                    this.printIndent();
                    this.printNextLexemeIfOfType(34);
                } else {
                    this.printNextLexemeIfOfType(34);
                }
            }
            int a = 0;
            while (a < this.codeoptions.blankLinesInStartOfMethodBody) {
                this.printLineEnding((IParseNode)nnode);
                this.printIndent();
                ++a;
            }
            if (nnode.getChildCount() > 0) {
                if (this.nextBlockNoNewLine && nnode.getChildCount() == 1 && (nnode.getChild(0).getTypeIndex() == 83 || nnode.getChild(0).getTypeIndex() == 84)) {
                    notDec = true;
                    writer.print(' ');
                    this.nextBlockNoNewLine = false;
                } else {
                    this.nextBlockNoNewLine = false;
                    this.printLineEnding((IParseNode)nnode);
                    if (this.nextBlockFunctionBody) {
                        if (this.codeoptions.indentStatementsCompareToBody) {
                            writer.increaseIndent();
                        }
                    } else if (this.codeoptions.indentStatementsCompareToBlock) {
                        writer.increaseIndent();
                    }
                }
            }
        }
        boolean tempHolder = this.nextBlockFunctionBody;
        boolean tempCase = this.nextBlockInCase;
        this.nextBlockFunctionBody = false;
        this.nextBlockInCase = false;
        int i = 0;
        while (i < nnode.getChildCount()) {
            IParseNode node = nnode.getChild(i);
            if (i > 0) {
                this.nextReturnNoNewLine = false;
            }
            if (node instanceof JSParseNode) {
                JSParseNode statement = (JSParseNode)nnode.getChild(i);
                if (!this.nextReturnNoNewLine) {
                    this.printAdjustedIndent();
                }
                boolean nr = this.nextReturnNoNewLine;
                if (statement.getTypeIndex() != 83) {
                    this.nextReturnNoNewLine = false;
                }
                this.writeFormattedSource(statement, writer, true);
                this.nextReturnNoNewLine = nr;
                Lexeme next = this.getNextLexeme();
                if (statement.getIncludesSemicolon()) {
                    if (!notDec) {
                        this.printNextLexemeIfOfType(43);
                        if (writer.getCurrentIndentLevel() != 0) {
                            this.printLineEnding((IParseNode)nnode);
                        }
                    }
                } else if (next != null && next.typeIndex == 43) {
                    this.printLexeme(next);
                    this.printLineEnding((IParseNode)nnode);
                } else if (!notDec) {
                    if (writer.getCurrentIndentLevel() != 0) {
                        if (i < nnode.getChildCount() - 1) {
                            if (!nnode.getChild(i + 1).isEmpty()) {
                                this.printLineEnding((IParseNode)nnode);
                            }
                        } else {
                            this.printLineEnding((IParseNode)nnode);
                        }
                    }
                } else {
                    this.printLexeme(next);
                }
            } else {
                this.writeFormattedSource((JSParseNode)node, writer, true);
            }
            ++i;
        }
        this.nextBlockFunctionBody = tempHolder;
        this.nextBlockInCase = tempCase;
        if (!nnode.isTopLevel()) {
            this.writeRcurly(nnode, writer, bracePosition, notDec);
        }
        this.nextBlockFunctionBody = false;
        this.nextBlockNoNewLine = ne;
    }

    private void writeRcurly(JSNaryNode nnode, SourceWriter writer, int bracePosition, boolean notDec) {
        if (nnode.getChildCount() > 0) {
            if (!notDec) {
                Lexeme next;
                if (this.nextBlockFunctionBody) {
                    if (this.codeoptions.indentStatementsCompareToBody) {
                        writer.decreaseIndent();
                    }
                } else if (this.codeoptions.indentStatementsCompareToBlock) {
                    writer.decreaseIndent();
                }
                if ((next = this.getNextLexemeIfOfType(42)) != null) {
                    this.printIndent();
                    this.printLexeme(next);
                }
                if (bracePosition == 2) {
                    writer.decreaseIndent();
                }
            } else {
                Lexeme next = this.getNextLexemeIfOfType(42);
                if (next != null) {
                    if (!this.nextReturnNoNewLine) {
                        this.printIndent();
                    }
                    this.print(' ');
                    this.printLexeme(next);
                } else {
                    Lexeme nextLexeme = this.getNextLexeme();
                    if (nextLexeme != null) {
                        this.printNextLexemeIfOfType(43);
                        Lexeme nextLexeme2 = this.getNextLexeme();
                        if (nextLexeme2 != null) {
                            this.print(' ');
                            this.printNextLexemeIfOfType(42);
                        }
                    }
                }
                if (bracePosition == 2) {
                    writer.decreaseIndent();
                }
            }
        } else {
            this.writeClosePartRCurly(nnode, writer, bracePosition);
        }
    }

    private void writeClosePartRCurly(JSNaryNode nnode, SourceWriter writer, int bracePosition) {
        Lexeme next;
        if (writer.getCurrentIndentLevel() != 0) {
            this.printLineEnding((IParseNode)nnode);
        }
        if ((next = this.getNextLexemeIfOfType(42)) != null) {
            this.printIndent();
            this.printLexeme(next);
        }
        if (bracePosition == 2) {
            writer.decreaseIndent();
        }
    }

    private void writeObjectLiteral(JSNaryNode nnode, SourceWriter writer) {
        int bracePosition = this.codeoptions.formatterBracePositionForArrayInitializer;
        if (nnode.getChildCount() == 0 && this.codeoptions.keepEmptyArrayInitializerOnOneLine) {
            bracePosition = 0;
        }
        Lexeme next = this.getNextLexeme();
        if (bracePosition == 0) {
            this.printIndentIfNewLine();
            this.printNextLexemeIfOfType(34);
        } else if (bracePosition == 1) {
            this.printLineEnding((IParseNode)nnode);
            this.printIndent();
            this.printNextLexemeIfOfType(34);
        } else if (bracePosition == 2) {
            this.printLineEnding((IParseNode)nnode);
            writer.increaseIndent();
            this.printIndent();
            this.printNextLexemeIfOfType(34);
        }
        if (nnode.getChildCount() > 0) {
            this.printLineEnding((IParseNode)nnode);
            writer.increaseIndent();
            JSParseNode element = (JSParseNode)nnode.getChild(0);
            this.printIndent();
            this.writeFormattedSource(element, writer, true);
            int i = 1;
            while (i < nnode.getChildCount()) {
                if (writer.getCurrentIndentationLevel() == 0) {
                    this.printIndent();
                }
                if ((next = this.getNextLexeme()) != null && next.typeIndex == 51) {
                    this.printLexeme(next);
                }
                if (writer.getCurrentIndentLevel() != 0) {
                    this.printLineEnding((IParseNode)nnode);
                }
                element = (JSParseNode)nnode.getChild(i);
                this.printIndent();
                this.writeFormattedSource(element, writer, false);
                ++i;
            }
            next = this.getNextLexeme();
            if (next != null && next.typeIndex == 51) {
                this.printLexeme(next);
            }
            writer.decreaseIndent();
            if (writer.getCurrentIndentLevel() != 0) {
                this.printLineEnding((IParseNode)nnode);
            }
            if ((next = this.getNextLexeme()) != null && next.typeIndex == 42) {
                this.printIndent();
                this.printLexeme(next);
            }
            if (bracePosition == 2) {
                writer.decreaseIndent();
            }
        } else {
            next = this.getNextLexeme();
            if (next != null && next.typeIndex == 42) {
                this.printLexeme(next);
            }
            if (bracePosition == 2) {
                writer.decreaseIndent();
            }
        }
    }

    private void writeDefaultNode(JSNaryNode nnode, SourceWriter writer) {
        this.printLexeme(nnode.getStartingLexeme());
        this.printNextLexemeIfOfType(78);
        if (this.codeoptions.indentStatementsCompareToCases) {
            writer.increaseIndent();
        }
        if (writer.getCurrentIndentLevel() > 0) {
            this.printLineEnding((IParseNode)nnode);
        }
        int i = 0;
        while (i < nnode.getChildCount()) {
            JSParseNode statement = (JSParseNode)nnode.getChild(i);
            this.printIndent();
            this.writeFormattedSource(statement, writer, true);
            if (statement.getIncludesSemicolon()) {
                Lexeme next = this.getNextLexemeIfOfType(43);
                if (next != null) {
                    this.printLexeme(next);
                    this.printLineEnding((IParseNode)nnode);
                }
            } else {
                this.printLineEnding((IParseNode)nnode);
            }
            ++i;
        }
        if (this.codeoptions.indentStatementsCompareToCases) {
            writer.decreaseIndent();
        }
    }

    private String[] splitOnLines(String comment) {
        String[] result = null;
        ArrayList<String> lines = new ArrayList<String>();
        boolean lastSlash = false;
        int lastPos = 0;
        int a = 0;
        while (a < comment.length()) {
            char c = comment.charAt(a);
            if (c == '\n' || c == '\r') {
                if (!lastSlash) {
                    lastSlash = true;
                    lines.add(comment.substring(lastPos, a));
                    lastPos = a + 1;
                }
            } else {
                lastSlash = false;
            }
            ++a;
        }
        lines.add(comment.substring(lastPos, comment.length()));
        result = new String[lines.size()];
        lines.toArray(result);
        return result;
    }

    private void writePrimitiveNode(JSPrimitiveNode pnode, SourceWriter writer) {
        this.printLexeme(pnode.getStartingLexeme());
    }

    private void writeStringNode(JSStringNode snode, SourceWriter writer) {
        this.printLexeme(snode.getStartingLexeme());
    }

    private void writeTextNode(JSTextNode tnode, SourceWriter writer) {
        this.writeCommon(tnode, writer, true);
    }

    private void writeSourceUnary(JSUnaryOperatorNode onode, SourceWriter writer, boolean appendTrailing, boolean useSpace, boolean operatorFirst) {
        if (operatorFirst) {
            this.printLexeme(onode.getStartingLexeme());
        }
        if (useSpace) {
            this.print(' ');
        }
        JSParseNode operand = (JSParseNode)onode.getChild(0);
        this.writeFormattedSource(operand, writer, appendTrailing);
        if (!operatorFirst) {
            this.printLexeme(onode.getEndingLexeme());
        }
    }

    private void writeUnaryOperatorNode(JSUnaryOperatorNode unode, SourceWriter writer) {
        switch (unode.getTypeIndex()) {
            case 74: {
                JSParseNode operand = (JSParseNode)unode.getChild(0);
                this.printNextLexemeIfOfType(50);
                this.writeFormattedSource(operand, writer, true);
                this.printNextLexemeIfOfType(58);
                break;
            }
            case 83: {
                if (this.codeoptions.insertNewLineBeforeReturn && !this.nextReturnNoNewLine) {
                    this.printLineEnding((IParseNode)unode);
                    if (writer.getCurrentIndentationLevel() == 0) {
                        writer.printIndent();
                    }
                }
                this.printNextLexemeIfOfType(24);
                this.printNextLexemeIfOfType(43);
                int previous = this.codeoptions.formatterBracePositionForArrayInitializer;
                this.codeoptions.formatterBracePositionForArrayInitializer = 0;
                if (unode.getChildCount() > 0) {
                    JSParseNode operand = (JSParseNode)unode.getChild(0);
                    if (operand.getTypeIndex() != 43) {
                        this.print(" ");
                        this.writeFormattedSource(operand, writer, true);
                    }
                } else {
                    Lexeme next = this.getNextLexemeIfOfType(43);
                    if (next != null) {
                        this.print(' ');
                        this.printLexeme(next);
                    }
                }
                this.codeoptions.formatterBracePositionForArrayInitializer = previous;
                break;
            }
            case 85: {
                JSParseNode operand = (JSParseNode)unode.getChild(0);
                this.printNextLexemeIfOfType(29);
                if (operand.getTypeIndex() != 74) {
                    this.print(" ");
                }
                this.writeFormattedSource(operand, writer, true);
                break;
            }
            case 73: 
            case 76: 
            case 84: 
            case 86: {
                this.writeSourceUnary(unode, writer, true, true, true);
                break;
            }
            case 75: 
            case 77: 
            case 78: 
            case 81: 
            case 82: {
                this.writeSourceUnary(unode, writer, true, false, true);
                break;
            }
            case 79: 
            case 80: {
                this.writeSourceUnary(unode, writer, true, false, false);
                break;
            }
        }
    }

    private void writeVarNode(JSVarNode vnode, SourceWriter writer) {
        this.writeCommon(vnode, writer, true);
    }

    public String createNestedMark() {
        return null;
    }

    public boolean handlesNested() {
        return true;
    }

    public int getCurrentIndentationLevel() {
        int iLevel = 0;
        String currentIndentationString = this.writer.getCurrentIndentationString();
        int a = 0;
        while (a < currentIndentationString.length()) {
            char c = currentIndentationString.charAt(a);
            if (c == ' ') {
                ++iLevel;
            } else if (c == '\t') {
                iLevel += this.codeoptions.tabSize;
            }
            ++a;
        }
        return iLevel;
    }

    private class CommentNode {
        GenericCommentNode node;
        boolean isMultiline = false;
        boolean printed = false;
        int indentLevel;
        boolean isNoFormat = false;
        boolean isFormat = false;

        private CommentNode() {
        }
    }
}

