/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.environment;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.environment.JSGuessedObject;
import com.aptana.ide.editor.js.environment.JSLexemeListWalker;
import com.aptana.ide.editor.js.environment.JSReference;
import com.aptana.ide.editor.js.environment.Messages;
import com.aptana.ide.editor.js.environment.ScopeRange;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.FunctionBase;
import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.IScope;
import com.aptana.ide.editor.js.runtime.JSFunction;
import com.aptana.ide.editor.js.runtime.JSObject;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.OrderedObject;
import com.aptana.ide.editor.js.runtime.OrderedObjectCollection;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.js.runtime.Reference;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.parsing.IParseState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

public class LexemeBasedEnvironmentLoader {
    private Environment _environment;
    private List<ScopeRange> _scopeList = new ArrayList<ScopeRange>();
    private IParseState _parseState;

    public LexemeBasedEnvironmentLoader(Environment env) {
        this._environment = env;
        ScopeRange sr = new ScopeRange(env.getGlobal(), 0, Integer.MAX_VALUE);
        this._scopeList.add(sr);
    }

    public int getFileIndex() {
        return this._parseState.getFileIndex();
    }

    IObject addProperty(IScope parentScope, IObject parent, String name, int offset) {
        IObject propValue = this.getPropertyValue(parent, name, offset);
        if (propValue == ObjectBase.UNDEFINED) {
            propValue = this.createGuessedObject(new Range(offset, offset + 1));
            this.putPropertyValue(parent, name, propValue);
        }
        return propValue;
    }

    IObject addVariable(IScope parentScope, String name, int offset, boolean isVar) {
        IObject propValue;
        if (isVar) {
            if (name.equals("this") && parentScope.hasLocalProperty("this")) {
                propValue = parentScope.getLocalProperty("this").getValue(this.getFileIndex(), offset);
            } else {
                propValue = this.createGuessedObject(new Range(offset, offset + 1));
                this.putVariableValue(parentScope, name, propValue, isVar);
            }
        } else {
            propValue = this.getVariableValue(parentScope, name, offset);
            if (propValue == ObjectBase.UNDEFINED) {
                propValue = this.createGuessedObject(new Range(offset, offset + 1));
                this.putVariableValue(parentScope, name, propValue, isVar);
            }
        }
        return propValue;
    }

    JSFunction createFunctionInstance(int offset, boolean isInvoking) {
        JSFunction function = (JSFunction)this.createNewInstance("Function", offset, isInvoking);
        return function;
    }

    private IObject createGuessedObject(Range range) {
        return new JSGuessedObject((IRange)range);
    }

    IObject createNewInstance(String type, int offset, boolean isInvoking) {
        boolean needsInstance = false;
        if (type.charAt(0) == '+') {
            needsInstance = true;
            type = type.substring(1);
        }
        IObject currentRoot = this._environment.getGlobal();
        String[] propertyNames = type.split("\\.");
        int i = 0;
        while (currentRoot != ObjectBase.UNDEFINED && i < propertyNames.length) {
            currentRoot = currentRoot.getPropertyValue(propertyNames[i], this.getFileIndex(), offset);
            ++i;
        }
        if (currentRoot instanceof JSFunction && !isInvoking) {
            if (needsInstance) {
                return this.createNewInstance(offset, (IFunction)((Object)currentRoot));
            }
            JSFunction fn = (JSFunction)currentRoot;
            JSFunction nw = new JSFunction((IRange)new Range(offset, offset + 1));
            nw.setBodyScope(fn.getBodyScope());
            nw.setDocumentation(fn.getDocumentation());
            nw.setGuessedMemberObject(fn.getGuessedMemberObject());
            String[] names = fn.getLocalPropertyNames();
            int i2 = 0;
            while (i2 < names.length) {
                String name = names[i2];
                nw.putLocalProperty(name, fn.getLocalProperty(name));
                ++i2;
            }
            nw.setParameterNames(fn.getParameterNames());
            return nw;
        }
        if (currentRoot instanceof IFunction) {
            return this.createNewInstance(offset, (IFunction)((Object)currentRoot));
        }
        IObject ob = this.createGuessedObject(new Range(offset, offset + 1));
        return ob;
    }

    IObject createNewInstance(int offset, IFunction function) {
        IObject fnObj = function.construct(this._environment, FunctionBase.EmptyArgs, this.getFileIndex(), (IRange)new Range(offset, offset + 1));
        return fnObj;
    }

    IObject getPropertyValue(Reference reference, int offset) {
        IObject result = reference.getObjectBase() instanceof IScope ? this.getVariableValue((IScope)reference.getObjectBase(), reference.getPropertyName(), offset) : this.getPropertyValue(reference.getObjectBase(), reference.getPropertyName(), offset);
        return result;
    }

    IObject getPropertyValue(IObject parent, String name, int offset) {
        if (parent instanceof IScope) {
            throw new IllegalArgumentException(Messages.LexemeBasedEnvironmentLoader_ContCallGetPropertyValue);
        }
        IObject propValue = parent.getPropertyValue(name, this.getFileIndex(), offset);
        return propValue;
    }

    public IScope getScope(int offset, IScope defaultScope) {
        int size = this._scopeList.size();
        if (size == 0) {
            return defaultScope;
        }
        try {
            int rangeIndex = 0;
            int i = 0;
            while (i < size) {
                ScopeRange currRange = this._scopeList.get(i);
                if (offset <= currRange.startOffset) break;
                rangeIndex = i++;
            }
            int j = rangeIndex;
            while (j >= 0) {
                ScopeRange range = this._scopeList.get(j);
                if (range.endOffset != -1 && range.endOffset > offset) {
                    return range.scope;
                }
                --j;
            }
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.LexemeBasedEnvironmentLoader_GetScopeFailed, (Throwable)e);
        }
        return defaultScope;
    }

    IObject getVariableValue(IScope parentScope, String name, int offset) {
        IObject propValue = parentScope.getVariableValue(name, this.getFileIndex(), offset);
        if (propValue == ObjectBase.UNDEFINED) {
            propValue = this._environment.getGlobal().getPropertyValue(name, this.getFileIndex(), offset);
        }
        return propValue;
    }

    private void loadEnvironment(IParseState parseState) {
        try {
            this._parseState = parseState;
            ScopeRange sr = new ScopeRange(this._environment.getGlobal(), 0, Integer.MAX_VALUE);
            this._scopeList.add(sr);
            JSLexemeListWalker walker = new JSLexemeListWalker(this._environment, this._environment.getGlobal(), this);
            walker.walkList(parseState, 0);
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.LexemeBasedEnvironmentLoader_LoadEnvironmentFailed, (Throwable)e);
        }
        Collections.sort(this._scopeList);
    }

    void putPropertyValue(JSReference ref, IObject value) {
        IObject base = ref.getObjectBase();
        String name = ref.getPropertyName();
        if (base instanceof IScope) {
            IScope scope = (IScope)base;
            IObject existing = scope.getVariableValue(name, this.getFileIndex(), value.getStartingOffset());
            if (existing != null && existing.getStartingOffset() == value.getStartingOffset()) {
                return;
            }
            this.putVariableValue(scope, name, value, ref.isVar());
        } else {
            if (ref.isVar()) {
                throw new IllegalStateException(Messages.LexemeBasedEnvironmentLoader_CantPutVarOnNonScope);
            }
            IObject existing = base.getPropertyValue(name, this.getFileIndex(), value.getStartingOffset());
            if (existing != null && existing.getStartingOffset() == value.getStartingOffset()) {
                return;
            }
            this.putPropertyValue(base, name, value);
        }
    }

    void putPropertyValue(IObject parentObject, String name, IObject value) {
        if (parentObject instanceof IScope) {
            throw new IllegalArgumentException(Messages.LexemeBasedEnvironmentLoader_ContCallPutPropertyValue);
        }
        parentObject.putPropertyValue(name, value, this.getFileIndex(), 0);
        Reference reference = new Reference(parentObject, name);
        Map updatedProperties = this._parseState.getUpdatedProperties();
        updatedProperties.put(reference.getProperty(), reference);
    }

    void putVariableValue(IScope scope, String name, IObject value, boolean isVar) {
        boolean skipAssignment = false;
        if (isVar) {
            Property prop;
            if (!scope.hasLocalProperty(name)) {
                prop = new Property(value, this.getFileIndex(), 0);
                scope.putLocalProperty(name, prop);
            } else if (value instanceof JSObject && value.getLocalPropertyCount() == 0 && value.getPrototype() == null && scope.getVariable(name).hasAssignments()) {
                skipAssignment = true;
            } else {
                prop = scope.getLocalProperty(name);
                prop.setValue(value, this.getFileIndex());
            }
        } else if (scope.hasVariable(name)) {
            Property existing = scope.getVariable(name);
            if (value instanceof JSObject && value.getLocalPropertyCount() == 0 && value.getPrototype() == null && existing.hasAssignments()) {
                skipAssignment = true;
            } else {
                scope.putVariableValue(name, value, this.getFileIndex());
            }
        } else {
            this._environment.getGlobal().putVariableValue(name, value, this.getFileIndex());
        }
        if (!skipAssignment) {
            IScope owningScope = scope.getOwningScope(name);
            Reference reference = new Reference(owningScope, name);
            Map updatedProperties = this._parseState.getUpdatedProperties();
            updatedProperties.put(reference.getProperty(), reference);
        }
    }

    void registerScope(IScope scope, int startOffset, int endOffset) {
        this._scopeList.add(new ScopeRange(scope, startOffset, endOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadEnvironment(IParseState parseState) {
        this._parseState = parseState;
        Environment environment = this._environment;
        synchronized (environment) {
            LexemeList lexemeList;
            LexemeList lexemeList2 = lexemeList = this._parseState.getLexemeList();
            synchronized (lexemeList2) {
                try {
                    this.unloadEnvironment();
                    if (this._parseState.getFileIndex() > -1) {
                        this.loadEnvironment(parseState);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.LexemeBasedEnvironmentLoader_ErrorReloading, (Throwable)e);
                }
            }
        }
    }

    public void replaceFunctionDeclaration(int offset, IScope parentScope, String functionName, JSFunction func) {
        if (parentScope.hasLocalProperty(functionName)) {
            Property oldProperty = parentScope.getLocalProperty(functionName);
            Map updatedProperties = this._parseState.getUpdatedProperties();
            OrderedObjectCollection c = oldProperty.getAssignments();
            int j = 0;
            while (j < c.size()) {
                OrderedObject obj = c.get(j);
                if (obj.object instanceof JSGuessedObject) {
                    IObject oldObject = obj.object;
                    String[] localProps = oldObject.getLocalPropertyNames();
                    int i = 0;
                    while (i < localProps.length) {
                        Property oldProp = oldObject.getLocalProperty(localProps[i]);
                        if (!func.hasLocalProperty(localProps[i])) {
                            func.putLocalProperty(localProps[i], oldProp);
                            updatedProperties.put(oldProp, new Reference(func, localProps[i]));
                        } else if (updatedProperties.containsKey(oldProp)) {
                            updatedProperties.remove(oldProp);
                        }
                        ++i;
                    }
                    c.remove(obj.fileIndex, obj.object.getStartingOffset());
                    --j;
                }
                ++j;
            }
            updatedProperties.remove(oldProperty);
        }
        this.putVariableValue(parentScope, functionName, func, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadEnvironment() {
        Environment environment = this._environment;
        synchronized (environment) {
            if (this._parseState != null) {
                this._parseState.getParent().unloadFromEnvironment();
                this._scopeList.clear();
            }
        }
    }
}

