/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.environment;

import com.aptana.ide.editor.js.environment.EndOfFileException;
import com.aptana.ide.editor.js.environment.LexemeBasedEnvironmentLoader;
import com.aptana.ide.editor.js.environment.LexemeConsumerHelper;
import com.aptana.ide.editor.js.environment.LexemeListWalker;
import com.aptana.ide.editor.js.parsing.JSParseState;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.IScope;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.metadata.IDocumentationStore;
import com.aptana.ide.parsing.IParseState;

public class JSLexemeListWalker
extends LexemeListWalker {
    Environment env;
    IScope currentScope;
    LexemeBasedEnvironmentLoader envLoader;
    LexemeConsumerHelper consumerHelper;
    boolean isVar;

    protected JSLexemeListWalker(Environment env, IScope initialScope, LexemeBasedEnvironmentLoader envLoader) {
        this.currentScope = initialScope;
        this.env = env;
        this.envLoader = envLoader;
    }

    public int walkList(IParseState parseState, int startIndex) {
        this.consumerHelper = new LexemeConsumerHelper(this.env, this.envLoader, parseState);
        int result = super.walkList(parseState, startIndex);
        this.addScriptDocObjects(parseState);
        return result;
    }

    protected void onLexeme(Lexeme lexeme, int index) throws LexemeListWalker.AbortException {
        if (!lexeme.getLanguage().equals("text/javascript")) {
            return;
        }
        try {
            LexemeConsumerHelper.LexemeConsumerResult result = this.consumerHelper.consumeStatements(index, this.currentScope);
            this.currentIndex = result.endIndex;
        }
        catch (EndOfFileException endOfFileException) {
            throw new LexemeListWalker.AbortException(this, this.llSize);
        }
    }

    private void addScriptDocObjects(IParseState parseState) {
        IDocumentationStore store;
        JSParseState jsps = (JSParseState)parseState.getParseState("text/javascript");
        if (jsps != null && (store = jsps.getDocumentationStore()) != null) {
            IDocumentation[] docs = store.getDocumentationObjects();
            int i = 0;
            while (i < docs.length) {
                if (docs[i] instanceof PropertyDocumentation) {
                    PropertyDocumentation doc = (PropertyDocumentation)docs[i];
                    String[] aliases = doc.getAliases().getTypes();
                    int j = 0;
                    while (j < aliases.length) {
                        String alias = aliases[j];
                        LexemeConsumerHelper.addDocHolderToEnvironment(alias, doc, parseState);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

