/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.contentassist;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.ide.editor.js.contentassist.Messages;
import com.aptana.ide.editor.scriptdoc.ScriptDocHelper;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class JSContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private JSContentAssistProcessor fProcessor;
    private IContextInformation fContextInformation;

    public JSContextInformationValidator(JSContentAssistProcessor processor) {
        this.fProcessor = processor;
    }

    public void install(IContextInformation contextInformation, ITextViewer viewer, int offset) {
        this.fContextInformation = contextInformation;
    }

    public boolean isContextInformationValid(int offset) {
        if (this.fProcessor.initalPopup) {
            this.fProcessor.initalPopup = false;
            return true;
        }
        return this.fProcessor.getJSOffsetMapper().getMode(offset).equalsIgnoreCase("__mode_invoking");
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        String[] lines;
        int arg;
        String s;
        block10: {
            block9: {
                s = this.fContextInformation.getInformationDisplayString();
                arg = this.fProcessor.getJSOffsetMapper().getArgIndexAndCalculateMode();
                if (s.indexOf("(") != -1) break block9;
                return false;
            }
            presentation.clear();
            lines = s.split(ScriptDocHelper.DEFAULT_DELIMITER);
            s = lines[0];
            if (s.indexOf("()") <= 0) break block10;
            return false;
        }
        try {
            int count = 0;
            int startPos = s.indexOf("(");
            int endPos = s.indexOf(",");
            if (endPos == -1) {
                endPos = s.indexOf(")");
            }
            RGB blackColor = new RGB(0, 0, 0);
            ColorRegistry cm = JFaceResources.getColorRegistry();
            cm.put("black", blackColor);
            Color norm = cm.get("black");
            StyleRange st = new StyleRange(0, startPos, norm, null, 1);
            presentation.addStyleRange(st);
            while (count < arg) {
                startPos = endPos;
                if ((endPos = s.indexOf(",", startPos + 1)) == -1) {
                    endPos = s.indexOf(")", startPos);
                }
                if (endPos == -1) break;
                ++count;
            }
            st = new StyleRange(++startPos, endPos - startPos, norm, null, 1);
            presentation.addStyleRange(st);
            int delimiterLength = ScriptDocHelper.DEFAULT_DELIMITER.length();
            if (lines.length > 1) {
                int totalLen = lines[0].length() + delimiterLength;
                int i = 1;
                while (i < lines.length) {
                    String line = lines[i];
                    StyleRange argNameStyle = null;
                    argNameStyle = arg + 1 == i ? new StyleRange(totalLen, line.length(), norm, null, 1) : new StyleRange(totalLen, line.indexOf(":"), norm, null, 0);
                    presentation.addStyleRange(argNameStyle);
                    totalLen += line.length() + delimiterLength;
                    ++i;
                }
            }
            return true;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.JSContextInformationValidator_ErrorUpdatingCOntext, (Throwable)e);
            return true;
        }
    }
}

