/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js;

import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.ide.editor.js.formatting.JSAutoIndentStrategy;
import com.aptana.ide.editor.js.formatting.JSBracketInserter;
import com.aptana.ide.editor.jscomment.JSCommentContributor;
import com.aptana.ide.editor.scriptdoc.ScriptDocContributor;
import com.aptana.ide.editors.formatting.IUnifiedBracketInserter;
import com.aptana.ide.editors.unified.BaseContributor;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedDoubleClickStrategy;
import com.aptana.ide.editors.unified.UnifiedReconcilingStrategy;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.hover.LexemeTextHover;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;

public class JSContributor
extends BaseContributor {
    private IUnifiedEditorContributor[] childContributors;
    private ITextDoubleClickStrategy _doubleClickStrategy;
    private JSBracketInserter _bracketInserter;
    private SourceViewer _sourceViewer;
    private IAutoEditStrategy[] _autoEditStrategy;
    private LexemeTextHover _lexemeTextHover;
    private UnifiedReconcilingStrategy _reconcilingStrategy;
    private JSContentAssistProcessor _contentAssistProcessor;
    private boolean isDisposing = false;
    private LanguageColorizer _colorizer = this._colorizer == null ? null : this._colorizer;
    private JSBracketInserter _inserter;

    public JSContributor() {
        super("text/javascript");
    }

    public IUnifiedEditorContributor[] getChildContributors() {
        if (this.childContributors == null) {
            ScriptDocContributor sdc = new ScriptDocContributor();
            sdc.setParent((IUnifiedEditorContributor)this);
            JSCommentContributor jcc = new JSCommentContributor();
            jcc.setParent((IUnifiedEditorContributor)this);
            this.childContributors = new IUnifiedEditorContributor[]{sdc, jcc};
        }
        return this.childContributors;
    }

    public IContentAssistProcessor getLocalContentAssistProcessor(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/javascript")) {
            this._sourceViewer = (SourceViewer)sourceViewer;
            EditorFileContext context = this.getFileContext();
            if (context != null) {
                this._contentAssistProcessor = new JSContentAssistProcessor(context);
                return this._contentAssistProcessor;
            }
            return null;
        }
        return null;
    }

    public ITextHover getLocalTextHover(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/javascript")) {
            this._lexemeTextHover = new LexemeTextHover(this.getFileContext());
            return this._lexemeTextHover;
        }
        return null;
    }

    public UnifiedReconcilingStrategy getReconcilingStrategy() {
        this._reconcilingStrategy = new UnifiedReconcilingStrategy();
        return this._reconcilingStrategy;
    }

    public IAutoEditStrategy[] getLocalAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/javascript")) {
            this._autoEditStrategy = new IAutoEditStrategy[]{new JSAutoIndentStrategy(this.getFileContext(), this.getParentConfiguration(), sourceViewer)};
            return this._autoEditStrategy;
        }
        return null;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this._doubleClickStrategy == null) {
            this._doubleClickStrategy = new UnifiedDoubleClickStrategy();
        }
        return this._doubleClickStrategy;
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        if (this._bracketInserter != null) {
            this._sourceViewer.removeVerifyKeyListener((VerifyKeyListener)this._bracketInserter);
            this._bracketInserter = null;
        }
        if (this.childContributors != null) {
            int i = 0;
            while (i < this.childContributors.length) {
                IUnifiedEditorContributor child = this.childContributors[i];
                if (child instanceof BaseContributor) {
                    ((BaseContributor)child).dispose();
                }
                ++i;
            }
        }
        this.childContributors = null;
        if (this._colorizer != null) {
            this._colorizer.dispose();
            this._colorizer = null;
        }
        this._contentAssistProcessor = null;
        this._doubleClickStrategy = null;
        this._autoEditStrategy = null;
        this._sourceViewer = null;
        this._reconcilingStrategy = null;
        this._lexemeTextHover = null;
        super.dispose();
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return 97 <= keyCode && keyCode <= 122 || c == '_' || c == '$';
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return Character.isWhitespace(c) || c == '(' || c == ',';
    }

    public boolean isAutoActivateContentAssist() {
        return JSPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.CODE_ASSIST_AUTO_ACTIVATION");
    }

    public IUnifiedBracketInserter getLocalBracketInserter(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("text/javascript")) {
            EditorFileContext context = this.getFileContext();
            if (context != null) {
                this._inserter = new JSBracketInserter(sourceViewer, (IFileService)context);
                return this._inserter;
            }
            return null;
        }
        return null;
    }
}

