/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.javacloud.util;

import com.aptana.ide.server.javacloud.util.ResourceUtils;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtils {
    private static final ImageRegistry imageRegistry = new ImageRegistry();
    private static HashMap<Image, HashMap<Image, Image>> imageToDecoratorMap = new HashMap();
    private static final int MISSING_IMAGE_SIZE = 10;
    public static final String TOMCAT_MANGER = "sample.gif";
    public static final String UPLOAD_WAR = "upload_war_large.gif";
    public static final String WAR = "war.gif";
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    public static Image missingImage;

    public static synchronized Image getIcon(String imageKey) {
        if (imageRegistry.get(imageKey) == null) {
            try {
                imageRegistry.put(imageKey, ImageUtils.getImageDescriptor(imageKey).createImage(true));
            }
            catch (Exception exception) {
                if (missingImage == null) {
                    missingImage = ImageUtils.getMissingImage();
                }
                return missingImage;
            }
        }
        return imageRegistry.get(imageKey);
    }

    public static Image getIcon(Class<?> clazz, String imageKey) {
        if (imageRegistry.get(imageKey) == null) {
            try {
                imageRegistry.put(imageKey, ImageUtils.getImage(clazz.getResourceAsStream(imageKey)));
            }
            catch (Exception exception) {
                if (missingImage == null) {
                    missingImage = ImageUtils.getMissingImage();
                }
                return missingImage;
            }
        }
        return imageRegistry.get(imageKey);
    }

    protected static Image getImage(InputStream is) {
        Display display = Display.getCurrent();
        ImageData data = new ImageData(is);
        if (data.transparentPixel > 0) {
            return new Image((Device)display, data, data.getTransparencyMask());
        }
        return new Image((Device)display, data);
    }

    public static ImageDescriptor getImageDescriptor(String imageKey) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.server.javacloud", (String)("icons/" + imageKey));
    }

    public static Image decorateImage(final Image baseImage, final Image decorator, final int corner) {
        Image result;
        HashMap<Object, Object> decoratedMap = imageToDecoratorMap.get(baseImage);
        if (decoratedMap == null) {
            decoratedMap = new HashMap();
            imageToDecoratorMap.put(baseImage, decoratedMap);
        }
        if ((result = decoratedMap.get(decorator)) == null) {
            final Rectangle bid = baseImage.getBounds();
            final Rectangle did = decorator.getBounds();
            final Point baseImageSize = new Point(bid.width, bid.height);
            CompositeImageDescriptor compositImageDesc = new CompositeImageDescriptor(){

                protected void drawCompositeImage(int width, int height) {
                    this.drawImage(baseImage.getImageData(), 0, 0);
                    if (corner == 1) {
                        this.drawImage(decorator.getImageData(), 0, 0);
                    } else if (corner == 2) {
                        this.drawImage(decorator.getImageData(), bid.width - did.width - 1, 0);
                    } else if (corner == 3) {
                        this.drawImage(decorator.getImageData(), 0, bid.height - did.height - 1);
                    } else if (corner == 4) {
                        this.drawImage(decorator.getImageData(), bid.width - did.width - 1, bid.height - did.height - 1);
                    }
                }

                protected Point getSize() {
                    return baseImageSize;
                }
            };
            result = compositImageDesc.createImage();
            decoratedMap.put(decorator, result);
        }
        return result;
    }

    private static Image getMissingImage() {
        Image image = new Image((Device)Display.getCurrent(), 10, 10);
        GC gc = new GC((Drawable)image);
        gc.setBackground(ResourceUtils.getColor(3));
        gc.fillRectangle(0, 0, 10, 10);
        gc.dispose();
        return image;
    }

    public static void dispose() {
        imageRegistry.dispose();
        for (HashMap<Image, Image> decoratedMap : imageToDecoratorMap.values()) {
            for (Image image : decoratedMap.values()) {
                image.dispose();
            }
        }
    }
}

