/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.validator.properties;

import com.aptana.ide.editor.css.validator.properties.CSSValueTypeConverter;
import com.aptana.ide.editor.css.validator.properties.CSSValueValidator;
import com.aptana.ide.editor.css.validator.properties.PlugableCSSProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class MozOpacityCSSProperty
extends PlugableCSSProperty {
    private static final String PROPERTY_NAME = "-moz-opacity";
    private static final OpacityValidator VALIDATOR = new OpacityValidator();

    public MozOpacityCSSProperty() {
        super(PROPERTY_NAME);
    }

    public MozOpacityCSSProperty(ApplContext context, CssExpression expression, boolean check) throws InvalidParamException {
        super(PROPERTY_NAME, new Class[]{CssNumber.class}, null, new CSSValueValidator[]{VALIDATOR}, context, expression, check);
    }

    public MozOpacityCSSProperty(String propertyName, Class[] types, CSSValueTypeConverter[] converters, CSSValueValidator[] validators, ApplContext context, CssExpression expression) throws InvalidParamException {
        this(context, expression, false);
    }

    private static class OpacityValidator
    implements CSSValueValidator {
        private OpacityValidator() {
        }

        public boolean canValidate(CssValue value) {
            return value instanceof CssNumber;
        }

        public boolean isValid(CssValue value) {
            if (!(value instanceof CssNumber)) {
                throw new IllegalArgumentException("Value " + value + " can not be validated");
            }
            float fValue = ((CssNumber)value).getValue();
            return fValue >= 0.0f && fValue <= 1.0f;
        }
    }
}

