/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.css.CSSPlugin;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

public class NewLineUtils {
    private Map<Integer, Integer> lineOffsets = new LinkedHashMap<Integer, Integer>();
    private String text;

    public NewLineUtils(String text) {
        this.text = text;
        this.lineOffsets.put(new Integer(0), new Integer(0));
        StringReader reader = new StringReader(text);
        int currentOffset = 0;
        int lineNumber = 1;
        try {
            int currentChar;
            while ((currentChar = reader.read()) != -1) {
                switch (currentChar) {
                    case 13: {
                        reader.mark(1);
                        int nextChar = reader.read();
                        ++currentOffset;
                        if (nextChar != 10) {
                            reader.reset();
                            --currentOffset;
                        }
                    }
                    case 10: {
                        if (currentOffset + 1 < text.length()) {
                            this.lineOffsets.put(new Integer(lineNumber), new Integer(currentOffset + 1));
                        }
                        ++lineNumber;
                        break;
                    }
                }
                ++currentOffset;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Exception while creating New Line Utils", (Throwable)e);
        }
    }

    public int getLineOffset(int lineNumber) {
        Integer offset = this.lineOffsets.get(new Integer(lineNumber));
        if (offset == null) {
            return -1;
        }
        return offset;
    }

    public int getFirstNonWhitespaceCharacterOffset(int lineNumber) {
        int startOffset = this.getLineOffset(lineNumber);
        if (startOffset == -1) {
            return -1;
        }
        int endOffset = this.getLineOffset(lineNumber + 1);
        if (endOffset == -1) {
            endOffset = this.text.length();
        }
        int i = startOffset;
        while (i < endOffset) {
            char ch = this.text.charAt(i);
            if (!Character.isWhitespace((int)ch)) {
                return i - startOffset;
            }
            ++i;
        }
        return -1;
    }

    public int getLineOfOffset(int offset) {
        if (this.lineOffsets.size() == 0) {
            return 0;
        }
        Collection values = this.lineOffsets.entrySet();
        Iterator it = values.iterator();
        int lineNumber = 0;
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Integer currentOffset = (Integer)entry.getValue();
            if (currentOffset > offset) {
                return lineNumber - 1;
            }
            ++lineNumber;
        }
        return lineNumber - 1;
    }
}

