/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.parsing;

import com.aptana.ide.editor.css.parsing.CSSParserBase;
import com.aptana.ide.editor.css.parsing.nodes.CSSCharSetNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSDeclarationNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSExprNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSImportNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSListNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSMediaNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSMediumNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSPageNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSParseNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSRuleSetNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSSelectorNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSSimpleSelectorNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSTermNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSTextNode;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.ParseNodeBase;
import com.aptana.ide.parsing.nodes.ParseRootNode;
import java.text.ParseException;
import java.util.Arrays;

public class CSSParser
extends CSSParserBase {
    private static final int[] atKeywordSet = new int[]{7, 21, 22, 23, 24};
    private static final int[] attributeValueOperator = new int[]{45, 36, 37};
    private static final int[] attributeSet2 = new int[]{4, 5};
    private static final int[] combinatorSet = new int[]{39, 43};
    private static final int[] dimensionsSet = new int[]{11, 13, 14, 15, 16, 17, 18};
    private static final int[] typeOrUniversalSelector = new int[]{4, 41, 48};
    private static final int[] operatorSet = new int[]{44, 38};
    private static final int[] simpleSelectorSet1 = new int[]{4, 41, 9, 8, 34, 29};
    private static final int[] attributeSelector = new int[]{9, 8, 34, 29, 20};
    private static final int[] primitivesAndOperators = new int[]{44, 38, 39, 40, 6, 12, 15, 13, 14, 16, 17, 18, 10, 5, 4, 25, 20};
    private static final int[] primitives = new int[]{39, 40, 6, 12, 15, 13, 14, 16, 17, 18, 10, 5, 4, 25, 20, 44, 38};
    private static final int[] termSet3 = new int[]{6, 12, 15, 13, 14, 16, 17, 18, 10, 5, 4, 25, 20};
    private static final int[] unaryOperatorSet = new int[]{39, 40};
    private static final String DEFAULT_GROUP = "default";

    static {
        Arrays.sort(atKeywordSet);
        Arrays.sort(attributeValueOperator);
        Arrays.sort(attributeSet2);
        Arrays.sort(combinatorSet);
        Arrays.sort(dimensionsSet);
        Arrays.sort(typeOrUniversalSelector);
        Arrays.sort(operatorSet);
        Arrays.sort(simpleSelectorSet1);
        Arrays.sort(attributeSelector);
        Arrays.sort(primitivesAndOperators);
        Arrays.sort(primitives);
        Arrays.sort(termSet3);
        Arrays.sort(unaryOperatorSet);
    }

    public CSSParser() throws ParserInitializationException {
        this("text/css");
    }

    public CSSParser(String mimeType) throws ParserInitializationException {
        super(mimeType);
    }

    private CSSParseNode createNode(int type, Lexeme startingLexeme) {
        return (CSSParseNode)this.getParseNodeFactory().createParseNode(type, startingLexeme);
    }

    public synchronized void parseAll(IParseNode parentNode) throws LexerException {
        IParseNode rootNode = this.getParseRootNode(parentNode, ParseRootNode.class);
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), DEFAULT_GROUP);
        this.advance();
        while (!this.isEOS()) {
            CSSParseNode result = null;
            try {
                try {
                    switch (this.currentLexeme.typeIndex) {
                        case 7: {
                            result = this.parseAtRule();
                            break;
                        }
                        case 24: {
                            result = this.parseCharSet();
                            break;
                        }
                        case 21: {
                            result = this.parseImport();
                            break;
                        }
                        case 22: {
                            result = this.parsePage();
                            break;
                        }
                        case 23: {
                            result = this.parseMedia();
                            break;
                        }
                        case 4: 
                        case 8: 
                        case 9: 
                        case 20: 
                        case 29: 
                        case 34: 
                        case 41: 
                        case 47: 
                        case 48: {
                            result = this.parseRuleSet();
                            break;
                        }
                        default: {
                            this.advance();
                            break;
                        }
                    }
                }
                catch (ParseException parseException) {
                    lexer.setGroup(DEFAULT_GROUP);
                    this.advance();
                }
            }
            finally {
                if (rootNode != null && result != null) {
                    rootNode.appendChild((IParseNode)result);
                }
            }
        }
    }

    private CSSCharSetNode parseCharSet() throws LexerException, ParseException {
        CSSCharSetNode result = (CSSCharSetNode)this.createNode(3, this.currentLexeme);
        this.assertAndAdvance(24, "error.charset");
        this.assertType(5, "error.charset.name");
        CSSTextNode name = (CSSTextNode)this.createNode(14, this.currentLexeme);
        result.appendChild((IParseNode)name);
        this.advance();
        this.assertType(30, "error.charset.semicolon");
        result.includeLexemeInRange(this.currentLexeme);
        this.advance();
        return result;
    }

    private ParseNodeBase parseImport() throws LexerException, ParseException {
        CSSImportNode result = (CSSImportNode)this.createNode(5, this.currentLexeme);
        this.assertAndAdvance(21, "error.import");
        switch (this.currentLexeme.typeIndex) {
            case 5: 
            case 25: {
                String name = this.currentLexeme.getText();
                result.setAttribute("name", name);
                this.advance();
                break;
            }
            case 10: {
                StringBuilder buffer = new StringBuilder();
                buffer.append(this.currentLexeme.getText());
                this.advance();
                while (!this.isEOS() && !this.isType(33)) {
                    buffer.append(this.currentLexeme.getText());
                    this.advance();
                }
                if (this.isType(33)) {
                    buffer.append(this.currentLexeme.getText());
                    result.setAttribute("name", buffer.toString());
                    this.advance();
                    break;
                }
                this.throwParseError("error.import.name");
                break;
            }
            default: {
                this.throwParseError("error.import.name");
            }
        }
        if (this.isType(4)) {
            CSSListNode list = (CSSListNode)this.createNode(16, this.currentLexeme);
            list.setDelimiter(", ");
            CSSTextNode medium = (CSSTextNode)this.createNode(14, this.currentLexeme);
            list.appendChild((IParseNode)medium);
            this.advance();
            while (!this.isEOS() && this.isType(38)) {
                this.advance();
                this.assertType(4, "error.import.medium");
                medium = (CSSTextNode)this.createNode(14, this.currentLexeme);
                list.appendChild((IParseNode)medium);
                this.advance();
            }
            result.appendChild((IParseNode)list);
        }
        this.assertType(30, "error.import.semicolon");
        result.includeLexemeInRange(this.currentLexeme);
        this.advance();
        return result;
    }

    private CSSMediaNode parseMedia() throws LexerException, ParseException {
        CSSMediaNode result = (CSSMediaNode)this.createNode(7, this.currentLexeme);
        this.assertAndAdvance(23, "error.media");
        CSSListNode media = (CSSListNode)this.createNode(16, null);
        media.setDelimiter(", ");
        this.assertType(4, "error.media.identifier");
        CSSMediumNode medium = (CSSMediumNode)this.createNode(8, this.currentLexeme);
        media.appendChild((IParseNode)medium);
        this.advance();
        while (!this.isEOS() && this.isType(38)) {
            this.advance();
            this.assertType(4, "error.import.medium");
            medium = (CSSMediumNode)this.createNode(8, this.currentLexeme);
            media.appendChild((IParseNode)medium);
            this.advance();
        }
        result.appendChild((IParseNode)media);
        this.assertAndAdvance(31, "error.import.open");
        if (this.isType(4)) {
            CSSListNode ruleSets = (CSSListNode)this.createNode(16, this.currentLexeme);
            while (!this.isEOS() && this.isType(4)) {
                ruleSets.appendChild((IParseNode)this.parseRuleSet());
            }
            result.appendChild((IParseNode)ruleSets);
        } else {
            result.appendChild((IParseNode)CSSParseNode.Empty);
        }
        this.assertType(32, "error.import.close");
        result.includeLexemeInRange(this.currentLexeme);
        this.advance();
        return result;
    }

    private CSSPageNode parsePage() throws LexerException, ParseException {
        CSSPageNode result = (CSSPageNode)this.createNode(9, this.currentLexeme);
        this.assertAndAdvance(22, "error.page");
        if (this.isType(29)) {
            this.advance();
            this.assertType(4, "error.page.name");
            String pseudoPage = this.currentLexeme.getText();
            result.setAttribute("name", pseudoPage);
            this.advance();
        }
        this.assertAndAdvance(31, "error.page.open");
        CSSListNode declarations = (CSSListNode)this.createNode(16, null);
        declarations.setDelimiter("\n");
        if (this.isType(4) || this.isType(47)) {
            declarations.appendChild((IParseNode)this.parseDeclaration());
        }
        while (this.isType(30)) {
            this.advance();
            if (this.isType(4) || this.isType(47)) {
                declarations.appendChild((IParseNode)this.parseDeclaration());
                continue;
            }
            declarations.appendChild((IParseNode)CSSParseNode.Empty);
        }
        result.appendChild((IParseNode)declarations);
        this.assertType(32, "error.page.close");
        result.includeLexemeInRange(this.currentLexeme);
        this.advance();
        return result;
    }

    private CSSParseNode parseAtRule() throws LexerException, ParseException {
        CSSParseNode result = this.createNode(1, this.currentLexeme);
        this.inSet(atKeywordSet);
        this.advance();
        this.assertAndAdvance(5, "error.at-rule.name");
        switch (this.currentLexeme.typeIndex) {
            case 31: {
                result.appendChild((IParseNode)this.parseBlock());
                break;
            }
            case 30: {
                result.includeLexemeInRange(this.currentLexeme);
                this.advance();
                break;
            }
            default: {
                this.throwParseError("error-at-rule.semicolon");
            }
        }
        return result;
    }

    private CSSParseNode parseBlock() throws LexerException, ParseException {
        CSSParseNode result = this.createNode(2, this.currentLexeme);
        this.assertAndAdvance(31, "error.block.open");
        while (!this.isEOS() && !this.isType(32)) {
            this.advance();
        }
        if (this.isType(32)) {
            this.advance();
        }
        return result;
    }

    private CSSDeclarationNode parseDeclaration() throws LexerException, ParseException {
        try {
            this.assertType(4, "error.property");
        }
        catch (ParseException parseException) {
            this.assertType(47, "error.property");
        }
        this.changeTokenType(PROPERTY_TOKEN);
        String name = this.currentLexeme.getText();
        CSSDeclarationNode result = (CSSDeclarationNode)this.createNode(4, this.currentLexeme);
        result.setAttribute("name", name);
        this.advance();
        this.assertAndAdvance(29, "error.declaration.colon");
        result.includeLexemeInRange(this.currentLexeme);
        result.appendChild((IParseNode)this.parseExpression());
        if (this.isType(26)) {
            String important = this.currentLexeme.getText();
            result.setAttribute("status", important);
            result.includeLexemeInRange(this.currentLexeme);
            this.advance();
        }
        return result;
    }

    private void changeTokenType(IToken token) {
        if (this.currentLexeme.getToken() != token) {
            this.currentLexeme.setToken(token);
            this.getParseState().addUpdateRegion((IRange)this.currentLexeme);
        }
    }

    private CSSExprNode parseExpression() throws LexerException, ParseException {
        CSSExprNode result = (CSSExprNode)this.createNode(12, this.currentLexeme);
        result.appendChild((IParseNode)this.parseTerm());
        while (this.inSet(primitivesAndOperators)) {
            String operator = " ";
            CSSTermNode term = null;
            if (this.inSet(operatorSet)) {
                operator = this.currentLexeme.getText();
                this.advance();
            }
            if (this.inSet(primitives)) {
                term = this.parseTerm();
                term.setAttribute("joining-operator", operator);
                result.appendChild((IParseNode)term);
                continue;
            }
            this.throwParseError("error.expression.term");
        }
        return result;
    }

    private CSSTermNode parseTerm() throws LexerException, ParseException {
        CSSTermNode result = (CSSTermNode)this.createNode(13, this.currentLexeme);
        if (this.inSet(unaryOperatorSet)) {
            String operator = this.currentLexeme.getText();
            result.setAttribute("operator", operator);
            this.advance();
        }
        this.assertInSet(termSet3, "error.term");
        String value = this.currentLexeme.getText();
        result.setAttribute("value", value);
        result.includeLexemeInRange(this.currentLexeme);
        if (this.isType(10)) {
            this.advance();
            CSSExprNode expr = this.parseExpression();
            result.appendChild((IParseNode)expr);
            if (this.isType(33)) {
                result.includeLexemeInRange(this.currentLexeme);
            }
            this.assertAndAdvance(33, "error.function.close");
        } else {
            this.advance();
        }
        return result;
    }

    private CSSRuleSetNode parseRuleSet() throws ParseException, LexerException {
        CSSRuleSetNode result = (CSSRuleSetNode)this.createNode(6, this.currentLexeme);
        CSSListNode selectors = (CSSListNode)this.createNode(16, this.currentLexeme);
        selectors.setListName("selectors");
        selectors.appendChild((IParseNode)this.parseSelector());
        while (this.isType(38)) {
            this.advance();
            selectors.appendChild((IParseNode)this.parseSelector());
        }
        result.appendChild((IParseNode)selectors);
        this.assertAndAdvance(31, "error.rule-set.open");
        CSSListNode declarations = (CSSListNode)this.createNode(16, null);
        declarations.setDelimiter("\n");
        declarations.setListName("properties");
        if (this.isType(4) || this.isType(47)) {
            declarations.appendChild((IParseNode)this.parseDeclaration());
        } else if (this.isType(30)) {
            declarations.appendChild((IParseNode)CSSParseNode.Empty);
        }
        while (this.isType(30)) {
            this.advance();
            if (this.isType(4) || this.isType(47)) {
                declarations.appendChild((IParseNode)this.parseDeclaration());
                continue;
            }
            if (!this.isType(30)) continue;
            declarations.appendChild((IParseNode)CSSParseNode.Empty);
        }
        result.appendChild((IParseNode)declarations);
        result.includeLexemeInRange(this.currentLexeme);
        this.assertAndAdvance(32, "error.rule-set.close");
        return result;
    }

    private CSSSelectorNode parseSelector() throws ParseException, LexerException {
        boolean process = true;
        CSSSelectorNode result = (CSSSelectorNode)this.createNode(10, this.currentLexeme);
        if (this.isType(4)) {
            this.changeTokenType(SELECTOR_TOKEN);
        }
        CSSSimpleSelectorNode simpleSelector = this.parseSimpleSelector();
        simpleSelector.appendChild((IParseNode)CSSParseNode.Empty);
        result.appendChild((IParseNode)simpleSelector);
        while (process) {
            CSSTextNode combinator = null;
            simpleSelector = null;
            process = false;
            if (this.inSet(combinatorSet)) {
                combinator = (CSSTextNode)this.createNode(14, this.currentLexeme);
                this.advance();
                process = true;
            }
            if (this.inSet(simpleSelectorSet1)) {
                simpleSelector = this.parseSimpleSelector();
                if (combinator != null) {
                    simpleSelector.appendChild((IParseNode)combinator);
                } else {
                    simpleSelector.appendChild((IParseNode)CSSParseNode.Empty);
                }
                process = true;
            }
            if (simpleSelector == null) continue;
            result.appendChild((IParseNode)simpleSelector);
        }
        return result;
    }

    private CSSSimpleSelectorNode parseSimpleSelector() throws ParseException, LexerException {
        CSSTextNode component;
        CSSSimpleSelectorNode result = (CSSSimpleSelectorNode)this.createNode(11, this.currentLexeme);
        CSSListNode components = (CSSListNode)this.createNode(16, null);
        components.setListName("components");
        boolean needsOne = true;
        if (this.inSet(typeOrUniversalSelector)) {
            component = (CSSTextNode)this.createNode(14, this.currentLexeme);
            components.appendChild((IParseNode)component);
            result.includeLexemeInRange(this.currentLexeme);
            this.advance();
            needsOne = false;
        }
        while (this.inSet(attributeSelector) || needsOne) {
            Lexeme startingLexeme = this.currentLexeme;
            switch (this.currentLexeme.typeIndex) {
                case 8: 
                case 9: 
                case 20: {
                    component = (CSSTextNode)this.createNode(14, this.currentLexeme);
                    components.appendChild((IParseNode)component);
                    result.includeLexemeInRange(this.currentLexeme);
                    this.advance();
                    break;
                }
                case 34: {
                    String assertion = "";
                    startingLexeme = this.currentLexeme;
                    this.advance();
                    this.assertType(4, "error.attrib.name");
                    String name = this.currentLexeme.getText();
                    this.advance();
                    if (this.inSet(attributeValueOperator)) {
                        assertion = this.currentLexeme.getText();
                        this.advance();
                        this.assertInSet(attributeSet2, "error.attribute.assignment");
                        assertion = String.valueOf(assertion) + this.currentLexeme.getText();
                        this.advance();
                    }
                    result.includeLexemeInRange(this.currentLexeme);
                    Lexeme endingLexeme = this.currentLexeme;
                    this.assertAndAdvance(35, "error.attrib.close");
                    component = (CSSTextNode)this.createNode(14, startingLexeme);
                    component.setText("[" + name + assertion + "]");
                    component.includeLexemeInRange(endingLexeme);
                    components.appendChild((IParseNode)component);
                    break;
                }
                case 29: {
                    String text = ":";
                    startingLexeme = this.currentLexeme;
                    Lexeme endingLexeme = this.currentLexeme;
                    this.advance();
                    switch (this.currentLexeme.typeIndex) {
                        case 4: {
                            text = String.valueOf(text) + this.currentLexeme.getText();
                            endingLexeme = this.currentLexeme;
                            result.includeLexemeInRange(this.currentLexeme);
                            this.advance();
                            break;
                        }
                        case 10: {
                            text = String.valueOf(text) + this.currentLexeme.getText();
                            this.advance();
                            if (this.isType(4)) {
                                text = String.valueOf(text) + this.currentLexeme.getText();
                                this.advance();
                            }
                            endingLexeme = this.currentLexeme;
                            result.includeLexemeInRange(this.currentLexeme);
                            this.assertAndAdvance(33, "error.pseudo.function.close");
                            text = String.valueOf(text) + ")";
                            break;
                        }
                        default: {
                            this.throwParseError("error.pseudo");
                        }
                    }
                    component = (CSSTextNode)this.createNode(14, startingLexeme);
                    component.setText(text);
                    component.includeLexemeInRange(endingLexeme);
                    components.appendChild((IParseNode)component);
                    break;
                }
                default: {
                    this.throwParseError("error.simple-selector");
                }
            }
            needsOne = false;
        }
        result.appendChild((IParseNode)components);
        return result;
    }
}

