/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.contentassist;

import com.aptana.ide.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.util.Arrays;

public final class CSSUtils {
    private CSSUtils() {
    }

    public static String getLocation(int offset, LexemeList lexemeList) {
        if (offset == 0) {
            return CSSContentAssistProcessor.OUTSIDE_RULE;
        }
        String location = CSSContentAssistProcessor.OUTSIDE_RULE;
        int position = lexemeList.getLexemeFloorIndex(offset);
        boolean foundColon = false;
        while (position >= 0) {
            Lexeme curLexeme = lexemeList.get(position);
            if (!curLexeme.getLanguage().equals("text/css")) break;
            if (curLexeme.typeIndex == 32) {
                location = CSSContentAssistProcessor.OUTSIDE_RULE;
                break;
            }
            if (curLexeme.typeIndex == 29 && curLexeme.offset != offset) {
                foundColon = true;
            }
            if ((curLexeme.typeIndex == 30 || curLexeme.typeIndex == 31) && offset != curLexeme.offset) {
                if (foundColon) {
                    location = CSSContentAssistProcessor.ARG_ASSIST;
                    break;
                }
                location = CSSContentAssistProcessor.INSIDE_RULE;
                break;
            }
            --position;
        }
        return location;
    }

    public static boolean isColonAlreadyInserted(int offset, LexemeList ll) {
        Lexeme sibling = ll.getFloorLexeme(offset);
        Lexeme colon = CSSUtils.getNextLexemeOfType(sibling, new int[]{29}, new int[]{30, 32}, ll);
        return colon != null;
    }

    public static Lexeme getNextLexemeOfType(Lexeme startLexeme, int[] lexemeTypes, LexemeList lexemeList) {
        return CSSUtils.getNextLexemeOfType(startLexeme, lexemeTypes, new int[0], lexemeList);
    }

    public static Lexeme getNextLexemeOfType(Lexeme startLexeme, int[] lexemeTypes, int[] lexemeTypesToBail, LexemeList lexemeList) {
        int index;
        Arrays.sort(lexemeTypes);
        Arrays.sort(lexemeTypesToBail);
        int i = index = lexemeList.getLexemeIndex(startLexeme);
        while (i < lexemeList.size()) {
            Lexeme l = lexemeList.get(i);
            if (Arrays.binarySearch(lexemeTypes, l.typeIndex) >= 0) {
                return l;
            }
            if (Arrays.binarySearch(lexemeTypesToBail, l.typeIndex) >= 0) {
                return null;
            }
            ++i;
        }
        return null;
    }
}

