/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.editors.ISaveAsEvent;
import com.aptana.ide.core.ui.editors.ISaveEvent;
import com.aptana.ide.editor.css.BrowserExtensionLoader;
import com.aptana.ide.editor.css.CSSEditor;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.preview.PreviewConfigurationPage;
import com.aptana.ide.editors.toolbar.ToolbarWidget;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.ContributedOutline;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.views.outline.UnifiedOutlinePage;
import com.aptana.ide.views.outline.UnifiedQuickOutlinePage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class MultiPageCSSEditor
extends MultiPageEditorPart
implements ITextEditor,
ITextEditorExtension,
IUnifiedEditor {
    private CSSEditor editor;
    private ToolbarWidget toolbar;
    private Composite displayArea;
    private SourceEditorSite _siteEditor;
    protected File prevTempFile = null;
    private IElementStateListener elementListener = new IElementStateListener(){

        public void elementMoved(Object originalElement, Object movedElement) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementDeleted(Object element) {
            if (element.equals(MultiPageCSSEditor.this.getEditorInput())) {
                IWorkbenchPartSite site = MultiPageCSSEditor.this.getSite();
                if (site == null) {
                    return;
                }
                IWorkbenchWindow window = site.getWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                page.closeEditor((IEditorPart)MultiPageCSSEditor.this, true);
            }
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            IEditorInput newInput;
            if (propId == 258 && source instanceof CSSEditor && (newInput = ((CSSEditor)((Object)source)).getEditorInput()) != null) {
                MultiPageCSSEditor.this.setInput(newInput);
                MultiPageCSSEditor.this.setPartName(newInput.getName());
                MultiPageCSSEditor.this.setTitleToolTip(newInput.getToolTipText());
            }
        }
    };
    private Map previews = new HashMap();
    private String url;

    public MultiPageCSSEditor() {
        this.editor = new CSSEditor();
    }

    protected IEditorSite createSite(IEditorPart editor) {
        this._siteEditor = new SourceEditorSite(this, editor, this.getEditorSite());
        return this._siteEditor;
    }

    private void createPage0() {
        try {
            this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(0, " Source ");
            this.setPartName(this.getEditorInput().getName());
            this.editor.addPropertyListener(this.propertyListener);
            this.editor.getDocumentProvider().addElementStateListener(this.elementListener);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected Composite createPageContainer(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        IPreferenceStore store = CSSPlugin.getDefault().getPreferenceStore();
        boolean show = store.getBoolean("com.aptana.ide.editor.css.SHOW_CSS_TOOLBAR");
        if (show) {
            this.toolbar = new ToolbarWidget(new String[]{"text/css"}, new String[]{"text/css"}, CSSPlugin.getDefault().getPreferenceStore(), "com.aptana.ide.editor.css.LINK_CURSOR_WITH_CSS_TOOLBAR_TAB", (IUnifiedEditor)this);
            this.toolbar.createControl(this.displayArea);
        }
        Composite editorArea = new Composite(this.displayArea, 0);
        editorArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout eaLayout = new GridLayout(1, true);
        eaLayout.marginHeight = 0;
        eaLayout.marginWidth = 0;
        editorArea.setLayout((Layout)new FillLayout());
        return editorArea;
    }

    protected void createPages() {
        this.getSite().setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
        if (this.getContainer() instanceof CTabFolder) {
            final CTabFolder tabs = (CTabFolder)this.getContainer();
            tabs.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    Composite parent;
                    if (tabs.getItemCount() == 1 && MultiPageCSSEditor.this.displayArea != null && !MultiPageCSSEditor.this.displayArea.isDisposed() && (parent = MultiPageCSSEditor.this.displayArea.getParent()) != null && parent.getParent() != null) {
                        if (event.keyCode == 0x1000005) {
                            parent.getParent().traverse(256);
                        } else if (event.keyCode == 0x1000006) {
                            parent.getParent().traverse(512);
                        }
                    }
                }
            });
            Composite toolbar = new Composite((Composite)tabs, 0);
            toolbar.setLayoutData((Object)new GridData(128, 2));
            GridLayout layout = new GridLayout(1, true);
            final ToolBar tb = new ToolBar(toolbar, 0x800000);
            GridData tbData = new GridData(128);
            tabs.setTabHeight(21);
            tb.setLayoutData((Object)tbData);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            toolbar.setLayout((Layout)layout);
            tb.setLayout((Layout)layout);
            tb.setLayoutData((Object)new GridData(4, 4, false, false));
            final ToolItem configure = new ToolItem(tb, 4);
            configure.setImage(CSSPlugin.getImage("icons/configure.gif"));
            configure.setToolTipText("Configure CSS preview");
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail != 4) {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.css.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.css.preferences.PreviewPreferencePage"}, null);
                        dialog.open();
                    }
                }
            });
            final Menu menu = new Menu((Decorations)tabs.getShell(), 8);
            MenuItem editTemplate = new MenuItem(menu, 8);
            editTemplate.setText("Edit default preview template...");
            editTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.css.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.css.preferences.PreviewPreferencePage"}, null);
                    dialog.open();
                }
            });
            MenuItem editFileSettings = new MenuItem(menu, 8);
            if (this.getEditorInput() instanceof IFileEditorInput) {
                editFileSettings.setText("File preview settings...");
                editFileSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (MultiPageCSSEditor.this.getEditorInput() instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)MultiPageCSSEditor.this.getEditorInput()).getFile();
                            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)Display.getDefault().getActiveShell(), (IAdaptable)file, (String)"com.aptana.ide.editor.css.preview.cssPreviewPropertyPage", (String[])new String[]{"com.aptana.ide.editor.css.preview.cssPreviewPropertyPage"}, null);
                            dialog.open();
                        }
                    }
                });
                MenuItem editProjectSettings = new MenuItem(menu, 8);
                editProjectSettings.setText("Project preview settings...");
                editProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (MultiPageCSSEditor.this.getEditorInput() instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)MultiPageCSSEditor.this.getEditorInput()).getFile();
                            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)Display.getDefault().getActiveShell(), (IAdaptable)file.getProject(), (String)"com.aptana.ide.editor.css.preview.cssPreviewPropertyPage", (String[])new String[]{"com.aptana.ide.editor.css.preview.cssPreviewPropertyPage"}, null);
                            dialog.open();
                        }
                    }
                });
            }
            MenuItem editWorkspaceSettings = new MenuItem(menu, 8);
            editWorkspaceSettings.setText("Workspace preview settings...");
            editWorkspaceSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.css.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.css.preferences.PreviewPreferencePage"}, null);
                    dialog.open();
                }
            });
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        Rectangle rect = configure.getBounds();
                        Point pt = new Point(rect.x, rect.y + rect.height);
                        pt = tb.toDisplay(pt);
                        menu.setLocation(pt.x, pt.y);
                        menu.setVisible(true);
                    }
                }
            });
            tabs.setTopRight((Control)toolbar, 131072);
        }
        this.createPage0();
        this.loadBrowsers();
    }

    public void setPreviewPageText(int index, String title) {
        this.setPageText(index, title);
    }

    public void dispose() {
        if (this.editor != null) {
            if (this.editor.getDocumentProvider() != null) {
                this.editor.getDocumentProvider().removeElementStateListener(this.elementListener);
            }
            this.editor.removePropertyListener(this.propertyListener);
            this.editor.dispose();
        }
        if (this.previews != null && this.previews.size() != 0) {
            this.disposePreviews();
            this.previews = null;
        }
        if (this.toolbar != null) {
            this.toolbar.dispose();
        }
        this.editor = null;
        this._siteEditor = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorPart editor = this.getEditor(0);
        editor.doSave(monitor);
        this.setInput(editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setOffset(int offset) {
        this.setActivePage(0);
        this.editor.selectAndReveal(offset, 0);
    }

    public void setToolbarVisible(boolean visible) {
        if (this.toolbar != null && visible != this.toolbar.isVisible()) {
            this.toolbar.setVisible(visible);
            this.displayArea.setRedraw(false);
            this.displayArea.layout(true, true);
            this.displayArea.setRedraw(true);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex > 0) {
            this.updatePreview();
            this.setToolbarVisible(false);
        } else if (newPageIndex == 0) {
            this.setToolbarVisible(true);
        }
    }

    private String getExternalPreviewUrl(IEditorInput input) throws CoreException {
        String url = null;
        FileEditorInput fei = (FileEditorInput)input;
        IFile file = fei.getFile();
        IProject project = file.getProject();
        url = file.getPersistentProperty(new QualifiedName("", "CSS_PREVIEW_PATH"));
        if (url == null) {
            url = project.getPersistentProperty(new QualifiedName("", "CSS_PREVIEW_PATH"));
        }
        return url;
    }

    private void updatePreview() {
        String url = null;
        IEditorInput input = this.editor.getEditorInput();
        try {
            if (input instanceof FileEditorInput) {
                url = this.getExternalPreviewUrl(input);
            }
            if (url != null && !"".equals(url)) {
                this.setBrowserURL(url);
            } else {
                boolean useTemplate = CSSPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_USE_TEMPLATE_PREFERENCE");
                if (!useTemplate) {
                    url = CSSPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_URL_PREFERENCE");
                    this.setBrowserURL(url);
                } else {
                    IDocumentProvider docProvider = this.editor.getDocumentProvider();
                    String css = docProvider.getDocument((Object)input).get();
                    IPreferenceStore store = CSSPlugin.getDefault().getPreferenceStore();
                    String template = store.getString("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_TEMPLATE_PREFERENCE");
                    css = "<html>" + template + "<style>" + css + "</style></html>";
                    String charset = null;
                    if (input instanceof IFileEditorInput) {
                        charset = ((IFileEditorInput)input).getFile().getCharset();
                    } else if (docProvider instanceof TextFileDocumentProvider && (charset = ((TextFileDocumentProvider)docProvider).getEncoding((Object)input)) == null) {
                        charset = ((TextFileDocumentProvider)docProvider).getDefaultEncoding();
                    }
                    File tmpFile = this.writeTemporaryPreviewFile(this.editor, input, css, charset);
                    String tmpUrl = CoreUIUtils.getURI((File)tmpFile, (boolean)false);
                    if (this.prevTempFile != null && this.prevTempFile.equals(tmpFile)) {
                        this.setBrowserURL(tmpUrl);
                    } else {
                        if (this.prevTempFile != null) {
                            this.prevTempFile.delete();
                        }
                        this.prevTempFile = tmpFile;
                        this.setBrowserURL(tmpUrl);
                    }
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Unable to update preview", (Throwable)e);
        }
    }

    private File writeTemporaryPreviewFile(CSSEditor editor, IEditorInput input, String html, String charset) throws CoreException, FileNotFoundException, UnsupportedEncodingException {
        File tmpFile = editor.getTempFile();
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        FileOutputStream out = new FileOutputStream(tmpFile);
        PrintWriter pw = null;
        pw = charset != null ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, charset), true) : new PrintWriter((Writer)new OutputStreamWriter(out), true);
        pw.write(html);
        pw.close();
        try {
            out.close();
        }
        catch (IOException iOException) {}
        tmpFile.deleteOnExit();
        FileUtils.setHidden((File)tmpFile);
        return tmpFile;
    }

    public Object getAdapter(Class adapter) {
        if (this.editor != null) {
            return this.editor.getAdapter(adapter);
        }
        return null;
    }

    private void setBrowserURL(String url) {
        String index = Integer.toString(this.getActivePage());
        if (this.previews.containsKey(index)) {
            ((PreviewConfigurationPage)this.previews.get(index)).setURL(url);
        }
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    private void loadBrowsers() {
        this.previews.clear();
        List<IConfigurationElement> browserList = BrowserExtensionLoader.loadBrowsers();
        int j = 0;
        while (j < browserList.size()) {
            IConfigurationElement element = browserList.get(j);
            String name = BrowserExtensionLoader.getBrowserLabel(element);
            String outlineClass = element.getAttribute("outline");
            try {
                Object obj = element.createExecutableExtension("class");
                if (obj instanceof ContributedBrowser) {
                    Object ol;
                    ContributedBrowser browser = (ContributedBrowser)obj;
                    PreviewConfigurationPage page = new PreviewConfigurationPage(this);
                    page.createControl(this.getContainer());
                    page.setBrowser(browser, name);
                    page.setTitle(StringUtils.format((String)"{0} Preview", (String)name));
                    page.showBrowserArea();
                    int index = this.addPage(page.getControl());
                    this.previews.put(Integer.toString(index), page);
                    page.setIndex(index);
                    this.setPageText(index, " " + page.getTitle() + " ");
                    browser.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            ((CTabFolder)MultiPageCSSEditor.this.getContainer()).traverse(16);
                        }
                    });
                    if (outlineClass != null && (ol = element.createExecutableExtension("outline")) instanceof ContributedOutline) {
                        ContributedOutline outline = (ContributedOutline)ol;
                        browser.setOutline(outline);
                        outline.setBrowser(browser);
                        this.editor.getOutlinePage().addOutline(outline, name);
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)StringUtils.format((String)"Unabled to create browser control:{0}", (String)name), (Throwable)e);
            }
            catch (Error e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)StringUtils.format((String)"Unabled to create browser control:{0}", (String)name), (Throwable)e);
            }
            ++j;
        }
    }

    public void savePreviewsPages() {
    }

    private void disposePreviews() {
        Object[] _previews = this.previews.values().toArray();
        int i = 0;
        while (i < _previews.length) {
            ((PreviewConfigurationPage)_previews[i]).dispose();
            ++i;
        }
    }

    public void addFileServiceChangeListener(IFileServiceChangeListener listener) {
        if (this.editor != null) {
            this.editor.addFileServiceChangeListener(listener);
        }
    }

    public void close(boolean save) {
        if (this.editor != null) {
            this.editor.close(save);
        }
    }

    public IUnifiedEditorContributor getBaseContributor() {
        if (this.editor != null) {
            return this.editor.getBaseContributor();
        }
        return null;
    }

    public SourceViewerConfiguration getConfiguration() {
        if (this.editor != null) {
            return this.editor.getConfiguration();
        }
        return null;
    }

    public IContextAwareness getContextAwareness() {
        if (this.editor != null) {
            return this.editor.getContextAwareness();
        }
        return null;
    }

    public String getDefaultFileExtension() {
        if (this.editor != null) {
            return this.editor.getDefaultFileExtension();
        }
        return null;
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.editor != null) {
            return this.editor.getDocumentProvider();
        }
        return null;
    }

    public IEditorPart getEditor() {
        if (this.editor != null) {
            return this.editor.getEditor();
        }
        return null;
    }

    public EditorFileContext getFileContext() {
        if (this.editor != null) {
            return this.editor.getFileContext();
        }
        return null;
    }

    public UnifiedOutlinePage getOutlinePage() {
        if (this.editor != null) {
            return this.editor.getOutlinePage();
        }
        return null;
    }

    public UnifiedQuickOutlinePage createQuickOutlinePage() {
        return this.editor.createQuickOutlinePage();
    }

    public PairMatch getPairMatch(int offset) {
        if (this.editor != null) {
            return this.editor.getPairMatch(offset);
        }
        return null;
    }

    public String getParentDirectoryHint() {
        if (this.editor != null) {
            return this.editor.getParentDirectoryHint();
        }
        return null;
    }

    public ISourceViewer getViewer() {
        if (this.editor != null) {
            return this.editor.getViewer();
        }
        return null;
    }

    public void removeFileServiceChangeListener(IFileServiceChangeListener listener) {
        if (this.editor != null) {
            this.editor.removeFileServiceChangeListener(listener);
        }
    }

    public void selectAndReveal(int offset, int length) {
        if (this.editor != null) {
            this.editor.selectAndReveal(offset, length);
        }
    }

    public void setParentDirectoryHint(String hint) {
        if (this.editor != null) {
            this.editor.setParentDirectoryHint(hint);
        }
    }

    public void showWhitespace(boolean state) {
        if (this.editor != null) {
            this.editor.showWhitespace(state);
        }
    }

    public void addSaveAsListener(ISaveAsEvent listener) {
        if (this.editor != null) {
            this.editor.addSaveAsListener(listener);
        }
    }

    public void addSaveListener(ISaveEvent listener) {
        if (this.editor != null) {
            this.editor.addSaveListener(listener);
        }
    }

    public void removeSaveAsListener(ISaveAsEvent listener) {
        if (this.editor != null) {
            this.editor.removeSaveAsListener(listener);
        }
    }

    public void removeSaveListener(ISaveEvent listener) {
        if (this.editor != null) {
            this.editor.removeSaveListener(listener);
        }
    }

    public void doRevertToSaved() {
        if (this.editor != null) {
            this.editor.doRevertToSaved();
        }
    }

    public IAction getAction(String actionId) {
        if (this.editor != null) {
            return this.editor.getAction(actionId);
        }
        return null;
    }

    public IRegion getHighlightRange() {
        if (this.editor != null) {
            return this.editor.getHighlightRange();
        }
        return null;
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.editor != null) {
            return this.editor.getSelectionProvider();
        }
        return null;
    }

    public boolean isEditable() {
        if (this.editor != null) {
            return this.editor.isEditable();
        }
        return false;
    }

    public void removeActionActivationCode(String actionId) {
        if (this.editor != null) {
            this.editor.removeActionActivationCode(actionId);
        }
    }

    public void resetHighlightRange() {
        if (this.editor != null) {
            this.editor.resetHighlightRange();
        }
    }

    public void setAction(String actionID, IAction action) {
        if (this.editor != null) {
            this.editor.setAction(actionID, action);
        }
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        if (this.editor != null) {
            this.editor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
        }
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        if (this.editor != null) {
            this.editor.setHighlightRange(offset, length, moveCursor);
        }
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        if (this.editor != null) {
            this.editor.showHighlightRangeOnly(showHighlightRangeOnly);
        }
    }

    public boolean showsHighlightRangeOnly() {
        if (this.editor != null) {
            return this.editor.showsHighlightRangeOnly();
        }
        return false;
    }

    public void showPianoKeys(boolean state) {
        if (this.editor != null) {
            this.editor.showPianoKeys(state);
        }
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
    }

    public boolean isEditorInputReadOnly() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.isEditorInputReadOnly();
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.editor == null) {
            return;
        }
        this.editor.setStatusField(field, category);
    }

    private static class SourceEditorSite
    extends MultiPageEditorSite {
        private CSSEditor _editor = null;
        private IEditorSite _site;
        private ArrayList _menuExtenders;
        private boolean isDisposing = false;

        public SourceEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor, IEditorSite site) {
            super(multiPageEditor, editor);
            this._site = site;
            this._editor = (CSSEditor)editor;
        }

        public String getId() {
            return this._site.getId();
        }

        public IEditorActionBarContributor getActionBarContributor() {
            return this._site.getActionBarContributor();
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            if (this._editor != null) {
                if (this._menuExtenders == null) {
                    this._menuExtenders = new ArrayList(1);
                }
                this._menuExtenders.add(new PopupMenuExtender(menuId, menuManager, selectionProvider, (IWorkbenchPart)this._editor));
            }
        }

        public void dispose() {
            if (this.isDisposing) {
                return;
            }
            this.isDisposing = true;
            super.dispose();
            if (this._menuExtenders != null) {
                int i = 0;
                while (i < this._menuExtenders.size()) {
                    ((PopupMenuExtender)this._menuExtenders.get(i)).dispose();
                    ++i;
                }
                this._menuExtenders = null;
            }
            this._editor = null;
            if (this._site != null && this._site instanceof EditorSite) {
                ((EditorSite)this._site).dispose();
            }
            this._site = null;
        }

        public IKeyBindingService getKeyBindingService() {
            return this._site.getKeyBindingService();
        }

        public String getPluginId() {
            return this._site.getPluginId();
        }

        public String getRegisteredName() {
            return this._site.getRegisteredName();
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
            this._site.registerContextMenu(menuManager, selProvider);
        }
    }
}

