/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.css.CSSLanguageEnvironment;
import com.aptana.ide.editor.css.CSSOffsetMapper;
import com.aptana.ide.editor.css.Messages;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.help.HelpResource;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import java.util.ArrayList;
import java.util.Iterator;

public class CSSFileLanguageService
extends BaseFileLanguageService {
    private CSSOffsetMapper offsetMapper;
    private IMetadataEnvironment environment;
    private boolean isProfileMember;

    public CSSFileLanguageService(FileService fileService, IParseState parseState, IParser parser, IParentOffsetMapper mapper) {
        super(fileService, parseState, parser, mapper);
        this.createOffsetMapper(mapper);
        this.environment = (IMetadataEnvironment)CSSLanguageEnvironment.getInstance().getRuntimeEnvironment();
    }

    public String getDocumentationTitleFromLexeme(Lexeme lexeme) {
        String title = "CSS Editor";
        if (lexeme == null) {
            return title;
        }
        String titleLower = lexeme.getText().toLowerCase();
        if (lexeme.typeIndex == 47) {
            title = "'" + titleLower + "' property";
        } else if (lexeme.typeIndex == 4 || lexeme.typeIndex == 48) {
            title = "'" + titleLower + "' selector";
        }
        return title;
    }

    public HelpResource[] getDocumentationResourcesFromLexeme(Lexeme lexeme) {
        if (lexeme == null) {
            return new HelpResource[0];
        }
        ArrayList topics = new ArrayList();
        ArrayList<HelpResource> generalTopics = new ArrayList<HelpResource>();
        String lowerName = lexeme.getText().toLowerCase();
        if (lexeme.typeIndex == 47) {
            this.addPropertyHelpTopics(topics, generalTopics, lowerName);
        } else if (lexeme.typeIndex == 4 || lexeme.typeIndex == 48) {
            this.addSelectorHelpTopics(topics, generalTopics, lowerName);
        }
        if (generalTopics.size() == 0) {
            HelpResource index = new HelpResource("CSS Reference", "/com.aptana.ide.documentation/html/reference/api/CSS.index.html");
            generalTopics.add(index);
        }
        Iterator iter = generalTopics.iterator();
        while (iter.hasNext()) {
            topics.add(iter.next());
        }
        return topics.toArray(new HelpResource[0]);
    }

    private void addPropertyHelpTopics(ArrayList topics, ArrayList generalTopics, String lowerName) {
        FieldMetadata el = (FieldMetadata)this.environment.getGlobalFields().get(lowerName);
        String anchor = "";
        if (el != null) {
            anchor = el.getName();
            String url = "/com.aptana.ide.documentation/html/reference/api/CSS.field." + el.getName() + ".html";
            HelpResource hr = new HelpResource("'" + el.getName() + "' Property", url);
            topics.add(hr);
            HelpResource index = new HelpResource("CSS Property Reference", "/com.aptana.ide.documentation/html/reference/api/CSS.index-fields.html#" + anchor);
            generalTopics.add(index);
        }
    }

    private void addSelectorHelpTopics(ArrayList topics, ArrayList generalTopics, String lowerName) {
        ElementMetadata el = this.environment.getElement(lowerName);
        String anchor = "";
        if (el != null) {
            anchor = el.getFullName();
            String url = "/com.aptana.ide.documentation/html/reference/api/CSS.element." + el.getFullName() + ".html";
            HelpResource hr = new HelpResource("'" + lowerName + "' Selector", url);
            topics.add(hr);
        }
        HelpResource index = new HelpResource("CSS Selector Reference", "/com.aptana.ide.documentation/html/reference/api/CSS.index-elements.html#" + anchor);
        generalTopics.add(index);
    }

    public String getDocumentationFromLexeme(Lexeme lexeme) {
        if (lexeme == null) {
            return "";
        }
        String docs = "";
        if (lexeme.typeIndex == 4 || lexeme.typeIndex == 48 || lexeme.typeIndex == 47) {
            ElementMetadata em;
            String lowerName = lexeme.getText().toLowerCase();
            FieldMetadata el = (FieldMetadata)this.environment.getGlobalFields().get(lowerName);
            docs = el != null ? String.valueOf(docs) + StringUtils.format((String)Messages.CSSFileLanguageService_FieldDescription, (Object[])new String[]{el.getName(), el.getDescription()}) : ((em = this.environment.getElement(lowerName)) != null ? String.valueOf(docs) + StringUtils.format((String)Messages.CSSFileLanguageService_FieldDescription, (Object[])new String[]{em.getName(), em.getDescription()}) : String.valueOf(docs) + StringUtils.format((String)Messages.CSSFileLanguageService_FieldDescription, (Object[])new String[]{lexeme.getType(), ""}) + Messages.CSSFileLanguageService_NoInformationAvailable);
        } else {
            docs = lexeme.typeIndex == 5 ? String.valueOf(docs) + StringUtils.format((String)Messages.CSSFileLanguageService_StringLiteralDescription, (String)lexeme.getText()) : "";
        }
        return docs;
    }

    public String getDefaultLanguage() {
        return "text/css";
    }

    public IOffsetMapper getOffsetMapper() {
        return this.offsetMapper;
    }

    public void createOffsetMapper(IParentOffsetMapper parent) {
        this.offsetMapper = new CSSOffsetMapper(parent);
    }

    public static CSSFileLanguageService getCSSFileLanguageService(IFileService context) {
        CSSFileLanguageService languageService = (CSSFileLanguageService)context.getLanguageService("text/css");
        if (languageService == null) {
            throw new IllegalStateException(Messages.CSSFileLanguageService_NoLanguageServiceAvailable);
        }
        return languageService;
    }

    public boolean isProfileMember() {
        return this.isProfileMember;
    }

    public void setProfileMember(boolean isProfileMember) {
        this.isProfileMember = isProfileMember;
    }

    public void reset(boolean resetFileIndex) {
    }
}

