/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.server;

import com.aptana.ide.server.jetty.server.HTMLContextRootUtils;
import com.aptana.jaxer.connectors.servlet.interfaces.IDocumentRootResolver;
import java.net.URL;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class ProjectDocumentResolver
implements IDocumentRootResolver {
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public String getDocumentRoot(ServletRequest request, ServletResponse res) {
        String path = null;
        try {
            if (request instanceof HttpServletRequest) {
                path = ((HttpServletRequest)request).getServletPath();
                String ref = ((HttpServletRequest)request).getHeader("Referer");
                IProject project = null;
                if (ref != null) {
                    URL url = new URL(ref);
                    String refPath = url.getPath();
                    IResource resource = this.workspaceRoot.findMember((IPath)new Path(refPath));
                    if (resource != null) {
                        project = resource.getProject();
                    } else {
                        resource = this.workspaceRoot.findMember((IPath)new Path(path));
                        if (resource != null && resource instanceof IFile) {
                            project = resource.getProject();
                        }
                    }
                } else {
                    IResource resource = this.workspaceRoot.findMember((IPath)new Path(path));
                    if (resource != null && resource instanceof IFile) {
                        project = resource.getProject();
                    }
                }
                if (project != null) {
                    String override = project.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE"));
                    if ("true".equals(override)) {
                        String contextRoot = project.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.CONTEXT_ROOT"));
                        IResource root = project.findMember((IPath)new Path(contextRoot));
                        path = root.getLocation().makeAbsolute().toString();
                    } else {
                        path = project.getLocation().makeAbsolute().toString();
                    }
                }
            }
        }
        catch (Exception exception) {
            path = null;
        }
        return path;
    }

    public String getPageFile(ServletRequest request, ServletResponse response) {
        String path = null;
        try {
            if (request instanceof HttpServletRequest) {
                path = ((HttpServletRequest)request).getServletPath();
                String ref = ((HttpServletRequest)request).getHeader("Referer");
                if (ref != null) {
                    URL url = new URL(ref);
                    String refPath = url.getPath();
                    IResource resource = this.workspaceRoot.findMember((IPath)new Path(refPath));
                    if (resource != null) {
                        IProject project = resource.getProject();
                        path = HTMLContextRootUtils.resolveURL(project, path);
                        IResource candidate = this.workspaceRoot.findMember((IPath)new Path(path));
                        if (candidate != null && candidate.getProject().equals((Object)project) && candidate instanceof IFile) {
                            path = candidate.getLocation().makeAbsolute().toString();
                        } else {
                            candidate = project.findMember((IPath)new Path(path));
                            if (candidate != null && candidate.getProject().equals((Object)project) && candidate instanceof IFile) {
                                path = candidate.getLocation().makeAbsolute().toString();
                            }
                        }
                    }
                } else {
                    IResource resource = this.workspaceRoot.findMember((IPath)new Path(path));
                    if (resource != null && resource instanceof IFile) {
                        path = resource.getLocation().makeAbsolute().toString();
                    }
                }
            }
        }
        catch (Exception exception) {
            path = null;
        }
        return path;
    }
}

