/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.server;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.server.http.HttpContentTypes;
import com.aptana.ide.server.jetty.server.HTMLContextRootUtils;
import com.aptana.jaxer.connectors.servlet.interfaces.ICallbackResponse;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsProvider;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatusLengthOnlyResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class HTMLPreviewHandler
extends HttpServlet
implements IStatisticsProvider {
    private static final long serialVersionUID = 1L;
    private IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    private IStatisticsHandler handler;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            IResource resource;
            if (response instanceof ICallbackResponse) {
                response.setContentLength(0);
                response.getWriter().write("");
                return;
            }
            boolean sendContent = !(response instanceof IStatusLengthOnlyResponse);
            String path = request.getServletPath();
            String ref = request.getHeader("Referer");
            if (ref != null) {
                try {
                    URL url = new URL(ref);
                    String refPath = url.getPath();
                    IResource resource2 = this.root.findMember((IPath)new Path(refPath));
                    if (resource2 != null) {
                        IProject project = resource2.getProject();
                        path = HTMLContextRootUtils.resolveURL(project, path);
                        IResource candidate = this.root.findMember((IPath)new Path(path));
                        if (candidate != null && candidate.getProject().equals((Object)project) && candidate instanceof IFile) {
                            FileInputStream stream = new FileInputStream(candidate.getLocation().toFile());
                            HTMLPreviewHandler.setContentLength(candidate.getLocation().toFile(), response);
                            HTMLPreviewHandler.setContentType(path, response);
                            if (sendContent) {
                                FileUtils.pipe((InputStream)stream, (OutputStream)response.getOutputStream(), (boolean)false);
                            }
                            if (this.handler != null && !(response instanceof IStatusLengthOnlyResponse)) {
                                this.handler.parseStatistics((ServletRequest)request, (ServletResponse)response);
                            }
                            stream.close();
                        } else {
                            candidate = project.findMember((IPath)new Path(path));
                            if (candidate != null && candidate.getProject().equals((Object)project) && candidate instanceof IFile) {
                                FileInputStream stream = new FileInputStream(candidate.getLocation().toFile());
                                HTMLPreviewHandler.setContentLength(candidate.getLocation().toFile(), response);
                                HTMLPreviewHandler.setContentType(path, response);
                                if (sendContent) {
                                    FileUtils.pipe((InputStream)stream, (OutputStream)response.getOutputStream(), (boolean)false);
                                }
                                if (this.handler != null && !(response instanceof IStatusLengthOnlyResponse)) {
                                    this.handler.parseStatistics((ServletRequest)request, (ServletResponse)response);
                                }
                                stream.close();
                            } else {
                                response.setStatus(404);
                                if (sendContent) {
                                    this.streamErrorPage(response, path);
                                }
                            }
                        }
                        return;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if ((resource = this.root.findMember((IPath)new Path(path))) != null && resource instanceof IFile) {
                FileInputStream stream = new FileInputStream(resource.getLocation().toFile());
                HTMLPreviewHandler.setContentLength(resource.getLocation().toFile(), response);
                HTMLPreviewHandler.setContentType(path, response);
                if (sendContent) {
                    FileUtils.pipe((InputStream)stream, (OutputStream)response.getOutputStream(), (boolean)false);
                }
                stream.close();
                if (this.handler != null && !(response instanceof IStatusLengthOnlyResponse)) {
                    this.handler.parseStatistics((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                response.setStatus(404);
                if (sendContent) {
                    this.streamErrorPage(response, path);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    private void streamErrorPage(HttpServletResponse response, String path) throws IOException {
        response.getWriter().println("<h1>Page not found: " + path + "</h1>");
    }

    public static void setContentLength(File file, HttpServletResponse response) {
        if (file != null) {
            response.setContentLength((int)file.length());
        }
    }

    public static void setContentType(String path, HttpServletResponse response) {
        String type;
        String ext = FileUtils.getExtension((String)path);
        if (ext != null && (type = HttpContentTypes.getContentType((String)("." + ext))) != null) {
            response.setContentType(type);
        }
    }

    public IStatisticsHandler getStatisticsHandler() {
        return this.handler;
    }

    public void setStatisticsHandler(IStatisticsHandler handler) {
        this.handler = handler;
    }
}

