/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.portal;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.URLEncoder;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.ResourceBaseServlet;
import com.aptana.ide.server.jetty.comet.ClientLoader;
import com.aptana.ide.server.jetty.comet.ICometClient;
import com.aptana.ide.server.jetty.portal.ClientLister;
import com.aptana.ide.server.jetty.portal.CommandFilter;
import com.aptana.ide.server.jetty.portal.PortalProxyServlet;
import com.aptana.ide.server.jetty.portal.PortalService;
import com.aptana.ide.server.jetty.portal.PortalServiceLoader;
import com.aptana.ide.server.jetty.portal.PortletServlet;
import dojox.cometd.Bayeux;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;

public class PortalServer {
    public static final int HTTP_START_PORT = 8500;
    public static final int HTTP_END_PORT = 8599;
    public static final int COMET_START_PORT = 8600;
    public static final int COMET_END_PORT = 8699;
    public static final String IMAGES_PATH = "/images_global";
    public static final String IMAGES_PRELOAD_MARKER = "<!-- IMAGES_PRELOAD -->";
    public static final String CAPTCHA_SRC_MARKER = "<!-- CAPTCHA_SOURCE -->";
    public static final String INDEX_PATH = "/index.html";
    public static final String INDEX_TEMPLATE_PATH = "/index_template.html";
    private static final String LOCAL_HOST = "127.0.0.1";
    private static PortalServer server;
    private Server jettyServer;
    private URL startURL;
    private URL baseURL;
    private String inputID;
    private AbstractBayeux bayeux;
    private ClientLoader loader;
    private ClientLister lister;
    private int lastHTTPPort = 8499;
    private int lastCometPort = 8599;

    private PortalServer() {
    }

    private void addImages(StringBuffer imagePreload, String root, File initialDir) {
        File[] children = initialDir.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File child = fileArray[n];
                String path = child.toString();
                if (child.isDirectory()) {
                    this.addImages(imagePreload, root, child);
                } else {
                    path = path.substring(root.length());
                    imagePreload.append("<img src=\"" + path + "\" />");
                    imagePreload.append("\n");
                }
                ++n;
            }
        }
    }

    private void loadImages() {
        URL siteManagerURL = null;
        try {
            siteManagerURL = new URL(AptanaUser.BASE_URL);
        }
        catch (MalformedURLException e1) {
            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)StringUtils.format((String)"Could not create URL for {0}", (String)AptanaUser.BASE_URL), (Throwable)e1);
        }
        String captchaSource = "<script type=\"text/javascript\" src=\"" + siteManagerURL + "/captcha/javascript\"></script>";
        PortalService portlet = PortalServiceLoader.getLoader().getPortlet("");
        String root = portlet.getFolder();
        try {
            StringBuffer imagePreload = new StringBuffer();
            this.addImages(imagePreload, root, new File(root, IMAGES_PATH));
            File indexTemplateFile = new File(root, INDEX_TEMPLATE_PATH);
            String initialIndex = FileUtils.readContent((File)indexTemplateFile);
            File indexFile = new File(root, INDEX_PATH);
            indexFile.createNewFile();
            String newIndexPageText = StringUtils.replace((String)initialIndex, (String)IMAGES_PRELOAD_MARKER, (String)imagePreload.toString());
            newIndexPageText = StringUtils.replace((String)newIndexPageText, (String)CAPTCHA_SRC_MARKER, (String)captchaSource.toString());
            FileUtils.writeStringToFile((String)newIndexPageText, (File)indexFile);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error loading portal images", (Throwable)e);
        }
    }

    private void start() {
        if (this.lastHTTPPort == 8598) {
            this.lastHTTPPort = 8499;
        }
        this.lastHTTPPort = ServerManager.findFreePort((int)(this.lastHTTPPort + 1), (int)8599);
        if (this.lastCometPort == 8698) {
            this.lastCometPort = 8599;
        }
        this.lastCometPort = ServerManager.findFreePort((int)(this.lastCometPort + 1), (int)8699);
        this.jettyServer = new Server(this.lastHTTPPort);
        this.jettyServer.getConnectors()[0].setHost(LOCAL_HOST);
        SocketConnector connector = new SocketConnector();
        connector.setPort(this.lastCometPort);
        connector.setHost(LOCAL_HOST);
        this.jettyServer.addConnector((Connector)connector);
        Context httpContext = new Context((HandlerContainer)this.jettyServer, "/", 1);
        URL siteManagerURL = null;
        try {
            siteManagerURL = new URL(AptanaUser.BASE_URL);
        }
        catch (MalformedURLException e1) {
            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)StringUtils.format((String)"Could not create URL for {0}", (String)AptanaUser.BASE_URL), (Throwable)e1);
        }
        try {
            this.baseURL = new URL("http://127.0.0.1:" + this.lastHTTPPort);
            String tempURL = "http://127.0.0.1:" + this.lastHTTPPort + INDEX_PATH + "?port=" + this.lastCometPort;
            if (siteManagerURL != null) {
                tempURL = String.valueOf(tempURL) + "&sm=" + URLEncoder.encode((URL)siteManagerURL);
            }
            PortalServiceLoader.getLoader().switchPortalLocations();
            this.loadImages();
            tempURL = String.valueOf(tempURL) + "&pv=" + PortalServiceLoader.getLoader().getLatestPortalVersion();
            this.startURL = new URL(tempURL);
            PortalService[] portalServiceArray = PortalServiceLoader.getLoader().getPortlets();
            int n = 0;
            int n2 = portalServiceArray.length;
            while (n < n2) {
                PortalService p = portalServiceArray[n];
                String id = p.getId();
                if (!id.equals("aptana")) {
                    if (id.equals("")) {
                        ResourceBaseServlet servlet = new ResourceBaseServlet(p.getFolder());
                        servlet.setNoCache(true);
                        httpContext.addServlet(new ServletHolder((Servlet)servlet), "/");
                    } else {
                        httpContext.addServlet(new ServletHolder((Servlet)new PortletServlet(p)), "/portlets/" + id + "/*");
                    }
                }
                ++n;
            }
            httpContext.addServlet(new ServletHolder((Servlet)new PortalProxyServlet()), "/proxy");
            httpContext.addFilter(new FilterHolder((Filter)new CommandFilter()), "/command.gif", 1);
            ContinuationCometdServlet cometServlet = new ContinuationCometdServlet();
            ServletHolder cometHolder = new ServletHolder((Servlet)cometServlet);
            cometHolder.setInitParameter("timeout", "30000");
            cometHolder.setInitParameter("multi-timeout", "1500");
            cometHolder.setInitParameter("verbose", "true");
            cometHolder.setInitParameter("rpcSupport", "true");
            if (AptanaCorePlugin.getDefault().getPluginPreferences().getBoolean("com.aptana.ide.core.PREF_ENABLE_DEBUGGING")) {
                cometHolder.setInitParameter("logLevel", "1");
            } else {
                cometHolder.setInitParameter("logLevel", "0");
            }
            httpContext.addServlet(cometHolder, "/cometd");
            this.jettyServer.setStopAtShutdown(true);
            this.jettyServer.start();
            this.bayeux = cometServlet.getBayeux();
            if (this.loader != null) {
                this.loader.destroy();
            }
            this.loader = ClientLoader.loadClients((Bayeux)this.bayeux);
            this.lister = new ClientLister(this.loader);
            this.lister.init((Bayeux)this.bayeux);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error finding cloud root", (Throwable)e);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error starting cloud UI server", (Throwable)e);
        }
    }

    public AbstractBayeux getBayeux() {
        return this.bayeux;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public URL getStartURL() {
        if (AptanaUser.getSignedInUser().hasCredentials()) {
            String url = this.startURL.toExternalForm();
            try {
                return new URL(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.startURL;
    }

    public static PortalServer getServer() {
        if (server == null) {
            server = new PortalServer();
            server.start();
        }
        return server;
    }

    public String getInputID() {
        return this.inputID;
    }

    public void setInputID(String inputID) {
        this.inputID = inputID;
    }

    public void restart() {
        PortalServiceLoader.getLoader().copyPortalContents();
        Job job = new Job("Downloading portal contents"){

            protected IStatus run(IProgressMonitor monitor) {
                PortalServiceLoader.getLoader().downloadPortalContents();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        try {
            this.jettyServer.stop();
            this.jettyServer.setStopAtShutdown(false);
            if (this.loader != null) {
                ICometClient[] iCometClientArray = this.loader.getClients();
                int n = 0;
                int n2 = iCometClientArray.length;
                while (n < n2) {
                    ICometClient client = iCometClientArray[n];
                    client.destroy();
                    ++n;
                }
            }
            if (this.lister != null) {
                this.lister.destroy();
            }
            if (this.bayeux instanceof ContinuationBayeux) {
                ((ContinuationBayeux)this.bayeux).destroy();
            }
            this.jettyServer.destroy();
            this.start();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error restarting portal server", (Throwable)e);
        }
    }
}

