/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.portal;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.model.user.UserRequestBuilder;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.server.jetty.JettyPlugin;
import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Plugin;

public class CommandFilter
implements Filter {
    private static String PARAMETER_COMMAND = "command";
    private static String VALUE_TRACK_EVENT = "trackevent";
    private static String PARAMETER_CODE = "code";
    private static String PARAMETER_DATA = "data";
    private static String VALUE_SIGNIN = "signin";
    private static String PARAMETER_USERNAME = "username";
    private static String PARAMETER_PASSWORD = "password";
    private static String VALUE_SIGNOUT = "signout";
    private static String VALUE_OPENURL = "openurl";
    private static String PARAMETER_URL = "url";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        HttpServletResponse resp = (HttpServletResponse)response;
        String command = request.getParameter(PARAMETER_COMMAND);
        if (command != null) {
            if (VALUE_SIGNIN.equals(command)) {
                String username = request.getParameter(PARAMETER_USERNAME);
                String password = request.getParameter(PARAMETER_PASSWORD);
                if (username != null && password != null) {
                    boolean shouldSignIn = true;
                    User user = AptanaUser.getSignedInUser();
                    if (user != null && user.hasCredentials()) {
                        if (username.equals(user.getUsername()) && password.equals(user.getPassword())) {
                            shouldSignIn = false;
                        } else {
                            AptanaUser.signOut();
                        }
                    }
                    if (shouldSignIn) {
                        user = new User(username, password, null, null, null, null, null);
                        user.setDefaultLocation(new URL(AptanaUser.LOGINS));
                        user.setServiceProvider((IServiceProvider)new RESTServiceProvider());
                        user.setRequestBuilder((IServiceRequestBuilder)new UserRequestBuilder());
                        user.update();
                        if (user.hasLocation()) {
                            user.update();
                            AptanaUser.signIn((String)user.getUsername(), (String)user.getPassword(), (URL)user.getLocation(), (String)user.getId());
                        }
                    }
                } else {
                    IdeLog.logImportant((Plugin)JettyPlugin.getDefault(), (String)(String.valueOf(VALUE_SIGNIN) + " command did not required parameters " + PARAMETER_USERNAME + " and " + PARAMETER_PASSWORD));
                }
            } else if (VALUE_SIGNOUT.equals(command)) {
                User user = AptanaUser.getSignedInUser();
                if (user != null && user.hasCredentials()) {
                    AptanaUser.signOut();
                }
            } else if (VALUE_OPENURL.equals(command)) {
                String url = request.getParameter(PARAMETER_URL);
                if (url != null) {
                    CoreUIUtils.openBrowserURL((String)url);
                }
            } else if (VALUE_TRACK_EVENT.equals(command)) {
                String eventCode = request.getParameter(PARAMETER_CODE);
                String eventData = request.getParameter(PARAMETER_DATA);
                if (eventCode != null && eventCode.length() > 0) {
                    EventLogger.getInstance().logEvent(eventCode, eventData);
                } else {
                    IdeLog.logImportant((Plugin)JettyPlugin.getDefault(), (String)"Got null or empty event code from event tracking filter.");
                }
            }
        }
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

