/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.Messages;
import com.aptana.ide.server.jetty.comet.CometClient;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.progress.UIJob;

public class ShowPerspectiveClient
extends CometClient {
    public static final String PROPERTY_KEY = "CloudSiteId";
    private static final String SHOW_PERSPECTIVE = "/portal/perspectives/show";
    private static final String ID = "id";
    private static final String VIEW_ID = "viewId";
    private static final String EXTRA = "extra";
    private static final String SITE_ID = "siteId";

    protected String getID(String msgId) {
        return null;
    }

    protected Object getResponse(String toChannel, Object request) {
        Map requestData;
        if (SHOW_PERSPECTIVE.equals(toChannel) && request instanceof Map && (requestData = (Map)request).containsKey(ID)) {
            Map extraData;
            final String id = requestData.get(ID).toString();
            String view = null;
            if (requestData.containsKey(VIEW_ID)) {
                view = requestData.get(VIEW_ID).toString();
            }
            final String viewId = view;
            String site = null;
            Object extras = requestData.get(EXTRA);
            if (extras instanceof Map && (extraData = (Map)extras).containsKey(SITE_ID)) {
                site = extraData.get(SITE_ID).toString();
            }
            ResourcesPlugin.getPlugin().getPluginPreferences().setValue(PROPERTY_KEY, site);
            UIJob job = new UIJob("Opening perspective"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (ShowPerspectiveClient.this.shouldSwitchPerspective(id)) {
                        try {
                            JettyPlugin.getDefault().getWorkbench().showPerspective(id, JettyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
                        }
                        catch (WorkbenchException workbenchException) {}
                    }
                    if (viewId != null) {
                        try {
                            CoreUIUtils.showView((String)viewId);
                        }
                        catch (PartInitException partInitException) {}
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    private boolean shouldSwitchPerspective(String id) {
        if (this.isCurrentPerspective(JettyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow(), id)) {
            return false;
        }
        if (this.shouldAutoOpen(id)) {
            return true;
        }
        return this.promptUser(id);
    }

    private boolean promptUser(String id) {
        Shell shell = JettyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, Messages.ShowPerspectiveClient_1, null, MessageFormat.format(Messages.ShowPerspectiveClient_2, this.getPerspectiveName(id)), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0, null, false){

            protected Control createCustomArea(Composite parent) {
                try {
                    URL url = JettyPlugin.getDefault().getBundle().getResource("/icons/animation.gif");
                    url = FileLocator.toFileURL((URL)url);
                    Browser animation = new Browser(parent, 0);
                    animation.setText("<html><body style='margin: 0; padding:0; border: 1px solid black' ><center><img src='" + url.toExternalForm() + "' />" + "</center>" + "</body>" + "</html>");
                    GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
                    gridData.widthHint = 313;
                    gridData.heightHint = 171;
                    animation.setLayoutData((Object)gridData);
                    return animation;
                }
                catch (IOException iOException) {
                    Label animation = new Label(parent, 0x1000000);
                    animation.setImage(JettyPlugin.getImage("/icons/animation.gif"));
                    GridData gridData = new GridData(4, 128, true, false);
                    animation.setLayoutData((Object)gridData);
                    return animation;
                }
            }
        };
        dialog.setPrefStore(JettyPlugin.getDefault().getPreferenceStore());
        dialog.setPrefKey(this.getPrefKey(id));
        dialog.open();
        return dialog.getReturnCode() == 2;
    }

    private String getPerspectiveName(String id) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "perspectives");
        if (extension == null) {
            return id;
        }
        IExtension[] extensions = extension.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configElement = configElements[j];
                if (id.equals(configElement.getAttribute(ID))) {
                    return configElement.getAttribute("name");
                }
                ++j;
            }
            ++i;
        }
        return id;
    }

    private boolean shouldAutoOpen(String id) {
        String value = JettyPlugin.getDefault().getPreferenceStore().getString(this.getPrefKey(id));
        if (value == null) {
            return false;
        }
        return value.equals("always");
    }

    private String getPrefKey(String id) {
        return String.valueOf(id) + ".auto_open";
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{SHOW_PERSPECTIVE};
    }

    protected boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }
}

