/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.servers.AbstractServer;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.jetty.JettyDocumentRootResolver;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.Messages;
import com.aptana.ide.server.jetty.ResourceBaseServlet;
import com.aptana.ide.server.jetty.builder.JettyServerBuilder;
import java.net.URI;
import javax.servlet.Servlet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IProcess;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyServer
extends AbstractServer {
    private static final IProcess[] NO_PROCESS = new IProcess[0];
    private int port;
    private String serverAddress;
    private Server server;
    private String boundName;
    private String documentRoot;
    private IPath log;

    protected void installConfig(IAbstractConfiguration configuration) {
        this.port = configuration.getIntAttribute("port");
        this.documentRoot = configuration.getStringAttribute("serverId");
        this.boundName = configuration.getStringAttribute("association_id");
        String id = configuration.getStringAttribute("id");
        this.log = new Path(FileUtils.systemTempDir).append("jetty_server_" + id + ".log");
        super.installConfig(configuration);
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setIntAttribute("port", this.port);
        config.setStringAttribute("serverId", this.documentRoot);
        config.setStringAttribute("association_id", this.boundName);
        super.storeConfiguration(config);
    }

    public JettyServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
    }

    protected IStatus restart(String mode, IProgressMonitor monitor) {
        try {
            this.stop(true, monitor);
            this.serverChanged();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                IdeLog.log((Plugin)JettyPlugin.getDefault(), (int)2, (String)"interrupted while sleeping", (Throwable)e);
            }
            this.start(mode, monitor);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.ide.server.jetty", 4, StringUtils.format((String)Messages.JettyServer_EXCEPTION, (String)this.getName()), (Throwable)e);
        }
    }

    protected IStatus start(String mode, IProgressMonitor monitor) {
        IContainer findMember = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(this.documentRoot));
        this.server = new Server(this.port);
        RequestLogHandler logger = new RequestLogHandler();
        NCSARequestLog log = new NCSARequestLog(this.log.toFile().getAbsolutePath());
        log.setLogCookies(true);
        log.setLogLatency(true);
        log.setRetainDays(90);
        log.setAppend(true);
        log.setExtended(true);
        log.setLogTimeZone("GMT");
        logger.setRequestLog((RequestLog)log);
        this.server.addHandler((Handler)logger);
        this.server.getConnectors()[0].setHost(HttpServer.getServerAddress());
        try {
            IServer server;
            Context context = new Context((HandlerContainer)this.server, "/", 1);
            ResourceBaseServlet servlet = new ResourceBaseServlet(findMember.getLocation().toFile().getAbsolutePath());
            servlet.setNoCache(true);
            context.addServlet(new ServletHolder((Servlet)servlet), "/");
            if (this.boundName.length() > 0 && (server = ServerManager.getInstance().findServer(this.boundName)) != null) {
                JettyServerBuilder.getInstance().buildServer(context, "com.aptana.ide.server.jetty.jettyHttpServer", this.boundName, server.getHostname(), server.getPort(), new JettyDocumentRootResolver(this.documentRoot));
            }
            this.server.setStopAtShutdown(true);
            this.server.start();
            this.setServerState(2);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.ide.server.jetty", 4, StringUtils.format((String)"Exception starting Jetty Server {0}", (String)this.getName()), (Throwable)e);
        }
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        try {
            this.server.stop();
            this.server.destroy();
            this.server = null;
            this.setServerState(4);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.ide.server.jetty", 4, StringUtils.format((String)Messages.JettyServer_EXCEPTION, (String)this.getName()), (Throwable)e);
        }
    }

    public IStatus canHaveModule(IModule module) {
        return new Status(4, "com.aptana.ide.server.jetty", 4, StringUtils.format((String)Messages.JettyServer_STATIC_SERVER, (String)this.getName()), null);
    }

    public String getConfigurationDescription() {
        return StringUtils.format((String)Messages.JettyServer_DESCRIPTION, (Object[])new Object[]{this.port, this.documentRoot});
    }

    public ILog getLog() {
        return new ILog(){

            public URI getURI() {
                return JettyServer.this.log.toFile().toURI();
            }

            public boolean exists() {
                return JettyServer.this.log.toFile().exists();
            }
        };
    }

    public IProcess[] getProcesses() {
        return NO_PROCESS;
    }

    public String getHost() {
        return String.valueOf(this.getHostname()) + ":" + this.port;
    }

    public boolean isWebServer() {
        return true;
    }

    public IServer[] getAssociatedServers() {
        IServer server;
        if (this.boundName.length() > 0 && (server = ServerCore.getServerManager().findServer(this.boundName)) != null) {
            return new IServer[]{server};
        }
        return new IServer[0];
    }

    public String getHostname() {
        return this.serverAddress == null ? "127.0.0.1" : this.serverAddress;
    }

    public int getPort() {
        return this.port;
    }

    public IPath getDocumentRoot() {
        return new Path(this.documentRoot);
    }

    public String fetchStatistics() {
        return null;
    }
}

