/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.debug.core.model.IJSVariable;
import com.aptana.ide.debug.internal.core.model.JSDebugElement;
import com.aptana.ide.debug.internal.core.model.JSDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;

public class JSDebugVariable
extends JSDebugElement
implements IJSVariable {
    protected static final int FLAGS_MODIFIABLE = 1;
    protected static final int FLAGS_LOCAL = 2;
    protected static final int FLAGS_ARGUMENT = 4;
    protected static final int FLAGS_EXCEPTION = 8;
    protected static final int FLAGS_CONST = 16;
    protected static final int FLAGS_TOPLEVEL = 128;
    private String qualifier;
    private String name;
    private IValue value;
    protected int flags;

    public JSDebugVariable(IDebugTarget target, String qualifier, String name, IValue value) {
        this(target, qualifier, name, value, 0);
    }

    public JSDebugVariable(IDebugTarget target, String qualifier, String name, int flags) {
        this(target, qualifier, name, null, flags);
    }

    public JSDebugVariable(IDebugTarget target, String qualifier, String name, IValue value, int flags) {
        super(target);
        this.qualifier = qualifier;
        this.name = name;
        this.value = value;
        this.flags = flags;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        Object result = ((JSDebugTarget)this.getDebugTarget()).evaluateExpression(expression, (IDebugElement)this);
        if (result instanceof IValue && (result = ((JSDebugTarget)this.getDebugTarget()).setValue(this, (IValue)result)) instanceof IValue) {
            this.value = (IValue)result;
            this.fireChangeEvent(512);
            return;
        }
        if (result instanceof String[]) {
            this.throwDebugException(((String[])result)[0]);
        } else {
            this.throwDebugException("");
        }
    }

    public void setValue(IValue value) throws DebugException {
        value = null;
        this.throwNotImplemented();
    }

    public boolean supportsValueModification() {
        return (this.flags & 1) != 0;
    }

    public boolean verifyValue(String expression) throws DebugException {
        Object result = ((JSDebugTarget)this.getDebugTarget()).evaluateExpression(expression, (IDebugElement)this);
        if (result instanceof IValue) {
            return true;
        }
        if (result == null) {
            this.throwDebugException("unknown behaviour");
        }
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        this.throwNotImplemented();
        return false;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    public boolean isLocal() throws DebugException {
        return (this.flags & 2) != 0;
    }

    public boolean isException() throws DebugException {
        return (this.flags & 8) != 0;
    }

    public boolean isArgument() throws DebugException {
        return (this.flags & 4) != 0;
    }

    public boolean isConst() throws DebugException {
        return (this.flags & 0x10) != 0;
    }

    public boolean isTopLevel() throws DebugException {
        return (this.flags & 0x80) != 0;
    }

    public String getFullName() {
        String fullname = this.getQualifier();
        int index = fullname.indexOf(46);
        if (index >= 0) {
            fullname = fullname.substring(index + 1);
        }
        return fullname;
    }
}

