/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.model.IJSLineBreakpoint;
import com.aptana.ide.debug.internal.core.Util;
import com.aptana.ide.debug.internal.core.model.JSDebugElement;
import com.aptana.ide.debug.internal.core.model.JSDebugImplicitBreakpoint;
import com.aptana.ide.debug.internal.core.model.JSDebugStackFrame;
import com.aptana.ide.debug.internal.core.model.JSDebugTarget;
import com.aptana.ide.debug.internal.core.model.Messages;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class JSDebugThread
extends JSDebugElement
implements IThread {
    private static final String SUSPENDED = "suspended";
    private static final String SUSPEND = "suspend";
    private static final String BREAKPOINT = "breakpoint";
    private static final String KEYWORD = "keyword";
    private static final String FIRST_LINE = "firstLine";
    private static final String EXCEPTION = "exception";
    private static final String WATCHPOINT = "watchpoint";
    private static final String RESUMED = "resumed";
    private static final String STEP_INTO = "stepInto";
    private static final String STEP_OVER = "stepOver";
    private static final String RESUME = "resume";
    private static final String ABORT = "abort";
    private static final String START = "start";
    private static final String STEP_RETURN = "stepReturn";
    private static final String STEP_TO_FRAME = "stepToFrame";
    private static final String STEP = "step";
    private static final String FRAMES = "frames";
    private static final String SUBARGS_SPLIT = "\\|";
    private static final String STEP_TO_FRAME_0 = "stepToFrame*{0}";
    private static final int STATE_STARTING = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_SUSPENDED = 2;
    private static final int STATE_SUSPENDING = 3;
    private static final int STATE_STEPPPING = 4;
    private final IStackFrame[] emptyStack = new IStackFrame[0];
    private IStackFrame[] stackFrames = this.emptyStack;
    private final IBreakpoint[] emptyBreakpoints = new IBreakpoint[0];
    private IBreakpoint[] breakpoints = this.emptyBreakpoints;
    private int runningState = 0;
    private boolean validateFrames = false;

    public JSDebugThread(IDebugTarget target) {
        super(target);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return this.emptyStack;
        }
        this.getStackFrames0();
        return this.isSuspended() && this.stackFrames != null ? this.stackFrames : this.emptyStack;
    }

    public boolean hasStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return false;
        }
        this.getStackFrames0();
        return this.stackFrames != null && this.stackFrames.length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (!this.isSuspended()) {
            return null;
        }
        this.getStackFrames0();
        return this.stackFrames != null && this.stackFrames.length > 0 ? this.stackFrames[0] : null;
    }

    public String getName() throws DebugException {
        return StringUtils.format((String)Messages.JSDebugThread_ThreadMain_0, (String)(this.runningState == 3 ? StringUtils.format((String)" ({0})", (String)Messages.JSDebugThread_Suspending) : ""));
    }

    public IBreakpoint[] getBreakpoints() {
        return this.isSuspended() && this.breakpoints != null ? this.breakpoints : this.emptyBreakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended() && this.runningState != 0;
    }

    public boolean isSuspended() {
        return this.runningState == 2;
    }

    public void resume() throws DebugException {
        if (this.runningState != 2) {
            return;
        }
        this.runningState = 4;
        this.fireChangeEvent(256);
        ((JSDebugTarget)this.getDebugTarget()).getConnection().sendCommand(RESUME);
    }

    public void suspend() throws DebugException {
        if (this.runningState != 1) {
            return;
        }
        this.runningState = 3;
        this.fireChangeEvent(256);
        ((JSDebugTarget)this.getDebugTarget()).getConnection().sendCommand(SUSPEND);
    }

    public boolean canStepInto() {
        return this.isSuspended() && !this.isStepping();
    }

    public boolean canStepOver() {
        return this.isSuspended() && !this.isStepping();
    }

    public boolean canStepReturn() {
        return this.isSuspended() && !this.isStepping();
    }

    public boolean isStepping() {
        return this.runningState == 4;
    }

    public void stepInto() throws DebugException {
        if (this.runningState != 2) {
            return;
        }
        this.runningState = 4;
        this.fireChangeEvent(256);
        ((JSDebugTarget)this.getDebugTarget()).getConnection().sendCommand(STEP_INTO);
    }

    public void stepOver() throws DebugException {
        if (this.runningState != 2) {
            return;
        }
        this.runningState = 4;
        this.fireChangeEvent(256);
        ((JSDebugTarget)this.getDebugTarget()).getConnection().sendCommand(STEP_OVER);
    }

    public void stepReturn() throws DebugException {
        if (this.runningState != 2) {
            return;
        }
        this.runningState = 4;
        this.fireChangeEvent(256);
        ((JSDebugTarget)this.getDebugTarget()).getConnection().sendCommand(STEP_RETURN);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void handleMessage(String[] args) {
        String action = args[0];
        int details = 0;
        if (SUSPENDED.equals(action)) {
            block26: {
                this.invalidateStackFrames();
                this.runningState = 2;
                this.breakpoints = null;
                String reason = args[1];
                if (BREAKPOINT.equals(reason) || KEYWORD.equals(reason) || FIRST_LINE.equals(reason) || EXCEPTION.equals(reason) || WATCHPOINT.equals(reason)) {
                    details = 16;
                    this.stackFrames = null;
                    String sourceFile = ((JSDebugTarget)this.getDebugTarget()).resolveSourceFile(Util.decodeData(args[2]));
                    try {
                        if (BREAKPOINT.equals(reason)) {
                            this.breakpointHit(sourceFile, Integer.parseInt(args[3]));
                            break block26;
                        }
                        int type = 0;
                        if (KEYWORD.equals(reason)) {
                            type = 1;
                        } else if (FIRST_LINE.equals(reason)) {
                            type = 2;
                        } else if (EXCEPTION.equals(reason)) {
                            type = 3;
                        } else if (WATCHPOINT.equals(reason)) {
                            type = 4;
                        }
                        this.implicitBreakpointHit(sourceFile, Integer.parseInt(args[3]), type);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (reason.startsWith(STEP)) {
                    details = 8;
                } else {
                    details = 32;
                    this.stackFrames = null;
                }
            }
            this.fireSuspendEvent(details);
            this.fireChangeEvent(256);
        } else if (RESUMED.equals(action)) {
            String reason = args[1];
            if (STEP_INTO.equals(reason)) {
                details = 1;
            } else if (STEP_OVER.equals(reason)) {
                details = 2;
            } else if (STEP_RETURN.equals(reason) || STEP_TO_FRAME.equals(reason)) {
                details = 4;
            } else if (RESUME.equals(reason)) {
                details = 32;
                this.runningState = 1;
            } else {
                this.runningState = ABORT.equals(reason) || START.equals(reason) ? 1 : 1;
            }
            if (reason.startsWith(STEP) && this.stackFrames != null && this.stackFrames.length == 1) {
                details = 32;
            }
            this.fireChangeEvent(256);
            this.fireResumeEvent(details);
        }
    }

    private void breakpointHit(String filename, int lineNumber) {
        IBreakpoint[] iBreakpointArray;
        IBreakpoint breakpoint = ((JSDebugTarget)this.getDebugTarget()).findBreakpointAt(filename, lineNumber);
        if (breakpoint != null && breakpoint instanceof IJSLineBreakpoint) {
            try {
                if (((IJSLineBreakpoint)breakpoint).getHitCount() > 0) {
                    breakpoint.setEnabled(false);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
        }
        if (breakpoint != null) {
            IBreakpoint[] iBreakpointArray2 = new IBreakpoint[1];
            iBreakpointArray = iBreakpointArray2;
            iBreakpointArray2[0] = breakpoint;
        } else {
            iBreakpointArray = null;
        }
        this.breakpoints = iBreakpointArray;
    }

    private void implicitBreakpointHit(String filename, int line, int type) {
        this.breakpoints = new IBreakpoint[]{new JSDebugImplicitBreakpoint(filename, line, type)};
    }

    private synchronized void getStackFrames0() throws DebugException {
        if (!this.validateFrames && this.stackFrames != null) {
            return;
        }
        String[] args = ((JSDebugTarget)this.getDebugTarget()).getConnection().sendCommandAndWait(FRAMES);
        if (args != null) {
            Vector<JSDebugStackFrame> frames = new Vector<JSDebugStackFrame>();
            JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
            int frameIndex = this.stackFrames != null ? this.stackFrames.length - 1 : -1;
            int i = args.length - 1;
            while (i >= 1) {
                int j = 0;
                String[] subargs = args[i].split(SUBARGS_SPLIT);
                int depth = Integer.parseInt(subargs[j++]);
                String function = Util.decodeData(subargs[j++]);
                String arguments = Util.decodeData(subargs[j++]);
                function = function.length() == 0 ? StringUtils.format((String)"[{0}]", (String)(i == args.length - 1 ? Messages.JSDebugTarget_TopLevelScript : Messages.JSDebugTarget_EvalScript)) : String.valueOf(function) + StringUtils.format((String)"({0})", (String)arguments);
                String sourceFile = target.resolveSourceFile(Util.decodeData(subargs[j++]));
                int sourceLine = Integer.parseInt(subargs[j++]);
                int n = ++j;
                int pc = Integer.parseInt(subargs[n]);
                int n2 = ++j;
                ++j;
                int scriptTag = Integer.parseInt(subargs[n2]);
                JSDebugStackFrame frame = null;
                if (frameIndex >= 0) {
                    JSDebugStackFrame oldFrame = (JSDebugStackFrame)this.stackFrames[frameIndex];
                    if (oldFrame.scriptTag == scriptTag && oldFrame.pc == pc) {
                        oldFrame.invalidate(depth, sourceLine, pc);
                        frame = oldFrame;
                        --frameIndex;
                    } else if (oldFrame.scriptTag == scriptTag) {
                        oldFrame.invalidate(depth, sourceLine, pc);
                        frameIndex = -1;
                    } else {
                        frameIndex = -1;
                    }
                }
                if (frame == null) {
                    frame = new JSDebugStackFrame(target, this, depth, function, sourceFile, sourceLine, pc, scriptTag);
                }
                frames.add(0, frame);
                --i;
            }
            this.stackFrames = frames.toArray(new IStackFrame[frames.size()]);
            this.validateFrames = false;
        }
    }

    private void invalidateStackFrames() {
        if (this.stackFrames != null) {
            int i = 0;
            while (i < this.stackFrames.length) {
                ((JSDebugStackFrame)this.stackFrames[i]).invalidate();
                ++i;
            }
        }
        this.validateFrames = true;
    }

    protected void stepToFrame(IStackFrame frame) throws DebugException {
        if (this.runningState != 2) {
            return;
        }
        int targetFrameId = ((JSDebugStackFrame)frame).getFrameId();
        this.runningState = 4;
        this.fireChangeEvent(256);
        ((JSDebugTarget)this.getDebugTarget()).getConnection().sendCommand(StringUtils.format((String)STEP_TO_FRAME_0, (int)targetFrameId));
    }
}

