/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.debug.core.model.IJSScriptElement;
import com.aptana.ide.debug.internal.core.model.JSDebugElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.model.IDebugTarget;

public class JSDebugScriptElement
extends JSDebugElement
implements IJSScriptElement {
    private static final IJSScriptElement[] EMPTY = new IJSScriptElement[0];
    private IJSScriptElement parent;
    private String name;
    private int baseLine = -1;
    private int lineExtent = -1;
    private List<IJSScriptElement> children = new ArrayList<IJSScriptElement>();

    protected JSDebugScriptElement(IDebugTarget target, String name) {
        super(target);
        this.name = name;
    }

    public JSDebugScriptElement(IDebugTarget target, String name, int baseLine, int lineExtent) {
        super(target);
        this.name = name;
        this.baseLine = baseLine;
        this.lineExtent = lineExtent;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.getParent().getLocation();
    }

    public IJSScriptElement[] getChildren() {
        if (this.children.size() > 0) {
            return this.children.toArray(new IJSScriptElement[this.children.size()]);
        }
        return EMPTY;
    }

    public IJSScriptElement getParent() {
        return this.parent;
    }

    public int getBaseLine() {
        return this.baseLine;
    }

    public int getLineExtent() {
        return this.lineExtent;
    }

    protected void insertElement(JSDebugScriptElement scriptElement) {
        for (JSDebugScriptElement jSDebugScriptElement : this.children) {
            if (jSDebugScriptElement.isScriptElementInside(scriptElement)) {
                jSDebugScriptElement.insertElement(scriptElement);
                return;
            }
            if (!scriptElement.isScriptElementInside(jSDebugScriptElement)) continue;
            this.children.remove(jSDebugScriptElement);
            scriptElement.insertElement(jSDebugScriptElement);
            break;
        }
        this.children.add(scriptElement);
        scriptElement.setParent(this);
    }

    protected void removeElement(JSDebugScriptElement scriptElement) {
    }

    protected boolean isScriptElementInside(JSDebugScriptElement element) {
        return this.baseLine < element.getBaseLine() && element.getBaseLine() + element.getLineExtent() <= this.baseLine + this.lineExtent;
    }

    protected void setParent(IJSScriptElement parent) {
        this.parent = parent;
    }

    protected void setName(String name) {
        this.name = name;
    }
}

