/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PathUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.MarkerUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.model.IJSLineBreakpoint;
import com.aptana.ide.debug.internal.core.model.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

public class JSDebugLineBreakpoint
extends LineBreakpoint
implements IJSLineBreakpoint {
    public JSDebugLineBreakpoint() {
    }

    public JSDebugLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this(resource, lineNumber, new HashMap(), true);
    }

    public JSDebugLineBreakpoint(IUniformResource resource, int lineNumber) throws CoreException {
        this(resource, lineNumber, new HashMap(), true);
    }

    public JSDebugLineBreakpoint(final IResource resource, final int lineNumber, final Map attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.aptana.ide.debug.core.lineBreakpointMarker");
                JSDebugLineBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", new Integer(lineNumber));
                attributes.put("org.eclipse.debug.core.id", JSDebugLineBreakpoint.this.getModelIdentifier());
                attributes.put("message", StringUtils.format((String)Messages.JSDebugLineBreakpoint_JSBreakpoint_0_1, (Object[])new String[]{resource.getFullPath().toString(), Integer.toString(lineNumber)}));
                JSDebugLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugLineBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public JSDebugLineBreakpoint(final IUniformResource resource, final int lineNumber, final Map attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = MarkerUtils.createMarker((IUniformResource)resource, (Map)attributes, (String)"com.aptana.ide.debug.core.lineBreakpointMarker");
                JSDebugLineBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", new Integer(lineNumber));
                attributes.put("org.eclipse.debug.core.id", JSDebugLineBreakpoint.this.getModelIdentifier());
                attributes.put("message", StringUtils.format((String)Messages.JSDebugLineBreakpoint_JSBreakpoint_0_1, (Object[])new String[]{PathUtils.getPath((Object)resource), Integer.toString(lineNumber)}));
                JSDebugLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugLineBreakpoint.this.register(register);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)Messages.JSDebugLineBreakpoint_BreakpointMarkerCreationFailed, (Throwable)e);
        }
    }

    public String getModelIdentifier() {
        return "com.aptana.ide.debug.core";
    }

    public boolean isRunToLine() throws CoreException {
        return this.ensureMarker().getAttribute("com.aptana.ide.debug.core.runToLineBreakpoint", false);
    }

    private void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public int getHitCount() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.ide.debug.core.breakpointHitCount", -1);
        }
        return -1;
    }

    public void setHitCount(int count) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.ide.debug.core.breakpointHitCount", count);
        }
    }

    public String getCondition() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.ide.debug.core.breakpointCondition", "");
        }
        return "";
    }

    public void setCondition(String condition) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.ide.debug.core.breakpointCondition", (Object)condition);
        }
    }

    public boolean isConditionEnabled() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.ide.debug.core.breakpointConditionEnabled", false);
        }
        return false;
    }

    public void setConditionEnabled(boolean enabled) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.ide.debug.core.breakpointConditionEnabled", enabled);
        }
    }

    public boolean isConditionSuspendOnTrue() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.ide.debug.core.breakpointConditionSuspendOnTrue", true);
        }
        return true;
    }

    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.ide.debug.core.breakpointConditionSuspendOnTrue", suspendOnTrue);
        }
    }
}

