/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.browsers;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Firefox {
    public static final String NAME = "Firefox";
    public static final String NEW_WINDOW = "-new-window";
    public static final String NEW_TAB = "-new-tab";
    private static final String[] WIN32_PROFILES_LOCATIONS = new String[]{"%APPDATA%\\Mozilla\\Firefox\\"};
    private static final String[] LINUX_PROFILES_LOCATIONS = new String[]{"~/.mozilla/firefox/"};
    private static final String[] MACOSX_PROFILES_LOCATIONS = new String[]{"~/Library/Application Support/Firefox/", "~/Library/Mozilla/Firefox/"};
    private static final Map<String, String[]> LOCATIONS = new HashMap<String, String[]>();

    static {
        LOCATIONS.put("win32", WIN32_PROFILES_LOCATIONS);
        LOCATIONS.put("linux", LINUX_PROFILES_LOCATIONS);
        LOCATIONS.put("macosx", MACOSX_PROFILES_LOCATIONS);
    }

    private Firefox() {
    }

    public static boolean isBrowserExecutable(String browserExecutable) {
        String name = new File(browserExecutable).getName();
        return name.toLowerCase().indexOf("firefox") != -1;
    }

    public static File findDefaultProfileLocation() {
        String[] locations = LOCATIONS.get(Platform.getOS());
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                String location = PlatformUtils.expandEnvironmentStrings((String)locations[i]);
                File dir = new File(location);
                if (dir.isDirectory() && dir.exists()) {
                    IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Check location {0} for default profile", (String)location));
                    File[] profiles = Firefox.readProfiles(dir);
                    if (profiles.length == 0) {
                        File dirProfiles = new File(dir, "Profiles");
                        if (!dirProfiles.exists() || !dirProfiles.isDirectory()) {
                            dirProfiles = dir;
                        }
                        profiles = dirProfiles.listFiles(new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                return name.endsWith(".default");
                            }
                        });
                    }
                    StringBuffer sb = new StringBuffer();
                    int j = 0;
                    while (j < profiles.length) {
                        if (j != 0) {
                            sb.append(',');
                        }
                        sb.append(profiles[j].toString());
                        ++j;
                    }
                    IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Profiles found: {0}", (String)sb.toString()));
                    j = 0;
                    while (j < profiles.length) {
                        File profile = profiles[j];
                        if (profile.exists() && profile.isDirectory()) {
                            IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Default profile was found at {0}", (String)profile.toString()));
                            return profile;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean installLinkedExtension(URL extensionURL, String extensionID, File dir) {
        boolean result;
        block17: {
            File file = new File(dir, extensionID);
            if (file.exists() && file.isDirectory()) {
                return true;
            }
            IPath base = JSDebugPlugin.getDefault().getStateLocation().addTrailingSeparator();
            result = Firefox.installExtension(extensionURL, extensionID, base.toFile());
            if (result) {
                FileOutputStream out;
                block16: {
                    String linkedPath = base.append(extensionID).toOSString();
                    out = null;
                    try {
                        try {
                            out = new FileOutputStream(file);
                            out.write(linkedPath.getBytes());
                        }
                        catch (IOException e) {
                            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static boolean installExtension(URL extensionURL, String extensionID, File dir) {
        if ((dir = new File(dir, extensionID)).exists()) {
            return true;
        }
        if (!dir.mkdirs()) {
            return false;
        }
        File file = null;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                int n;
                file = File.createTempFile("ffe", ".zip");
                in = extensionURL.openStream();
                out = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                if (file != null) {
                    file.delete();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        try {
            try {
                Firefox.extract(new ZipFile(file), dir);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                file.delete();
                return false;
            }
        }
        finally {
            file.delete();
        }
        return true;
    }

    public static String getExtensionVersion(String extensionID, File profileDir) {
        File installRdf;
        File dir = new File(new File(profileDir, "extensions"), extensionID);
        if (dir.exists() && (installRdf = new File(dir, "install.rdf")).exists()) {
            try {
                NamedNodeMap attrs;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document document = parser.parse(new FileInputStream(installRdf));
                Node node = document.getDocumentElement().getFirstChild();
                while (node != null) {
                    if ("description".equals(node.getNodeName().toLowerCase()) || "rdf:description".equals(node.getNodeName().toLowerCase())) {
                        attrs = node.getAttributes();
                        Node about = attrs.getNamedItem("about");
                        if (about == null) {
                            about = attrs.getNamedItem("RDF:about");
                        }
                        if (about != null && "urn:mozilla:install-manifest".equals(about.getNodeValue())) break;
                    }
                    node = node.getNextSibling();
                }
                if (node != null) {
                    attrs = node.getAttributes();
                    Node version = attrs.getNamedItem("em:version");
                    if (version != null) {
                        return version.getNodeValue();
                    }
                    node = node.getFirstChild();
                }
                while (node != null) {
                    if ("em:version".equals(node.getNodeName().toLowerCase())) break;
                    node = node.getNextSibling();
                }
                if (node != null) {
                    return node.getTextContent();
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
        }
        return null;
    }

    private static void extract(ZipFile zip, File path) throws IOException {
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            File file = new File(path, name);
            if (!entry.isDirectory() || file.exists()) continue;
            file.mkdirs();
        }
        byte[] buffer = new byte[4096];
        Enumeration<? extends ZipEntry> e2 = zip.entries();
        while (e2.hasMoreElements()) {
            int n;
            ZipEntry entry = e2.nextElement();
            String name = entry.getName();
            File file = new File(path, name);
            if (entry.isDirectory() || file.exists() || !file.createNewFile()) continue;
            FileOutputStream out = new FileOutputStream(file);
            InputStream in = zip.getInputStream(entry);
            while ((n = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, n);
            }
            in.close();
            ((OutputStream)out).close();
        }
    }

    private static File[] readProfiles(File dir) {
        ArrayList<File> list;
        block20: {
            list = new ArrayList<File>();
            File profilesIni = new File(dir, "profiles.ini");
            if (profilesIni.exists()) {
                BufferedReader r;
                block19: {
                    r = null;
                    try {
                        try {
                            String line;
                            r = new LineNumberReader(new FileReader(profilesIni));
                            HashMap sections = new HashMap();
                            HashMap<String, String> last = null;
                            Pattern sectionPattern = Pattern.compile("^\\x5B(.*)\\x5D$");
                            Pattern valuePattern = Pattern.compile("^(.[^=]*)=(.*)$");
                            while ((line = ((LineNumberReader)r).readLine()) != null) {
                                Matcher matcher = sectionPattern.matcher(line);
                                if (matcher.find()) {
                                    last = new HashMap<String, String>();
                                    sections.put(matcher.group(1), last);
                                    continue;
                                }
                                if (last == null || !(matcher = valuePattern.matcher(line)).find()) continue;
                                last.put(matcher.group(1), matcher.group(2));
                            }
                            for (String section : sections.keySet()) {
                                if (!section.startsWith("Profile")) continue;
                                Map properties = (Map)sections.get(section);
                                String path = (String)properties.get("Path");
                                String isRelative = (String)properties.get("IsRelative");
                                File profile = isRelative != null && "1".equals(isRelative) ? new File(dir, path) : new File(path);
                                boolean def = properties.containsKey("Default");
                                if (def) {
                                    list.add(0, profile);
                                    continue;
                                }
                                list.add(profile);
                            }
                        }
                        catch (IOException e) {
                            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Reading '{0}' fails", (String)profilesIni.getAbsolutePath()), (Throwable)e);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return list.toArray(new File[list.size()]);
    }
}

