/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core.model;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class JSInspectExpression
extends PlatformObject
implements IErrorReportingExpression,
IDebugEventSetListener {
    private IWatchExpressionResult fResult;
    private String fExpression;
    private IValue fValue;

    public JSInspectExpression(String expression, IValue value) {
        this.fExpression = expression;
        this.fValue = value;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public JSInspectExpression(IWatchExpressionResult result) {
        this(result.getExpressionText(), result.getValue());
        this.fResult = result;
    }

    public boolean hasErrors() {
        return this.fResult != null && this.fResult.hasErrors();
    }

    public String[] getErrorMessages() {
        return JSInspectExpression.getErrorMessages(this.fResult);
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public IDebugTarget getDebugTarget() {
        if (this.fValue != null) {
            return this.fValue.getDebugTarget();
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8 && event.getSource().equals(this.getDebugTarget())) {
                DebugPlugin.getDefault().getExpressionManager().removeExpression((IExpression)this);
            }
            ++i;
        }
    }

    private static String[] getErrorMessages(IWatchExpressionResult result) {
        if (result == null) {
            return new String[0];
        }
        String[] messages = result.getErrorMessages();
        if (messages.length > 0) {
            return messages;
        }
        DebugException exception = result.getException();
        if (exception != null) {
            return new String[]{exception.getMessage()};
        }
        return new String[0];
    }
}

