/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResourceMarker;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.model.IJSDebugTarget;
import com.aptana.ide.debug.core.model.JSDebugModel;
import java.net.URI;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;

public final class JSDebugOptionsManager
implements IDebugEventSetListener {
    public static final String DEBUGGER_ACTIVE = "com.aptana.ide.debug.core.debuggerActive";
    private static JSDebugOptionsManager fgOptionsManager = null;

    private JSDebugOptionsManager() {
    }

    public static JSDebugOptionsManager getDefault() {
        if (fgOptionsManager == null) {
            fgOptionsManager = new JSDebugOptionsManager();
        }
        return fgOptionsManager;
    }

    public void startup() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void shutdown() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof IJSDebugTarget) {
                switch (event.getKind()) {
                    case 4: {
                        System.setProperty(DEBUGGER_ACTIVE, "true");
                        break;
                    }
                    case 8: {
                        System.getProperties().remove(DEBUGGER_ACTIVE);
                        this.cleanupBreakpoints();
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void cleanupBreakpoints() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JSDebugModel.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            try {
                IResource resource;
                IMarker marker = breakpoints[i].getMarker();
                URI uri = null;
                uri = marker instanceof IUniformResourceMarker ? ((IUniformResourceMarker)marker).getUniformResource().getURI() : ((resource = marker.getResource()) instanceof IWorkspaceRoot ? (URI)marker.getAttribute("com.aptana.ide.debug.core.breakpointLocation") : resource.getLocation().makeAbsolute().toFile().toURI());
                if (uri != null && "dbgsource".equals(uri.getScheme())) {
                    breakpoints[i].delete();
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
            ++i;
        }
    }
}

