/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.widgets;

import com.aptana.ide.core.ui.CoreUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;

public class Accordion {
    public static final long DEFAULT_SPEED = 10L;
    public static final int DEFAULT_DRAWER_HEIGHT = 25;
    public static final int DEFAULT_STEP_SIZE = 20;
    public static final Color DRAWER_BACKGROUND = new Color((Device)Display.getDefault(), 200, 200, 200);
    public static final Color DRAWER_TEXT = new Color((Device)Display.getDefault(), 50, 50, 50);
    public static final Image DRAWER_EXPANDED = CoreUIPlugin.getImageDescriptor("icons/minimize.png").createImage();
    public static final Image DRAWER_COLLAPSED = CoreUIPlugin.getImageDescriptor("icons/maximize.png").createImage();
    public static final Image DRAWER_DRAGGER = CoreUIPlugin.getImageDescriptor("icons/dragger.png").createImage();
    public static final int VERTICAL = 512;
    public static final int HORIZONTAL = 256;
    private int drawerHeight;
    private long speed;
    private int orientation;
    private List<Composite> drawers;
    private Cursor handCursor;
    private Cursor sizerCursor;
    private Font handleFont;
    private UIJob accordionJob;
    private Composite accordion;
    private Composite openDrawer;
    private Color drawerBackground;
    private Color drawerText;
    private boolean resizable;
    private int initialCoord;
    private int stepSize;
    private boolean hideWhileSliding;
    private Color alternateDrawFg;
    private Color alternateDrawBg;
    private Image drawerExpanded;
    private Image drawerCollapsed;
    private MouseAdapter clickAdapter = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            Accordion.this.triggerSliding(((Composite)e.widget).getParent());
            int i = 0;
            while (i < Accordion.this.drawers.size()) {
                Composite curr = (Composite)Accordion.this.drawers.get(i);
                curr = Accordion.this.getHandleArea(curr);
                curr.redraw();
                curr.update();
                ++i;
            }
        }
    };

    public Accordion(long speed, int drawerHeight, Color drawerBackground, Color drawerText, int orientation, int stepSize, boolean resizable) {
        this.speed = speed;
        this.drawerHeight = drawerHeight;
        this.drawerBackground = drawerBackground;
        this.drawerText = drawerText;
        this.orientation = orientation;
        this.stepSize = stepSize;
        this.resizable = resizable;
        this.drawers = new ArrayList<Composite>();
        this.initialCoord = -1;
        this.hideWhileSliding = false;
    }

    public Accordion() {
        this(10L, 25, DRAWER_BACKGROUND, DRAWER_TEXT, 256, 20, false);
    }

    public Accordion(long speed) {
        this(speed, 25, DRAWER_BACKGROUND, DRAWER_TEXT, 256, 20, false);
    }

    public Accordion(int drawerHeight) {
        this(10L, drawerHeight, DRAWER_BACKGROUND, DRAWER_TEXT, 256, 20, false);
    }

    public Accordion(int drawerHeight, int orientation) {
        this(10L, drawerHeight, DRAWER_BACKGROUND, DRAWER_TEXT, orientation, 20, false);
    }

    public Accordion(int drawerHeight, int orientation, int stepSize, boolean resizable) {
        this(10L, drawerHeight, DRAWER_BACKGROUND, DRAWER_TEXT, orientation, stepSize, resizable);
    }

    public void dispose() {
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        if (this.handleFont != null) {
            this.handleFont.dispose();
        }
        if (this.alternateDrawFg != null) {
            this.alternateDrawFg.dispose();
        }
    }

    public int getDrawerHeight() {
        return this.drawerHeight;
    }

    public void setDrawerHeight(int drawerHeight) {
        this.drawerHeight = drawerHeight;
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    public Composite addDrawer(String label) {
        return this.addDrawer(label, null, -1);
    }

    public Composite addDrawer(String label, Image handleImage, int imageHeight) {
        return this.addDrawer(label, this.drawerBackground, handleImage, imageHeight);
    }

    public Composite addDrawer(String label, Color drawerColor, Image handleImage, int imageHeight) {
        final Composite drawer = new Composite(this.accordion, 0);
        drawer.setBackground(drawerColor);
        this.drawers.add(drawer);
        if (this.orientation == 512) {
            GridLayout aLayout = (GridLayout)this.accordion.getLayout();
            aLayout.numColumns = this.drawers.size();
            aLayout.makeColumnsEqualWidth = false;
        }
        GridLayout dLayout = new GridLayout(1, true);
        if (this.orientation == 512) {
            dLayout.numColumns = 2;
            dLayout.makeColumnsEqualWidth = false;
        }
        dLayout.marginHeight = 0;
        dLayout.marginWidth = 0;
        dLayout.verticalSpacing = 0;
        dLayout.horizontalSpacing = 0;
        drawer.setLayout((Layout)dLayout);
        GridData dData = new GridData(4, 4, true, true);
        if (this.orientation == 512) {
            dData.grabExcessHorizontalSpace = false;
            dData.grabExcessVerticalSpace = true;
        } else {
            dData.grabExcessHorizontalSpace = true;
            dData.grabExcessVerticalSpace = false;
        }
        drawer.setLayoutData((Object)dData);
        Composite drawerHandler = new Composite(drawer, 0);
        GridLayout dhLayout = new GridLayout(1, true);
        dhLayout.marginHeight = 0;
        dhLayout.marginWidth = 0;
        GridData dhData = new GridData(4, 4, true, true);
        if (this.orientation == 512) {
            dhData.grabExcessHorizontalSpace = false;
            dhData.grabExcessVerticalSpace = true;
            dhData.widthHint = this.drawerHeight;
        } else {
            dhData.heightHint = this.drawerHeight;
            dhData.minimumHeight = this.drawerHeight;
            dhData.grabExcessHorizontalSpace = true;
            dhData.grabExcessVerticalSpace = false;
        }
        if (this.resizable) {
            Composite drawerDragger = new Composite(drawerHandler, 0);
            GridData ddData = new GridData(0x1000008, 0x1000000, true, true);
            ddData.widthHint = 6;
            ddData.heightHint = 20;
            drawerDragger.setLayoutData((Object)ddData);
            drawerDragger.setBackground(this.drawerText);
            drawerDragger.setCursor(this.sizerCursor);
            drawerDragger.setBackgroundImage(DRAWER_DRAGGER);
            drawerDragger.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Accordion.this.initialCoord = e.x;
                }

                public void mouseUp(MouseEvent e) {
                    Accordion.this.initialCoord = -1;
                }
            });
            drawerDragger.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (Accordion.this.initialCoord != -1) {
                        int diff = e.x - Accordion.this.initialCoord;
                        Composite previous = Accordion.this.getPreviousDrawer(drawer);
                        if (previous != null && Accordion.this.openDrawer != null) {
                            Composite open = Accordion.this.openDrawer;
                            if (Accordion.this.openDrawer == previous) {
                                open = drawer;
                            }
                            GridData oData = (GridData)open.getLayoutData();
                            GridData pData = (GridData)previous.getLayoutData();
                            int size = Accordion.this.orientation == 512 ? ((Accordion)Accordion.this).accordion.getSize().x : ((Accordion)Accordion.this).accordion.getSize().y;
                            int max = size - Accordion.this.drawerHeight * (Accordion.this.drawers.size() - 1);
                            if (diff > 0) {
                                if (Accordion.this.orientation == 512) {
                                    if (previous.getSize().x + diff < max && open.getSize().x - diff > Accordion.this.drawerHeight) {
                                        pData.widthHint += diff;
                                        oData.widthHint -= diff;
                                    } else {
                                        pData.widthHint = max;
                                        oData.widthHint = Accordion.this.drawerHeight;
                                    }
                                }
                            } else if (diff < 0 && Accordion.this.orientation == 512) {
                                if (previous.getSize().x + diff > Accordion.this.drawerHeight && open.getSize().x - diff < max) {
                                    pData.widthHint += diff;
                                    oData.widthHint -= diff;
                                } else {
                                    pData.widthHint = Accordion.this.drawerHeight;
                                    oData.widthHint = max;
                                }
                            }
                            if (diff != 0) {
                                Composite area = Accordion.this.getDrawerArea(previous);
                                if (area != null && !area.isVisible()) {
                                    area.setVisible(true);
                                }
                                if ((area = Accordion.this.getDrawerArea(open)) != null && !area.isVisible()) {
                                    area.setVisible(true);
                                }
                                int i = 0;
                                while (i < Accordion.this.drawers.size()) {
                                    Composite drawer2 = (Composite)Accordion.this.drawers.get(i);
                                    Composite dArea = Accordion.this.getDrawerArea(drawer2);
                                    Rectangle bounds = dArea.getBounds();
                                    dArea.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                                    dArea.update();
                                    Composite handle = Accordion.this.getHandleArea(drawer2);
                                    handle.redraw();
                                    handle.layout();
                                    ++i;
                                }
                                Accordion.this.accordion.layout(true);
                            }
                        } else {
                            Accordion.this.initialCoord = -1;
                        }
                    } else {
                        Accordion.this.initialCoord = -1;
                    }
                }
            });
        }
        drawerHandler.setCursor(this.handCursor);
        drawerHandler.setLayout((Layout)dhLayout);
        drawerHandler.setLayoutData((Object)dhData);
        drawerHandler.addMouseListener((MouseListener)this.clickAdapter);
        Composite placeHolder = new Composite(drawer, 0);
        GridData phData = new GridData(4, 4, true, true);
        placeHolder.setLayoutData((Object)phData);
        this.addHandlePainting(drawer, drawerHandler, label, handleImage, imageHeight);
        return drawer;
    }

    private void addHandlePainting(final Composite drawer, final Composite handle, final String label, final Image handleImage, final int imageHeight) {
        handle.setBackground(handle.getDisplay().getSystemColor(22));
        Color bg = handle.getDisplay().getSystemColor(22);
        Color fg = handle.getDisplay().getSystemColor(19);
        if (bg.getBlue() == fg.getBlue() && bg.getRed() == fg.getRed() && bg.getGreen() == fg.getGreen() && this.alternateDrawFg == null) {
            int newBlue = fg.getBlue() - 20 > 0 ? fg.getBlue() - 20 : fg.getBlue();
            int newRed = fg.getRed() - 20 > 0 ? fg.getRed() - 20 : fg.getRed();
            int newGreen = fg.getGreen() - 20 > 0 ? fg.getGreen() - 20 : fg.getGreen();
            this.alternateDrawFg = new Color((Device)handle.getDisplay(), new RGB(newBlue, newRed, newGreen));
        }
        final Image collapsedDrawer = this.drawerCollapsed != null ? this.drawerCollapsed : DRAWER_COLLAPSED;
        final Image expandedDrawer = this.drawerExpanded != null ? this.drawerExpanded : DRAWER_EXPANDED;
        handle.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean expanded;
                Point p = handle.getSize();
                if (p.x == 0 || p.y == 0) {
                    return;
                }
                if (Accordion.this.alternateDrawBg != null) {
                    e.gc.setBackground(Accordion.this.alternateDrawBg);
                } else {
                    e.gc.setBackground(e.display.getSystemColor(22));
                }
                if (Accordion.this.alternateDrawFg != null) {
                    e.gc.setForeground(Accordion.this.alternateDrawFg);
                } else {
                    e.gc.setForeground(e.display.getSystemColor(19));
                }
                e.gc.fillRectangle(0, 0, p.x, p.y);
                e.gc.drawRectangle(0, 0, p.x - 1, p.y - 1);
                e.gc.setForeground(Accordion.this.drawerText);
                if (Accordion.this.orientation == 512 && p.y - 30 > 0) {
                    Image out = null;
                    if (handleImage == null) {
                        Image image = new Image((Device)e.display, p.y - 30, p.x);
                        GC iGc = new GC((Drawable)image);
                        iGc.setForeground(Accordion.this.drawerText);
                        iGc.setFont(Accordion.this.handleFont);
                        iGc.drawText(label, 0, 0, true);
                        ImageData horizData = image.getImageData();
                        ImageData vertData = new ImageData(horizData.height, horizData.width, horizData.depth, horizData.palette);
                        int white = horizData.palette.getPixel(new RGB(255, 255, 255));
                        RGB currRGB = null;
                        int i = 0;
                        while (i < horizData.width) {
                            int j = 0;
                            while (j < horizData.height) {
                                int curr = horizData.getPixel(i, j);
                                currRGB = horizData.palette.getRGB(curr);
                                if (currRGB.red == 255 && currRGB.green == 255 || currRGB.green == 255 && currRGB.blue == 255) {
                                    vertData.setPixel(j, horizData.width - i - 1, white);
                                } else {
                                    vertData.setPixel(j, horizData.width - i - 1, curr);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        iGc.dispose();
                        image.dispose();
                        vertData.transparentPixel = white;
                        out = new Image((Device)e.display, vertData);
                    } else {
                        out = handleImage;
                    }
                    int height = imageHeight;
                    if (height == -1) {
                        height = out.getImageData().height;
                    }
                    int start = p.y - 25 - height >= 0 ? p.y - 25 - height : 0;
                    e.gc.drawImage(out, 0, start);
                    if (handleImage == null) {
                        out.dispose();
                    }
                } else {
                    e.gc.drawString(label, 25, 5, true);
                }
                boolean bl = expanded = drawer == Accordion.this.openDrawer;
                if (expanded) {
                    if (Accordion.this.orientation == 512) {
                        if (p.x - 25 > -1 && p.y - 25 > -1) {
                            e.gc.drawImage(collapsedDrawer, p.x - 25, p.y - 25);
                        }
                    } else {
                        e.gc.drawImage(expandedDrawer, 5, 5);
                    }
                } else if (Accordion.this.orientation == 512) {
                    if (p.x - 25 > -1 && p.y - 25 > -1) {
                        e.gc.drawImage(expandedDrawer, p.x - 25, p.y - 25);
                    }
                } else {
                    e.gc.drawImage(collapsedDrawer, 5, 5);
                }
            }
        });
    }

    private Composite getPreviousDrawer(Composite drawer) {
        Composite previous = null;
        int index = this.drawers.indexOf(drawer);
        if (index > 0) {
            previous = this.drawers.get(index - 1);
        }
        return previous;
    }

    private Composite getNextDrawer(Composite drawer) {
        Composite next = null;
        int index = this.drawers.indexOf(drawer);
        if (index + 1 < this.drawers.size()) {
            next = this.drawers.get(index + 1);
        }
        return next;
    }

    public void setInitialDrawerOpen(Composite drawer) {
        GridData dData = (GridData)drawer.getLayoutData();
        if (this.orientation == 512) {
            dData.grabExcessHorizontalSpace = true;
        } else {
            dData.grabExcessVerticalSpace = true;
        }
        GridData data = (GridData)this.getDrawerArea(drawer).getLayoutData();
        data.exclude = false;
        data.grabExcessVerticalSpace = true;
        this.openDrawer = drawer;
        int i = 0;
        while (i < this.drawers.size()) {
            Composite curr = this.drawers.get(i);
            if (!curr.equals(drawer)) {
                dData = (GridData)curr.getLayoutData();
                if (this.orientation == 512) {
                    dData.widthHint = this.drawerHeight;
                    dData.grabExcessHorizontalSpace = false;
                } else {
                    dData.heightHint = this.drawerHeight;
                    dData.minimumHeight = this.drawerHeight;
                    dData.grabExcessVerticalSpace = false;
                }
                if (this.hideWhileSliding) {
                    Composite area = this.getDrawerArea(curr);
                    area.setVisible(false);
                }
            }
            ++i;
        }
        drawer.layout(true, true);
        this.accordion.layout(true, true);
    }

    public void setHandleBackground(Color color) {
        this.alternateDrawBg = color;
    }

    public void setHandleTrim(Color color) {
        this.alternateDrawFg = color;
    }

    public Composite getDrawerArea(Composite drawer) {
        if (this.drawers.contains(drawer) && drawer != null && drawer.getChildren() != null && drawer.getChildren().length == 2) {
            return (Composite)drawer.getChildren()[1];
        }
        return null;
    }

    private Composite getHandleArea(Composite drawer) {
        if (this.drawers.contains(drawer) && drawer != null && drawer.getChildren() != null && drawer.getChildren().length == 2) {
            return (Composite)drawer.getChildren()[0];
        }
        return null;
    }

    public Control createAccordion(Composite parent) {
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.sizerCursor = new Cursor((Device)parent.getDisplay(), 9);
        this.handleFont = new Font((Device)parent.getDisplay(), "Arial", 14, 0);
        this.accordion = new Composite(parent, 0);
        GridLayout sLayout = new GridLayout(1, true);
        sLayout.marginHeight = 0;
        sLayout.marginWidth = 0;
        sLayout.verticalSpacing = 0;
        sLayout.horizontalSpacing = 0;
        this.accordion.setLayout((Layout)sLayout);
        this.accordion.setLayoutData((Object)new GridData(4, 4, true, true));
        this.accordion.setBackground(this.accordion.getDisplay().getSystemColor(25));
        this.accordion.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                int size = Accordion.this.orientation == 512 ? ((Accordion)Accordion.this).accordion.getSize().x : ((Accordion)Accordion.this).accordion.getSize().y;
                int max = size - Accordion.this.drawerHeight * (Accordion.this.drawers.size() - 1);
                if (Accordion.this.openDrawer != null) {
                    GridData data = (GridData)Accordion.this.openDrawer.getLayoutData();
                    if (Accordion.this.orientation == 512) {
                        data.widthHint = max;
                    } else {
                        data.heightHint = max;
                    }
                    Accordion.this.accordion.layout(true);
                    int i = 0;
                    while (i < Accordion.this.drawers.size()) {
                        Composite handle = Accordion.this.getHandleArea((Composite)Accordion.this.drawers.get(i));
                        handle.redraw();
                        handle.update();
                        ++i;
                    }
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return this.accordion;
    }

    public void triggerSliding(Composite drawerToOpen) {
        if (drawerToOpen == this.openDrawer) {
            Composite other = this.getNextDrawer(drawerToOpen);
            if (other == null) {
                other = this.getPreviousDrawer(drawerToOpen);
            }
            if (other != null) {
                drawerToOpen = other;
            } else {
                return;
            }
        }
        final Composite openingDrawer = drawerToOpen;
        int i = 0;
        while (i < this.drawers.size()) {
            Composite curr = this.drawers.get(i);
            if (curr != drawerToOpen) {
                GridData data = (GridData)this.getDrawerArea(curr).getLayoutData();
                if (curr != this.openDrawer) {
                    data = (GridData)curr.getLayoutData();
                    if (this.orientation == 512) {
                        data.widthHint = this.drawerHeight;
                    } else {
                        data.heightHint = this.drawerHeight;
                        data.minimumHeight = this.drawerHeight;
                    }
                }
            }
            ++i;
        }
        final Composite previousDrawer = this.openDrawer;
        this.openDrawer = drawerToOpen;
        Composite drawerSection = this.getDrawerArea(drawerToOpen);
        GridData newData = (GridData)drawerSection.getLayoutData();
        newData.exclude = false;
        if (this.orientation == 512) {
            newData.grabExcessHorizontalSpace = true;
        } else {
            newData.grabExcessVerticalSpace = true;
        }
        int size = this.orientation == 512 ? this.accordion.getSize().x : this.accordion.getSize().y;
        final int max = size - this.drawerHeight * (this.drawers.size() - 1);
        if (this.accordionJob != null) {
            this.accordionJob.cancel();
        }
        this.accordionJob = new UIJob("Animating Accordion"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (Accordion.this.accordion.isDisposed() || monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Point currSize = openingDrawer.getSize();
                int size = Accordion.this.orientation == 512 ? currSize.x : currSize.y;
                GridData data = (GridData)openingDrawer.getLayoutData();
                if (max > size) {
                    Composite area;
                    if (size + Accordion.this.stepSize < max) {
                        if (Accordion.this.orientation == 512) {
                            data.widthHint = size + Accordion.this.stepSize;
                        } else {
                            data.heightHint = size + Accordion.this.stepSize;
                        }
                    } else {
                        if (Accordion.this.orientation == 512) {
                            data.widthHint = max;
                        } else {
                            data.heightHint = max;
                        }
                        area = Accordion.this.getDrawerArea(openingDrawer);
                        if (Accordion.this.hideWhileSliding && area != null && !area.isVisible()) {
                            area.setVisible(true);
                        }
                    }
                    if (previousDrawer != null) {
                        data = (GridData)previousDrawer.getLayoutData();
                        currSize = previousDrawer.getSize();
                        int n = size = Accordion.this.orientation == 512 ? currSize.x : currSize.y;
                        if (size - Accordion.this.stepSize > Accordion.this.drawerHeight) {
                            if (Accordion.this.orientation == 512) {
                                data.widthHint = size - Accordion.this.stepSize;
                            } else {
                                data.heightHint = size - Accordion.this.stepSize;
                            }
                        } else if (Accordion.this.orientation == 512) {
                            data.widthHint = Accordion.this.drawerHeight;
                        } else {
                            data.heightHint = Accordion.this.drawerHeight;
                            data.minimumHeight = Accordion.this.drawerHeight;
                        }
                        area = Accordion.this.getDrawerArea(previousDrawer);
                        if (Accordion.this.hideWhileSliding && area != null && area.isVisible()) {
                            area.setVisible(false);
                        }
                    }
                    data = (GridData)openingDrawer.getLayoutData();
                    Accordion.this.accordion.layout(true);
                    int n = size = Accordion.this.orientation == 512 ? data.widthHint : data.heightHint;
                    if (size == max) {
                        int i = 0;
                        while (i < Accordion.this.drawers.size()) {
                            Composite handle = Accordion.this.getHandleArea((Composite)Accordion.this.drawers.get(i));
                            handle.redraw();
                            handle.update();
                            ++i;
                        }
                    }
                    this.schedule(Accordion.this.speed);
                }
                return Status.OK_STATUS;
            }
        };
        this.accordionJob.setSystem(true);
        this.accordionJob.setPriority(10);
        this.accordionJob.schedule();
    }

    public Color getDrawerBackground() {
        return this.drawerBackground;
    }

    public void setDrawerBackground(Color drawerBackground) {
        this.drawerBackground = drawerBackground;
    }

    public Color getDrawerText() {
        return this.drawerText;
    }

    public void setDrawerText(Color drawerText) {
        this.drawerText = drawerText;
    }

    public boolean isHideWhileSliding() {
        return this.hideWhileSliding;
    }

    public void setHideWhileSliding(boolean hideWhileSliding) {
        this.hideWhileSliding = hideWhileSliding;
    }

    public void setDrawerCollapsed(Image drawerCollapsed) {
        this.drawerCollapsed = drawerCollapsed;
    }

    public void setDrawerExpanded(Image drawerExpanded) {
        this.drawerExpanded = drawerExpanded;
    }
}

