/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.user;

import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.ui.IValidator;
import com.aptana.ide.core.ui.user.SignInWidget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SignInDialog
extends Dialog
implements IValidator {
    private User user;
    private SignInWidget widget;
    private Button signIn;
    private Button viewAccount;
    private Button signOut;

    public SignInDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(SignInDialog.getDefaultOrientation() | 0x10 | 0x10000 | 0x860);
        this.user = AptanaUser.getSignedInUser();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Aptana ID");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.user.getUsername() != null) {
            this.signOut = this.createButton(parent, 6, "Sign Out", false);
            this.signOut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SignInDialog.this.user.setUsername(null);
                    SignInDialog.this.user.setPassword(null);
                    SignInDialog.this.user.commit();
                    SignInDialog.this.cancelPressed();
                }
            });
            this.viewAccount = this.createButton(parent, 0, "View Account", true);
        } else {
            this.signIn = this.createButton(parent, 0, "Sign In", true);
            this.signIn.setEnabled(false);
            this.signIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SignInDialog.this.widget.save();
                }
            });
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.widget.setValidator(this);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.widget = new SignInWidget();
        this.widget.createControl(c);
        return c;
    }

    public void validate() {
        if (this.signIn != null) {
            this.signIn.setEnabled(this.widget.getErrorMessage() == null);
        } else if (this.viewAccount != null) {
            this.viewAccount.setEnabled(this.widget.getErrorMessage() == null);
        }
    }
}

