/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.install;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.operations.OperationValidator;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationValidator;
import org.eclipse.update.operations.OperationsManager;

public class PlatformValidatorPatcher
implements IStartup {
    private static final String PREF_BACKUP = "prefBackup";

    public void earlyStartup() {
        final IOperationValidator validator = OperationsManager.getValidator();
        OperationsManager.setValidator((IOperationValidator)new OperationValidator(){

            public IStatus validateCurrentState() {
                return validator.validateCurrentState();
            }

            public IStatus validatePendingChanges(IInstallFeatureOperation[] jobs) {
                IStatus validatePendingChanges = validator.validatePendingChanges(jobs);
                if (validatePendingChanges == null || validatePendingChanges.getCode() != 4) {
                    Exception e = new Exception();
                    StackTraceElement[] stackTrace = e.getStackTrace();
                    boolean isFromUI = false;
                    int a = 0;
                    while (a < stackTrace.length) {
                        String className = stackTrace[a].getClassName();
                        if (className.equals("org.eclipse.update.internal.ui.wizards.ReviewPage")) {
                            isFromUI = true;
                            break;
                        }
                        ++a;
                    }
                    if (!isFromUI) {
                        PlatformValidatorPatcher.this.featuresAreGonnaToBeInstalled(jobs);
                    }
                }
                return validatePendingChanges;
            }

            public IStatus validatePendingConfig(IFeature feature) {
                return validator.validatePendingConfig(feature);
            }

            public IStatus validatePendingInstall(IFeature oldFeature, IFeature newFeature) {
                return validator.validatePendingInstall(oldFeature, newFeature);
            }

            public IStatus validatePendingReplaceVersion(IFeature feature, IFeature anotherFeature) {
                return validator.validatePendingReplaceVersion(feature, anotherFeature);
            }

            public IStatus validatePendingRevert(IInstallConfiguration config) {
                return validator.validatePendingRevert(config);
            }

            public IStatus validatePendingUnconfig(IFeature feature) {
                return validator.validatePendingUnconfig(feature);
            }

            public IStatus validatePlatformConfigValid() {
                return validator.validatePlatformConfigValid();
            }
        });
    }

    private void featuresAreGonnaToBeInstalled(IInstallFeatureOperation[] jobs) {
        PlatformValidatorPatcher.exportPreferences();
    }

    public static void exportPreferences() {
        IPreferenceStore preferenceStore = CoreUIPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("com.aptana.ide.core.ui.AUTO_BACKUP_ENABLED")) {
            String string = preferenceStore.getString("com.aptana.ide.core.ui.AUTO_BACKUP_PATH");
            File folder = new File(string);
            folder.mkdirs();
            PlatformValidatorPatcher.doExport(folder);
        }
    }

    public static void doExport(File folder) {
        long currentTimeMillis = System.currentTimeMillis();
        Date dt = new Date(currentTimeMillis);
        DateFormat dateInstance = DateFormat.getDateInstance(3);
        String fDate = dateInstance.format(dt);
        fDate = StringUtils.replace((String)fDate, (String)"/", (String)"_");
        fDate = StringUtils.replace((String)fDate, (String)"\\", (String)"_");
        String fName = FileUtils.ensureValidFilename((String)(PREF_BACKUP + fDate + ".epr"));
        File fl = new File(folder, fName);
        int a = 1;
        while (fl.exists()) {
            fName = FileUtils.ensureValidFilename((String)(PREF_BACKUP + fDate + "v" + a + ".epr"));
            ++a;
            fl = new File(folder, fName);
        }
        PlatformValidatorPatcher.exportPreferences(fl);
        IPreferenceStore preferenceStore = CoreUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.putValue("com.aptana.ide.core.ui.AUTO_BACKUP_LASTNAME", fl.getAbsolutePath());
    }

    public static boolean exportPreferences(File file) {
        IPreferencesService service = Platform.getPreferencesService();
        try {
            FileOutputStream transfers = new FileOutputStream(file);
            String[] fos = new String[]{};
            service.exportPreferences(service.getRootNode(), (OutputStream)transfers, fos);
            transfers.flush();
            transfers.close();
            return true;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Error exporting preferences", (Throwable)e);
            UIJob job = new UIJob("Export Preferences"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)new String(), (String)e.getLocalizedMessage());
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return false;
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Error exporting preferences", (Throwable)e);
            UIJob job = new UIJob("Export Preferences"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)new String(), (String)e.getLocalizedMessage());
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return false;
        }
    }

    public static boolean importPreferences(File file) {
        IPreferencesService service = Platform.getPreferencesService();
        try {
            IStatus importPreferences = service.importPreferences((InputStream)new FileInputStream(file));
            return importPreferences.getCode() == 0;
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Error importing preferences", (Throwable)e);
            UIJob job = new UIJob("Export Preferences"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)new String(), (String)e.getLocalizedMessage());
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return false;
        }
        catch (FileNotFoundException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Error importing preferences", (Throwable)e);
            UIJob job = new UIJob("Export Preferences"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)new String(), (String)e.getLocalizedMessage());
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return false;
        }
    }
}

