/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.install;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.UpdateCore;

public class FirstTimeCleanInstallHandler
extends BaseInstallHandler {
    private String PREF_CLEAN_RESTART = "com.aptana.ide.core.PREF_CLEAN_RESTART";

    public void installInitiated() throws CoreException {
        String id;
        String version;
        String osgiDotOs = System.getProperty("osgi.os");
        if ("win32".equals(osgiDotOs) || "macosx".equals(osgiDotOs)) {
            String[] parts;
            version = System.getProperty("osgi.framework.version");
            if (version != null && version.startsWith("3.") && (parts = version.split("\\.")).length > 1) {
                try {
                    int minorVersion = Integer.parseInt(parts[1]);
                    if (minorVersion > 3) {
                        return;
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            return;
        }
        if (this.feature != null && (version = this.feature.getVersionedIdentifier()) != null && (id = version.getIdentifier()) != null) {
            boolean clean = true;
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] sites = config.getConfiguredSites();
            int i = 0;
            while (i < sites.length && clean) {
                IFeatureReference[] refs = sites[i].getFeatureReferences();
                int j = 0;
                while (j < refs.length && clean) {
                    String fId;
                    VersionedIdentifier ident;
                    IFeatureReference ref = refs[j];
                    IFeature feature = ref.getFeature(null);
                    IConfiguredSite site = ref.getSite().getCurrentConfiguredSite();
                    if (site.isConfigured(feature) && (ident = ref.getVersionedIdentifier()) != null && id.equals(fId = ident.getIdentifier())) {
                        clean = false;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (clean) {
                Preferences preferences = UpdateCore.getPlugin().getPluginPreferences();
                preferences.setValue(this.PREF_CLEAN_RESTART, true);
                UpdateCore.getPlugin().savePluginPreferences();
            }
        }
    }
}

