/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.dialogs;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIPlugin;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class InputURLDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private CCombo combo;
    private Text errorMessageText;
    private String errorMessage;

    public InputURLDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = new IInputValidator(){

            public String isValid(String newText) {
                try {
                    new URI(newText).toURL();
                }
                catch (Exception exception) {
                    return "Invalid URL";
                }
                return null;
            }
        };
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.combo.getText();
            this.saveMemento();
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.loadList();
        this.combo.setFocus();
        if (this.value != null) {
            Button button;
            this.combo.setText(this.value);
            this.setErrorMessage(null);
            if (this.validator.isValid(this.value) != null && (button = this.getButton(0)) != null) {
                button.setEnabled(false);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.combo = new CCombo(composite, this.getInputComboStyle());
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputURLDialog.this.validateInput();
            }
        });
        this.errorMessageText = new Text(composite, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.errorMessageText.setForeground(this.errorMessageText.getDisplay().getSystemColor(3));
        this.setErrorMessage(this.errorMessage);
        InputURLDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected CCombo getText() {
        return this.combo;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            String text = this.combo.getText();
            errorMessage = this.validator.isValid(text);
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected int getInputComboStyle() {
        return 2048;
    }

    protected IMemento getMemento() {
        File file = CoreUIPlugin.getDefault().getStateLocation().append("urls").addFileExtension("xml").toFile();
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                return memento;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"", (Throwable)e);
            }
        }
        return null;
    }

    protected void saveMemento() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"urls");
        this.saveList((IMemento)memento);
        File file = CoreUIPlugin.getDefault().getStateLocation().append("urls").addFileExtension("xml").toFile();
        try {
            FileWriter writer = new FileWriter(file);
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    private final void loadList() {
        IMemento memento = this.getMemento();
        if (memento == null) {
            return;
        }
        IMemento[] list = memento.getChildren("url");
        int i = 0;
        while (i < list.length) {
            this.combo.add(list[i].getTextData());
            ++i;
        }
    }

    protected final void saveList(IMemento memento) {
        String firstItem = this.combo.getText();
        IMemento child = memento.createChild("url");
        child.putTextData(firstItem);
        String[] list = this.combo.getItems();
        int i = 0;
        while (i < list.length) {
            if (!list[i].equals(firstItem)) {
                child = memento.createChild("url");
                child.putTextData(list[i]);
            }
            ++i;
        }
    }
}

