/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.actions;

import com.aptana.ide.core.ui.actions.AbstractWorkbenchWindowPulldownDelegate;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewAction
extends AbstractWorkbenchWindowPulldownDelegate {
    private static final String[] VIEW_IDS = new String[]{"com.aptana.ide", "zigen.plugin.db", "org.eclipse.eclipsemonkey", "org.tigris.subversion.subclipse", "org.eclipse.ui.views.ContentOutline"};
    private Menu toolbarMenu = null;

    public Menu getMenu(Control parent) {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
        }
        this.toolbarMenu = new Menu(parent);
        this.buildMenu(this.toolbarMenu);
        return this.toolbarMenu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.buildMenu(menu);
        return menu;
    }

    private void buildMenu(Menu menu) {
        final IViewRegistry viewsRegistry = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor[] viewDescriptors = viewsRegistry.getViews();
        Arrays.sort(viewDescriptors, new Comparator<IViewDescriptor>(){

            @Override
            public int compare(IViewDescriptor vd1, IViewDescriptor vd2) {
                return vd1.getLabel().compareTo(vd2.getLabel());
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IViewDescriptor viewId = viewsRegistry.find((String)e.widget.getData());
                    if (viewId != null) {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IViewPart view = activePage.showView(viewId.getId(), null, 3);
                        activePage.activate((IWorkbenchPart)view);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        };
        IViewDescriptor[] iViewDescriptorArray = viewDescriptors;
        int n = 0;
        int n2 = iViewDescriptorArray.length;
        while (n < n2) {
            IViewDescriptor viewDescriptor = iViewDescriptorArray[n];
            String viewId = viewDescriptor.getId();
            if (ShowViewAction.isAptanaView(viewId)) {
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText(viewDescriptor.getLabel());
                menuItem.setImage(viewDescriptor.getImageDescriptor().createImage());
                menuItem.setData((Object)viewId);
                menuItem.addSelectionListener((SelectionListener)selAdapter);
            }
            ++n;
        }
    }

    private static boolean isAptanaView(String viewId) {
        if (viewId == null) {
            return false;
        }
        String[] stringArray = VIEW_IDS;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String id = stringArray[n];
            if (viewId.startsWith(id)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

