/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.ui.BrowserLaunchHelper;
import com.aptana.ide.core.ui.OpenFileHelper;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public final class WorkbenchHelper {
    private WorkbenchHelper() {
    }

    public static IViewPart showView(String viewId, IWorkbenchWindow window) throws PartInitException {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            return page.showView(viewId);
        }
        return null;
    }

    public static IViewPart findView(String viewId, IWorkbenchWindow window) throws PartInitException {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            return page.findView(viewId);
        }
        return null;
    }

    public static IEditorPart openFile(File file, IWorkbenchWindow window) {
        return new OpenFileHelper(window).open(file);
    }

    public static IEditorPart openFile(String editorID, File file, IWorkbenchWindow window) {
        return new OpenFileHelper(window).open(editorID, file);
    }

    public static IEditorPart openFile(IFile file, IWorkbenchWindow window) {
        return new OpenFileHelper(window).open(file);
    }

    public static IEditorPart openFile(String editorID, IFile file, IWorkbenchWindow window) {
        return new OpenFileHelper(window).open(editorID, file);
    }

    public static void launchBrowser(String url) {
        BrowserLaunchHelper.launchBrowser(url, null);
    }

    public static void launchBrowser(String url, String browserId) {
        BrowserLaunchHelper.launchBrowser(url, browserId);
    }
}

