/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.EclipseUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.AbstractPerspectiveFactory;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.Messages;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import com.aptana.ide.core.ui.WorkbenchHelper;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.update.core.IFeature;

public class WindowActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final String CLEAR_LOG_ID = "com.aptana.ide.core.ui.actionSet.ClearLog";
    private static final String CLEAN_CONFIG_ID = "com.aptana.ide.core.ui.actionSet.CleanConfiguration";
    private static final String VIEW_LOG_ID = "com.aptana.ide.core.ui.actionSet.ViewLog";
    private static final String LEARN_MORE_ID = "com.aptana.ide.core.ui.actionSet.LearnMore";
    private static final String VIEW_RELEASENOTES_ID = "com.aptana.ide.core.ui.actionSet.ViewReleaseNotes";
    private static final String LICENSE_PREFERENCE_ID = "com.aptana.ide.intro.preferences.LicensePreferencePage";
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        String id = action.getId();
        if (id.equals(VIEW_LOG_ID)) {
            String logFile = WindowActionDelegate.getLogFile();
            try {
                WorkbenchHelper.openFile(new File(logFile), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.WindowActionDelegate_UnableToOpenLogFile, (String)logFile), (Throwable)e);
            }
        } else if (id.equals(CLEAR_LOG_ID)) {
            if (!MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ClearLogConfirmTitle, (String)Messages.ClearLogConfirmDescription)) {
                return;
            }
            String logFile = WindowActionDelegate.getLogFile();
            try {
                File file = new File(logFile);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.close();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.WindowActionDelegate_UnableToOpenLogFile, (String)logFile), (Throwable)e);
            }
        } else if (id.equals("Overview.Action")) {
            String currentPerspectiveID = "com.aptana.ide.js.ui.WebPerspective";
            try {
                IPerspectiveDescriptor desc = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
                if (!WebPerspectiveFactory.isSameOrDescendantPerspective(desc)) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.WindowActionDelegate_AptanaOverviewErrorTitle, (String)Messages.WindowActionDelegate_AptanaOverviewErrorMessage);
                    return;
                }
            }
            catch (Exception exception) {}
            AbstractPerspectiveFactory.showUIHelpPage(currentPerspectiveID);
        } else if (id.equals(VIEW_RELEASENOTES_ID)) {
            CoreUIUtils.openBrowserURL("http://aptana.com/docs/index.php/ReleaseNotes");
        } else if (id.equals(CLEAN_CONFIG_ID)) {
            if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.WindowActionDelegate_CleanConfigurationTitle, (String)Messages.WindowActionDelegate_CleanConfigurationDescription)) {
                return;
            }
            Preferences prefs = EclipseUtils.getUpdatePluginPreferences();
            prefs.setValue("com.aptana.ide.core.PREF_CLEAN_RESTART", true);
            EclipseUtils.saveUpdatePluginPreferences();
            this.window.getWorkbench().restart();
        } else if (id.equals(LEARN_MORE_ID)) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)LICENSE_PREFERENCE_ID, (String[])new String[]{LICENSE_PREFERENCE_ID}, null);
            dialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static IFeature getAptanaFeature() {
        IFeature[] features = AbstractPerspectiveFactory.getFeature("com.aptana.ide.feature.rcp", false);
        if (features.length == 0) {
            features = AbstractPerspectiveFactory.getFeature("com.aptana.ide.feature", false);
        }
        return features[0];
    }

    private static String getLogFile() {
        return System.getProperty("osgi.logfile");
    }
}

